/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.treeview;

import java.awt.Font;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import pyrosim.Intl;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.Floor;
import pyrosim.legacy_2012_1.domain.FloorManager;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.SimParams;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager;
import pyrosim.legacy_2012_1.domain.controls.ControlBridge;
import pyrosim.legacy_2012_1.domain.controls.ControlMgr;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.dependencies.DepUtil;
import pyrosim.legacy_2012_1.domain.dependencies.Dependency;
import pyrosim.legacy_2012_1.domain.devices.DeviceManager;
import pyrosim.legacy_2012_1.domain.devices.IDevice;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.measurers.Clock;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModelMgr;
import pyrosim.legacy_2012_1.domain.evac.Corr;
import pyrosim.legacy_2012_1.domain.evac.CorrList;
import pyrosim.legacy_2012_1.domain.evac.Door;
import pyrosim.legacy_2012_1.domain.evac.DoorList;
import pyrosim.legacy_2012_1.domain.evac.Entr;
import pyrosim.legacy_2012_1.domain.evac.EntrList;
import pyrosim.legacy_2012_1.domain.evac.Evac;
import pyrosim.legacy_2012_1.domain.evac.EvacList;
import pyrosim.legacy_2012_1.domain.evac.Evho;
import pyrosim.legacy_2012_1.domain.evac.EvhoList;
import pyrosim.legacy_2012_1.domain.evac.Evss;
import pyrosim.legacy_2012_1.domain.evac.EvssList;
import pyrosim.legacy_2012_1.domain.evac.Exit;
import pyrosim.legacy_2012_1.domain.evac.ExitList;
import pyrosim.legacy_2012_1.domain.evac.Pers;
import pyrosim.legacy_2012_1.domain.evac.PersList;
import pyrosim.legacy_2012_1.domain.geom.IHole;
import pyrosim.legacy_2012_1.domain.geom.IModelObj;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.InitRegion;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.geom.PartCloud;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.domain.hvac.HvacComponent;
import pyrosim.legacy_2012_1.domain.hvac.HvacList;
import pyrosim.legacy_2012_1.domain.output.IMeasurementStat;
import pyrosim.legacy_2012_1.domain.output.Isosurface;
import pyrosim.legacy_2012_1.domain.output.IsosurfaceMgr;
import pyrosim.legacy_2012_1.domain.output.PlanarSlice;
import pyrosim.legacy_2012_1.domain.output.Plot3d;
import pyrosim.legacy_2012_1.domain.output.ProfList;
import pyrosim.legacy_2012_1.domain.output.ProfRec;
import pyrosim.legacy_2012_1.domain.output.Slice;
import pyrosim.legacy_2012_1.domain.output.SliceList;
import pyrosim.legacy_2012_1.domain.output.StatisticMgr;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.particle.ParticleList;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.domain.reaction.ReactionList;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.domain.tasks.AddTask;
import pyrosim.legacy_2012_1.domain.tasks.AutoRenameTask;
import pyrosim.legacy_2012_1.domain.tasks.ReorderObjectsTask;
import pyrosim.legacy_2012_1.domain.tasks.Tasks;
import pyrosim.legacy_2012_1.domain.zones.Leak;
import pyrosim.legacy_2012_1.domain.zones.Zone;
import pyrosim.legacy_2012_1.domain.zones.ZoneMgr;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ExtrudedPoly;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IProxyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.WallGeom;
import pyrosim.legacy_2012_1.thunderheadeng.gui.DecoratedIcon;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.treeview.TVEntryPoint;
import pyrosim.legacy_2012_1.util.Util;

public class TVEntryPoints {
    private static final Icon s_mgrIcon = PyroGuiUtil.loadPyroSimIcon("manager8.png", 8);
    private static final Map<Class, TVEntryPoint> s_entryPoints;
    private static final TVEntryPoint s_defEP;
    private static final ResultsNode RESULTS_NODE;

    public static <T> TVEntryPoint<T> ep(Class<T> clazz) {
        TVEntryPoint ep = s_entryPoints.get(clazz);
        if (ep == null) {
            ep = theUtil.findObjectForClass(s_entryPoints, clazz);
            if (ep == null) {
                ep = s_defEP;
            }
            s_entryPoints.put(clazz, ep);
        }
        return ep;
    }

    public static <T> TVEntryPoint<T> ep(T obj) {
        if (obj == null) {
            return null;
        }
        return TVEntryPoints.ep(obj.getClass());
    }

    private static boolean isOwnParent(PyroMod md, Set<?> objs, Composite target) {
        for (IPyroObject pobj = target; pobj != null; pobj = pobj.getParent()) {
            if (!objs.contains(pobj)) continue;
            return true;
        }
        return false;
    }

    private static boolean allOfType(Collection<?> objs, Class type) {
        for (Object obj : objs) {
            if (!(obj instanceof Composite ? !type.isAssignableFrom(((Composite)obj).getType()) : !type.isInstance(obj))) continue;
            return false;
        }
        return true;
    }

    private static Icon newMgrIcon(Icon baseIcon) {
        return baseIcon == null ? null : new DecoratedIcon(baseIcon, s_mgrIcon, 3);
    }

    static {
        s_defEP = new TVEntryPoint(Intl.intl("Object"));
        s_entryPoints = new HashMap<Class, TVEntryPoint>();
        s_entryPoints.put(PyroMod.class, new RootEP());
        s_entryPoints.put(Composite.class, new CompositeEP(null, false));
        s_entryPoints.put(MaterialManager.class, new MatlMgrEP());
        s_entryPoints.put(Material.class, new MatlEP());
        s_entryPoints.put(ReactionList.class, new ReacMgrEP());
        s_entryPoints.put(Reaction.class, new ReacEP());
        s_entryPoints.put(SurfaceManager.class, new SurfaceMgrEP());
        s_entryPoints.put(Surface.class, new SurfaceEP());
        s_entryPoints.put(DeviceManager.class, new DevcMgrEP());
        s_entryPoints.put(IDevice.class, new DevcEP());
        s_entryPoints.put(ControlMgr.class, new CtrlMgrEP());
        s_entryPoints.put(ControlBridge.class, new TVEntryPoint(Intl.intl("Control")));
        s_entryPoints.put(GridList.class, new GridMgrEP());
        s_entryPoints.put(Grid.class, new GridEP());
        s_entryPoints.put(ZoneMgr.class, new ZoneMgrEP());
        s_entryPoints.put(Zone.class, new ZoneEP());
        s_entryPoints.put(ModelComposite.class, new CompositeEP((Icon)PyroGuiUtil.loadPyroSimIcon("composite16_2.gif"), false));
        s_entryPoints.put(IModelObj.class, new ModelObjEP());
        s_entryPoints.put(SimParams.class, new SimParamsEP());
        s_entryPoints.put(Plot3d.class, new Plot3dEP());
        s_entryPoints.put(Leak.class, new LeakEP());
        s_entryPoints.put(ExSpecList.class, new ExSpecMgrEP());
        s_entryPoints.put(ExSpec.class, new TVEntryPoint(Intl.intl("Extra Species")));
        s_entryPoints.put(HvacList.class, new CompositeEP(null, true));
        s_entryPoints.put(HvacComponent.class, new TVEntryPoint(Intl.intl("HVAC Component")));
        s_entryPoints.put(ParticleList.class, new CompositeEP(null, true));
        s_entryPoints.put(Particle.class, new TVEntryPoint(Intl.intl("Particle")));
        s_entryPoints.put(HeatLinkModelMgr.class, new CompositeEP(null, true));
        s_entryPoints.put(HeatLinkModel.class, new TVEntryPoint(Intl.intl("Heat Detector Model")));
        s_entryPoints.put(SmokeLinkModelMgr.class, new CompositeEP(null, true));
        s_entryPoints.put(SmokeLinkModel.class, new TVEntryPoint(Intl.intl("Smoke Detector Model")));
        s_entryPoints.put(SprinklerLinkModelMgr.class, new CompositeEP(null, true));
        s_entryPoints.put(SprinklerLinkModel.class, new TVEntryPoint(Intl.intl("Sprinkler Link Model")));
        s_entryPoints.put(SprayModelMgr.class, new CompositeEP(null, true));
        s_entryPoints.put(SprayModel.class, new TVEntryPoint(Intl.intl("Spray Model")));
        s_entryPoints.put(CorrList.class, new CompositeEP(null, true));
        s_entryPoints.put(Corr.class, new TVEntryPoint(Intl.intl("Corridor")));
        s_entryPoints.put(DoorList.class, new CompositeEP(null, true));
        s_entryPoints.put(Door.class, new TVEntryPoint(Intl.intl("Door")));
        s_entryPoints.put(EntrList.class, new CompositeEP(null, true));
        s_entryPoints.put(Entr.class, new TVEntryPoint(Intl.intl("ENTR")));
        s_entryPoints.put(EvacList.class, new CompositeEP(null, true));
        s_entryPoints.put(Evac.class, new TVEntryPoint(Intl.intl("EVAC")));
        s_entryPoints.put(EvhoList.class, new CompositeEP(null, true));
        s_entryPoints.put(Evho.class, new TVEntryPoint(Intl.intl("EVHO")));
        s_entryPoints.put(EvssList.class, new CompositeEP(null, true));
        s_entryPoints.put(Evss.class, new TVEntryPoint(Intl.intl("EVSS")));
        s_entryPoints.put(ExitList.class, new CompositeEP(null, true));
        s_entryPoints.put(Exit.class, new TVEntryPoint(Intl.intl("Exit")));
        s_entryPoints.put(PersList.class, new CompositeEP(null, true));
        s_entryPoints.put(Pers.class, new TVEntryPoint(Intl.intl("PERS")));
        s_entryPoints.put(ResultsNode.class, new ResultsNodeEP());
        s_entryPoints.put(StatisticMgr.class, new StatMgrEP());
        s_entryPoints.put(IMeasurementStat.class, new StatisticEP());
        s_entryPoints.put(SliceList.class, new SliceMgrEP());
        s_entryPoints.put(Slice.class, new SliceEP());
        s_entryPoints.put(IsosurfaceMgr.class, new IsofMgrEP());
        s_entryPoints.put(Isosurface.class, new IsofEP());
        s_entryPoints.put(ProfList.class, new CompositeEP(null, true));
        s_entryPoints.put(ProfRec.class, new TVEntryPoint(Intl.intl("Material Profile")));
        s_entryPoints.put(FloorManager.class, new CompositeEP(null, true));
        s_entryPoints.put(Floor.class, new TVEntryPoint(Intl.intl("Floor")));
        RESULTS_NODE = new ResultsNode();
    }

    public static class RootEP
    extends TVEntryPoint<PyroMod> {
        public RootEP() {
            super(Intl.intl("PyroSim Model"));
        }

        @Override
        public String getName(PyroMod obj) {
            return "";
        }

        @Override
        public boolean objectInModel(PyroMod md, PyroMod obj) {
            return obj == md;
        }

        @Override
        public boolean isLeaf(PyroMod md, PyroMod obj) {
            return false;
        }

        @Override
        public Collection<?> getTreeviewChildren(PyroMod md, PyroMod obj) {
            return Arrays.asList(obj.getGridManager(), obj.getZoneMgr(), obj.getReactions(), obj.getMaterialMgr(), obj.getSurfaceMgr(), obj.getDevices(), obj.getControls(), RESULTS_NODE, obj.getObstructions());
        }

        @Override
        public boolean isContainer(PyroMod md, PyroMod obj, Object child) {
            if (!(child instanceof IPyroObject)) {
                return false;
            }
            for (IPyroObject iPyroObject : obj.getMembers()) {
                if (!iPyroObject.getClass().isInstance(child)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getConflict(PyroMod md, PyroMod categoryRoot, Object child) {
            return child instanceof Plot3d || child instanceof SimParams;
        }

        @Override
        public Task paste(final PyroMod md, PyroMod pasteLoc, Object newObj, Object existingObj, TVEntryPoint.ConflictResolution cr, DepSnapshot deps) {
            assert (cr == TVEntryPoint.ConflictResolution.OVERWRITE_EXISTING);
            if (newObj instanceof Plot3d) {
                return new AReplaceRefTask<Plot3d>(this, existingObj, newObj){

                    @Override
                    protected void set(Plot3d obj) {
                        md.setPL3DRecord(obj);
                    }
                };
            }
            if (newObj instanceof SimParams) {
                return new AReplaceRefTask<SimParams>(this, existingObj, newObj){

                    @Override
                    protected void set(SimParams obj) {
                        md.setSimParams(obj);
                    }
                };
            }
            return super.paste(md, pasteLoc, newObj, existingObj, cr, deps);
        }
    }

    public static class CompositeEP<T extends Composite>
    extends TVEntryPoint<T> {
        private final boolean d_isKeyedByName;

        public CompositeEP(Icon icon, boolean keyedByName) {
            super(icon, Intl.intl("Group"));
            this.d_isKeyedByName = keyedByName;
        }

        @Override
        public boolean isVisible(PyroMod md, T obj) {
            if (((Composite)obj).getMembers().isEmpty()) {
                return true;
            }
            for (IPyroObject child : ((Composite)obj).getMembers()) {
                if (!TVEntryPoints.ep(child).isVisible(md, child)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean keysMembersByName(PyroMod md, T obj) {
            return this.d_isKeyedByName;
        }

        @Override
        public boolean isContainer(PyroMod md, T obj, Object child) {
            return child instanceof IPyroObject && ((Composite)obj).accept((IPyroObject)child);
        }

        @Override
        public boolean canDelete(PyroMod md, T obj, Object child) {
            return true;
        }

        @Override
        public Object getConflict(PyroMod md, T categoryRoot, Object child) {
            if (!(child instanceof Composite) && this.keysMembersByName(md, categoryRoot)) {
                return ((Composite)categoryRoot).get(Util.getName((IPyroObject)child));
            }
            return null;
        }

        @Override
        public Task paste(PyroMod md, T pasteLoc, Object newObj, Object existingObj, TVEntryPoint.ConflictResolution cr, DepSnapshot deps) {
            assert (newObj instanceof IPyroObject && ((Composite)pasteLoc).accept((IPyroObject)newObj));
            assert (existingObj == null || existingObj instanceof IPyroObject && ((Composite)pasteLoc).accept((IPyroObject)existingObj));
            if (existingObj == null) {
                return new AddTask(pasteLoc, new IPyroObject[]{(IPyroObject)newObj});
            }
            CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(md);
            if (cr == TVEntryPoint.ConflictResolution.OVERWRITE_EXISTING) {
                for (Dependency dep : deps.getDependents((IPyroObject)existingObj)) {
                    task.addTask(DepUtil.getReplacementTask(deps, dep.source, (IPyroObject)existingObj, (IPyroObject)newObj));
                }
                task.addTask(Tasks.delete((IPyroObject)existingObj));
            } else {
                Object catRoot = TVEntryPoints.ep(newObj).getCategoryRoot(md, newObj);
                assert (catRoot instanceof Composite);
                if (newObj instanceof INamed) {
                    task.addTask(new AutoRenameTask((Composite)catRoot, new INamed[]{(INamed)newObj}));
                }
            }
            task.addTask(new AddTask(pasteLoc, new IPyroObject[]{(IPyroObject)newObj}));
            return task;
        }

        @Override
        public boolean canDrop(PyroMod md, T obj, Set<?> objs, Object commonParent) {
            if (!(commonParent instanceof Composite)) {
                return false;
            }
            IPyroObject categoryRoot = Hierarchy.getCategoryRoot((Composite)commonParent);
            if (categoryRoot == null) {
                return false;
            }
            return Hierarchy.isDescendent(categoryRoot, obj) && !TVEntryPoints.isOwnParent(md, objs, obj);
        }

        @Override
        public void drop(PyroMod md, T target, int insertPos, Collection<?> objs) {
            ReorderObjectsTask tsk = new ReorderObjectsTask((Composite<? extends IPyroObject>)target, insertPos, (Collection<? extends IPyroObject>)Util.filter(objs, IPyroObject.class));
            md.getTaskManager().exec(tsk, Intl.intl("Reorder Objects"));
        }
    }

    public static class MatlMgrEP
    extends CompositeEP<MaterialManager> {
        public static final Icon ICON_MATLDB = TVEntryPoints.newMgrIcon(PyroGuiUtil.loadPyroSimIcon("surf.png"));

        public MatlMgrEP() {
            super(ICON_MATLDB, true);
        }
    }

    public static class MatlEP
    extends TVEntryPoint<Material> {
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("surf.png");

        public MatlEP() {
            super(ICON, Intl.intl("Material"));
        }
    }

    public static class ReacMgrEP
    extends CompositeEP<ReactionList> {
        public static final Icon ICON_REACT = TVEntryPoints.newMgrIcon(PyroGuiUtil.loadPyroSimIcon("reaction16.gif"));

        public ReacMgrEP() {
            super(ICON_REACT, true);
        }
    }

    public static class ReacEP
    extends TVEntryPoint<Reaction> {
        private static Icon ICON = PyroGuiUtil.loadPyroSimIcon("reaction16.gif");

        public ReacEP() {
            super(ICON, Intl.intl("Reaction"));
        }

        @Override
        public Font getBaseFont(PyroMod md, Reaction obj) {
            if (obj.isActive()) {
                return s_bold;
            }
            return super.getBaseFont(md, obj);
        }

        @Override
        public String getDisplayName(Reaction obj) {
            String name = super.getDisplayName(obj);
            if (obj.isActive()) {
                name = String.format(Intl.intl("%s (Active)"), name);
            }
            return name;
        }
    }

    public static class SurfaceMgrEP
    extends CompositeEP<SurfaceManager> {
        public static final Icon ICON_SURFDB = TVEntryPoints.newMgrIcon(PyroGuiUtil.loadPyroSimIcon("surf2a.gif"));

        public SurfaceMgrEP() {
            super(ICON_SURFDB, true);
        }

        @Override
        public boolean canDelete(PyroMod md, SurfaceManager obj, Object child) {
            return !(child instanceof Surface) || !((Surface)child).isPredefined();
        }
    }

    public static class SurfaceEP
    extends TVEntryPoint<Surface> {
        public static final Icon DEF_ICON = PyroGuiUtil.loadPyroSimIcon("surf2a.gif");

        public SurfaceEP() {
            super(Intl.intl("Surface"));
        }

        @Override
        public Font getBaseFont(PyroMod md, Surface obj) {
            if (obj == md.getSimParams().getMisc().getSurfDefault()) {
                return s_bold;
            }
            return super.getBaseFont(md, obj);
        }

        @Override
        public boolean canRename(PyroMod md, Surface obj) {
            return !obj.isPredefined();
        }

        @Override
        public Icon getIcon(PyroMod md, Surface obj) {
            Icon icon = obj.getIcon(DEF_ICON.getIconWidth(), DEF_ICON.getIconHeight());
            return icon == null ? DEF_ICON : icon;
        }
    }

    public static class DevcMgrEP
    extends CompositeEP<DeviceManager> {
        public static final Icon ICON_DEVICE = PyroGuiUtil.loadPyroSimIcon("sprk3.gif");

        public DevcMgrEP() {
            super(ICON_DEVICE, true);
        }

        @Override
        public Object getConflict(PyroMod md, DeviceManager categoryRoot, Object child) {
            if (Clock.isClock((IPyroObject)child)) {
                return Clock.INSTANCE;
            }
            return super.getConflict(md, categoryRoot, child);
        }
    }

    public static class DevcEP
    extends TVEntryPoint<IDevice> {
        public DevcEP() {
            super(Intl.intl("Device"));
        }

        @Override
        public Icon getIcon(PyroMod md, IDevice obj) {
            return obj.getIcon();
        }
    }

    public static class CtrlMgrEP
    extends CompositeEP<ControlMgr> {
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("or16.png");

        public CtrlMgrEP() {
            super(ICON, true);
        }
    }

    public static class GridMgrEP
    extends CompositeEP<GridList> {
        public static final Icon ICON_GRID = TVEntryPoints.newMgrIcon(PyroGuiUtil.loadPyroSimIcon("3dgrid_smooth16.gif"));

        public GridMgrEP() {
            super(ICON_GRID, true);
        }
    }

    public static class GridEP
    extends TVEntryPoint<Grid> {
        private static Icon ICON = PyroGuiUtil.loadPyroSimIcon("3dgrid_smooth16.gif");
        private static Icon ICON_EVAC = PyroGuiUtil.loadPyroSimIcon("3dgrid_evac16.gif");

        public GridEP() {
            super(Intl.intl("Mesh"));
        }

        @Override
        public Icon getIcon(PyroMod md, Grid obj) {
            return obj.getEvacuation() ? ICON_EVAC : ICON;
        }
    }

    public static class ZoneMgrEP
    extends CompositeEP<ZoneMgr> {
        public static final Icon ICON = TVEntryPoints.newMgrIcon(PyroGuiUtil.loadPyroSimIcon("zones16.png"));

        public ZoneMgrEP() {
            super(ICON, true);
        }

        @Override
        public boolean canDelete(PyroMod md, ZoneMgr obj, Object child) {
            return child instanceof Zone && !((Zone)child).isOuter();
        }
    }

    public static class ZoneEP
    extends TVEntryPoint<Zone> {
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("zones16.png");

        public ZoneEP() {
            super(ICON, Intl.intl("Zone"));
        }

        @Override
        public boolean canRename(PyroMod md, Zone obj) {
            return !obj.isOuter();
        }

        @Override
        public Font getBaseFont(PyroMod md, Zone obj) {
            return obj.isOuter() ? s_bold : super.getBaseFont(md, obj);
        }
    }

    public static class ModelObjEP
    extends TVEntryPoint<IModelObj> {
        public static final Icon VENT_ICON = PyroGuiUtil.loadPyroSimIcon("vent16.gif");
        public static final Icon SLAB_ICON = PyroGuiUtil.loadPyroSimIcon("triangle.png");
        public static final Icon WALL_ICON = PyroGuiUtil.loadPyroSimIcon("block16_2.gif");
        public static final Icon INIT_REGION_ICON = PyroGuiUtil.loadPyroSimIcon("init16.png");
        public static final Icon PART_CLOUD_ICON = PyroGuiUtil.loadPyroSimIcon("partCloud16.gif");
        public static final Icon ABLOCK_ICON = PyroGuiUtil.loadPyroSimIcon("cube16.png");
        public static final Icon AHOLE_ICON = PyroGuiUtil.loadPyroSimIcon("hole16.gif");
        public static final Icon HOLE_ICON = PyroGuiUtil.loadPyroSimIcon("wall_hole16.png");
        public static final Icon GEOMGROUP_ICON = PyroGuiUtil.loadPyroSimIcon("geomgroup16.png");

        public ModelObjEP() {
            super(Intl.intl("Geometric Object"));
        }

        @Override
        public Icon getIcon(PyroMod md, IModelObj obj) {
            IGeom geom = obj.getGeom();
            while (geom instanceof IProxyGeom) {
                geom = ((IProxyGeom)geom).getBase();
            }
            if (geom instanceof AABoxGeom && obj instanceof IObstruction) {
                return ABLOCK_ICON;
            }
            if (geom instanceof AABoxGeom && obj instanceof IHole) {
                return AHOLE_ICON;
            }
            if (geom instanceof WallGeom && obj instanceof IObstruction) {
                return WALL_ICON;
            }
            if (geom instanceof WallGeom && obj instanceof IHole) {
                return HOLE_ICON;
            }
            if (geom instanceof ExtrudedPoly) {
                return SLAB_ICON;
            }
            if (geom instanceof GeomGroup) {
                return GEOMGROUP_ICON;
            }
            if (obj instanceof InitRegion) {
                return INIT_REGION_ICON;
            }
            if (obj instanceof PartCloud) {
                return PART_CLOUD_ICON;
            }
            if (obj instanceof Vent) {
                return VENT_ICON;
            }
            return super.getIcon(md, obj);
        }

        @Override
        public boolean mayBeReferenced(PyroMod md) {
            return false;
        }

        @Override
        public Object getCategoryRoot(PyroMod md, IModelObj obj) {
            return md.getObstructions();
        }
    }

    public static class SimParamsEP
    extends TVEntryPoint<SimParams> {
        public SimParamsEP() {
            super(Intl.intl("Simulation Parameters"));
        }

        @Override
        public String getName(SimParams obj) {
            return this.getCategoryName();
        }

        @Override
        public boolean objectInModel(PyroMod md, SimParams obj) {
            return md.getSimParams() == obj;
        }

        public Task paste(final PyroMod md, Composite<? extends IPyroObject> location, final SimParams newObj, final SimParams existingObj, TVEntryPoint.ConflictResolution cr) {
            return new AUndoableTask(this){

                @Override
                public void run() {
                    md.setSimParams(newObj);
                }

                @Override
                public void undo() {
                    md.setSimParams(existingObj);
                }
            };
        }
    }

    public static class Plot3dEP
    extends TVEntryPoint<Plot3d> {
        public Plot3dEP() {
            super(Intl.intl("Plot3d Output"));
        }

        @Override
        public String getName(Plot3d obj) {
            return this.getCategoryName();
        }

        @Override
        public boolean objectInModel(PyroMod md, Plot3d obj) {
            return md.getPlot3d() == obj;
        }

        public Task paste(final PyroMod md, Composite<? extends IPyroObject> location, final Plot3d newObj, final Plot3d existingObj, TVEntryPoint.ConflictResolution cr) {
            return new AUndoableTask(this){

                @Override
                public void run() {
                    md.setPL3DRecord(newObj);
                }

                @Override
                public void undo() {
                    md.setPL3DRecord(existingObj);
                }
            };
        }
    }

    public static class LeakEP
    extends TVEntryPoint<Leak> {
        public LeakEP() {
            super(Intl.intl("Zone Leak"));
        }

        @Override
        public String getName(Leak obj) {
            return String.format(Intl.intl("Leak: %s -> %s (%s)"), obj.zone1.getName(), obj.zone2.getName(), Global.format(obj.area));
        }
    }

    public static class ExSpecMgrEP
    extends CompositeEP<ExSpecList> {
        public ExSpecMgrEP() {
            super(null, true);
        }

        @Override
        public Object getConflict(PyroMod md, ExSpecList categoryRoot, Object child) {
            if (((ExSpec)child).isMixFracOnly()) {
                return ((ExSpec)child).getMFSpec().spec;
            }
            return super.getConflict(md, categoryRoot, child);
        }
    }

    private static class ResultsNode {
        private ResultsNode() {
        }
    }

    public static class ResultsNodeEP
    extends TVEntryPoint<ResultsNode> {
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("composite16_2.gif");

        public ResultsNodeEP() {
            super(ICON, Intl.intl("Results"));
        }

        @Override
        public boolean isLeaf(PyroMod md, ResultsNode obj) {
            return false;
        }

        @Override
        public boolean objectInModel(PyroMod md, ResultsNode obj) {
            return true;
        }

        @Override
        public Object getTreeviewParent(PyroMod md, ResultsNode obj) {
            return md;
        }

        @Override
        public boolean canRename(PyroMod md, ResultsNode obj) {
            return false;
        }

        @Override
        public String getName(ResultsNode obj) {
            return Intl.intl("Results");
        }

        @Override
        public Collection<?> getTreeviewChildren(PyroMod md, ResultsNode obj) {
            return Arrays.asList(md.getMsrStatMgr(), md.getSlcfList());
        }
    }

    public static class StatMgrEP
    extends CompositeEP<StatisticMgr> {
        public static final Icon ICON = TVEntryPoints.newMgrIcon(PyroGuiUtil.loadPyroSimIcon("stat16.png"));

        public StatMgrEP() {
            super(ICON, true);
        }

        @Override
        public Object getTreeviewParent(PyroMod md, StatisticMgr obj) {
            if (obj == md.getMsrStatMgr()) {
                return RESULTS_NODE;
            }
            return super.getTreeviewParent(md, obj);
        }
    }

    public static class StatisticEP
    extends TVEntryPoint<IMeasurementStat> {
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("stat16.png");

        public StatisticEP() {
            super(ICON, Intl.intl("Statistic"));
        }
    }

    public static class SliceMgrEP
    extends CompositeEP<SliceList> {
        private static final Icon ICON = TVEntryPoints.newMgrIcon(PyroGuiUtil.loadPyroSimIcon("slices16.png"));

        public SliceMgrEP() {
            super(ICON, false);
        }

        @Override
        public Object getTreeviewParent(PyroMod md, SliceList obj) {
            if (obj == md.getSlcfList()) {
                return RESULTS_NODE;
            }
            return super.getTreeviewParent(md, obj);
        }

        @Override
        public Object getConflict(PyroMod md, SliceList categoryRoot, Object child) {
            for (Slice existing : md.getSlcfList().flatten()) {
                if (!existing.equals(child)) continue;
                return existing;
            }
            return null;
        }
    }

    public static class SliceEP
    extends TVEntryPoint<Slice> {
        private static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("slices16.png");

        public SliceEP() {
            super(ICON, Intl.intl("Slice"));
        }

        @Override
        public String getName(Slice obj) {
            if (obj instanceof PlanarSlice) {
                PlanarSlice ps = (PlanarSlice)obj;
                Object name = "";
                switch (ps.getPlane()) {
                    case 0: {
                        name = Intl.intl("X");
                        break;
                    }
                    case 1: {
                        name = Intl.intl("Y");
                        break;
                    }
                    case 2: {
                        name = Intl.intl("Z");
                    }
                }
                name = (String)name + " = " + Global.format(ps.getLocation());
                name = (String)name + ": " + ps.getQuantity().getDescription();
                return name;
            }
            return super.getName(obj);
        }
    }

    public static class IsofMgrEP
    extends CompositeEP<IsosurfaceMgr> {
        public IsofMgrEP() {
            super(null, false);
        }

        @Override
        public Object getConflict(PyroMod md, IsosurfaceMgr categoryRoot, Object child) {
            for (Isosurface existing : md.getIsofList().flatten()) {
                if (!existing.equals(child)) continue;
                return existing;
            }
            return null;
        }
    }

    public static class IsofEP
    extends TVEntryPoint<Isosurface> {
        public IsofEP() {
            super(Intl.intl("Isosurface"));
        }

        @Override
        public String getName(Isosurface obj) {
            return obj.getQuantity().getDescription();
        }
    }
}

