/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Disposable;

public class theUtil {
    private static final float[] R = new float[]{0.4f, 0.6f};
    private static final float[] G = new float[]{0.4f, 0.6f};
    private static final float[] B = new float[]{0.5f, 0.8f};
    private static final Random DEF_RAND = new Random();

    public static boolean equal(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
    }

    public static int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static int hashCode(double d) {
        long v = Double.doubleToLongBits(d);
        return (int)(v ^ v >>> 32);
    }

    public static int hashCode(boolean b) {
        return b ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    public static <T> Collection<T> cast(Collection<?> orig, Collection<T> result, Class<T> resultType) {
        for (Object o : orig) {
            result.add(resultType.cast(o));
        }
        return result;
    }

    public static Vector3d projectToPlane(Vector3d planeNormal, Vector3d point) {
        Vector3d projPoint = new Vector3d(point);
        double dist = planeNormal.dot(projPoint);
        Vector3d moveVec = new Vector3d(planeNormal);
        moveVec.scale(-dist);
        projPoint.add(moveVec);
        return projPoint;
    }

    public static double angleBetweenNPIToPPI(Vector3d axis, Vector3d ref, Vector3d vec) {
        double angle = ref.angle(vec);
        Vector3d cross = new Vector3d();
        cross.cross(ref, vec);
        double dot = cross.dot(axis);
        if (dot >= 0.0) {
            return angle;
        }
        return -angle;
    }

    public static double angleBetween0To2PI(Vector3d axis, Vector3d v1, Vector3d v2) {
        double anglePIPI = theUtil.angleBetweenNPIToPPI(axis, v1, v2);
        if (anglePIPI >= 0.0) {
            return anglePIPI;
        }
        return Math.PI * 2 + anglePIPI;
    }

    public static UnitDouble roundAngle(UnitDouble angle, UnitDouble nearestInc, Unit u) {
        double angleRad = angle.getValue(SI.RADIAN);
        double nearestIncRad = nearestInc.getValue(SI.RADIAN);
        long numRevs = Math.round(Math.PI * 2 / nearestIncRad);
        long mult = Math.round(Math.abs(angleRad) / nearestIncRad) % numRevs;
        if (angleRad < 0.0) {
            mult = -mult;
        }
        double nativeValue = nearestInc.getValueNoUnit() * (double)mult;
        double convertedValue = UnitDouble.convert(nativeValue, nearestInc.getUnit(), u);
        return new UnitDouble(convertedValue, u);
    }

    public static Point3d p4dTo3d(Point4d p) {
        double invw = 1.0 / p.w;
        return new Point3d(p.x * invw, p.y * invw, p.z * invw);
    }

    public static void acquire(Disposable obj) {
        if (obj != null) {
            obj.acquire();
        }
    }

    public static void acquire(Disposable[] objs) {
        if (objs != null) {
            for (int m = 0; m < objs.length; ++m) {
                if (objs[m] == null) continue;
                objs[m].acquire();
            }
        }
    }

    public static <T> void acquire(Collection<T> objs) {
        if (objs != null) {
            for (T obj : objs) {
                theUtil.acquire(obj);
            }
        }
    }

    public static void acquire(Object obj) {
        if (obj instanceof Disposable) {
            ((Disposable)obj).acquire();
        }
    }

    public static void acquire(Object[] objs) {
        if (objs != null) {
            for (int m = 0; m < objs.length; ++m) {
                if (!(objs[m] instanceof Disposable)) continue;
                ((Disposable)objs[m]).acquire();
            }
        }
    }

    public static void release(Disposable obj) {
        if (obj != null) {
            obj.release();
        }
    }

    public static void release(Disposable[] objs) {
        if (objs != null) {
            for (int m = 0; m < objs.length; ++m) {
                if (objs[m] == null) continue;
                objs[m].release();
            }
        }
    }

    public static <T> void release(Collection<T> objs) {
        if (objs != null) {
            for (T obj : objs) {
                theUtil.release(obj);
            }
        }
    }

    public static void release(Object obj) {
        if (obj instanceof Disposable) {
            ((Disposable)obj).release();
        }
    }

    public static void release(Object[] objs) {
        if (objs != null) {
            for (int m = 0; m < objs.length; ++m) {
                if (!(objs[m] instanceof Disposable)) continue;
                ((Disposable)objs[m]).release();
            }
        }
    }

    public static String getFileExtension(File f) {
        String name = f.getAbsolutePath();
        int extix = name.lastIndexOf(".");
        if (extix >= 0 && extix < name.length() - 1) {
            return name.substring(extix + 1);
        }
        return "";
    }

    public static int binarySearch(double[] a, double key, DoubleComparator comp) {
        return theUtil.binarySearch(a, key, 0, a.length - 1, comp);
    }

    private static int binarySearch(double[] a, double key, int low, int high, DoubleComparator comp) {
        while (low <= high) {
            int mid = low + high >> 1;
            double midVal = a[mid];
            int cmp = comp.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static <T> int binarySearch(List<? extends T> list, T key, Comparator<? super T> comp) {
        return theUtil.binarySearch(list, key, 0, list.size() - 1, comp);
    }

    public static <T> int binarySearch(List<? extends T> list, T key, int low, int high, Comparator<? super T> comp) {
        while (low <= high) {
            int mid = low + high >> 1;
            T midVal = list.get(mid);
            int cmp = comp.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static <T extends Number> int[] toIntArray(Collection<T> coll) {
        if (coll == null) {
            return new int[0];
        }
        int[] values = new int[coll.size()];
        int index = 0;
        for (Number val : coll) {
            values[index++] = val.intValue();
        }
        return values;
    }

    public static Integer[] toIntArray(int ... vals) {
        Integer[] arr = new Integer[vals.length];
        for (int m = 0; m < vals.length; ++m) {
            arr[m] = vals[m];
        }
        return arr;
    }

    public static <T extends Number> double[] toDoubleArray(Collection<T> coll) {
        if (coll == null) {
            return new double[0];
        }
        double[] values = new double[coll.size()];
        int ix = 0;
        for (Number val : coll) {
            values[ix++] = val.doubleValue();
        }
        return values;
    }

    public static <T extends Number> double[] toDoubleArray(Double[] vals) {
        return theUtil.toDoubleArray(Arrays.asList(vals));
    }

    public static <T> T[] toArray(Collection<T> coll, Class<T> type) {
        assert (type != null);
        if (coll == null) {
            return (Object[])Array.newInstance(type, 0);
        }
        Object[] array = (Object[])Array.newInstance(type, coll.size());
        return coll.toArray(array);
    }

    public static <T> T serialCopy(T obj) throws IOException, NotSerializableException {
        try {
            ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bufferStream);
            os.writeObject(obj);
            os.close();
            byte[] data = bufferStream.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            ObjectInputStream is = new ObjectInputStream(inputStream);
            return (T)is.readObject();
        }
        catch (ClassNotFoundException e) {
            assert (false);
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public static double doubleResolution(double val) {
        long lval = Double.doubleToLongBits(val);
        return Double.longBitsToDouble(++lval) - val;
    }

    public static float floatResolution(float val) {
        int ival = Float.floatToIntBits(val);
        return Float.intBitsToFloat(++ival) - val;
    }

    public static int[] randomList(int min, int max) {
        return theUtil.randomList(min, max, new Random());
    }

    public static int[] randomList(int min, int max, Random rand) {
        ArrayList<Integer> ints = new ArrayList<Integer>(max - min + 1);
        for (int m = min; m <= max; ++m) {
            ints.add(m);
        }
        Collections.shuffle(ints, rand);
        return theUtil.toIntArray(ints);
    }

    public static <T> List<T> randomize(Collection<? extends T> coll) {
        return theUtil.randomize(coll, new Random());
    }

    public static <T> List<T> randomize(Collection<? extends T> coll, Random rand) {
        ArrayList<? extends T> list = new ArrayList<T>(coll);
        Collections.shuffle(list, rand);
        return list;
    }

    public static <T> Collection<T> sort(Comparator<T> comparator, T ... objs) {
        return theUtil.sort(comparator, Arrays.asList(objs));
    }

    public static <T> Collection<T> sort(Comparator<T> comparator, Collection<? extends T> objs) {
        TreeSet<T> set = new TreeSet<T>(comparator);
        set.addAll(objs);
        return set;
    }

    public static <T> T findObjectForClass(Map<Class, T> map, Class type) {
        if (type == null) {
            return null;
        }
        T obj = map.get(type);
        if (obj != null) {
            return obj;
        }
        obj = theUtil.findObjectForClass(map, type.getSuperclass());
        if (obj != null) {
            return obj;
        }
        for (Class<?> ifaceClass : type.getInterfaces()) {
            obj = theUtil.findObjectForClass(map, ifaceClass);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static <T> Collection<T> findObjectsForClass(Map<Class, T> map, Class type, Collection<T> objs) {
        for (Map.Entry<Class, T> entry : map.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            objs.add(entry.getValue());
        }
        return objs;
    }

    public static <T> Collection<T> findObjectsForLowerClass(Map<Class, T> map, Class type, Collection<T> objs) {
        for (Map.Entry<Class, T> entry : map.entrySet()) {
            if (!type.isAssignableFrom(entry.getKey())) continue;
            objs.add(entry.getValue());
        }
        return objs;
    }

    public static <T> T[] append(Class<T> clazz, T[] arr1, T ... arr2) {
        int m;
        Object[] arr = (Object[])Array.newInstance(clazz, arr1.length + arr2.length);
        for (m = 0; m < arr1.length; ++m) {
            arr[m] = arr1[m];
        }
        while (m < arr.length) {
            arr[m] = arr2[m - arr1.length];
            ++m;
        }
        return arr;
    }

    public static int[] append(int[] arr1, int ... arr2) {
        int m;
        int[] arr = new int[arr1.length + arr2.length];
        for (m = 0; m < arr1.length; ++m) {
            arr[m] = arr1[m];
        }
        while (m < arr.length) {
            arr[m] = arr2[m - arr1.length];
            ++m;
        }
        return arr;
    }

    public static Color newRandomColor() {
        return theUtil.newRandomColor(DEF_RAND, R[0], R[1], G[0], G[1], B[0], B[1]);
    }

    public static Color newRandomColor(float minRed, float maxRed, float minGreen, float maxGreen, float minBlue, float maxBlue) {
        return theUtil.newRandomColor(DEF_RAND, minRed, maxRed, minGreen, maxGreen, minBlue, maxBlue);
    }

    public static Color newRandomColor(Random rand, float minRed, float maxRed, float minGreen, float maxGreen, float minBlue, float maxBlue) {
        return new Color(theUtil.randomFloat(rand, minRed, maxRed), theUtil.randomFloat(rand, minGreen, maxGreen), theUtil.randomFloat(rand, minBlue, maxBlue));
    }

    private static float randomFloat(Random rand, float min, float max) {
        float dx = max - min;
        return rand.nextFloat() * dx + min;
    }

    public static final boolean le(double v1, double v2, double tol) {
        return v1 - v2 <= tol;
    }

    public static final boolean le0(double v, double tol) {
        return v <= tol;
    }

    public static final boolean ge(double v1, double v2, double tol) {
        return v1 - v2 >= -tol;
    }

    public static final boolean ge0(double v, double tol) {
        return v >= -tol;
    }

    public static final boolean lt(double v1, double v2, double tol) {
        return v1 - v2 < -tol;
    }

    public static final boolean lt0(double v, double tol) {
        return v < -tol;
    }

    public static final boolean gt(double v1, double v2, double tol) {
        return v1 - v2 > tol;
    }

    public static final boolean gt0(double v, double tol) {
        return v > tol;
    }

    public static final boolean eq(double v1, double v2, double tol) {
        return Math.abs(v1 - v2) <= tol;
    }

    public static final boolean eq0(double v, double tol) {
        return Math.abs(v) <= tol;
    }

    public static int compare(double d1, double d2, double epsilon) {
        if (Math.abs(d1 - d2) <= epsilon) {
            return 0;
        }
        if (d1 > d2) {
            return 1;
        }
        return -1;
    }

    public static <T> boolean containsEquiv(T obj, T ... list) {
        for (T listObj : list) {
            if (!listObj.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T obj, T ... list) {
        for (T listObj : list) {
            if (listObj != obj) continue;
            return true;
        }
        return false;
    }

    public static byte toCCb(float ccf) {
        return (byte)(ccf * 255.0f);
    }

    public static float toCCf(byte ccb) {
        int comp = 0xFF & ccb;
        return (float)comp / 255.0f;
    }

    public static long randomSeed(Random rand) {
        double dseed = -9.223372036854776E18 + rand.nextDouble() * 1.8446744073709552E19;
        return (long)dseed;
    }

    public static <T> List<? extends T> toList(Iterable<? extends T> objs) {
        if (objs instanceof List) {
            return (List)objs;
        }
        return (List)theUtil.toCollection(new ArrayList(), objs);
    }

    public static <T> Set<? extends T> toSet(Iterable<? extends T> objs) {
        if (objs instanceof Set) {
            return (Set)objs;
        }
        return (Set)theUtil.toCollection(new HashSet(), objs);
    }

    public static <T> Collection<? extends T> toCollection(Iterable<? extends T> objs) {
        if (objs instanceof Collection) {
            return (Collection)objs;
        }
        return theUtil.toCollection(new ArrayList(), objs);
    }

    private static <T> Collection<? extends T> toCollection(Collection<T> coll, Iterable<? extends T> objs) {
        for (T obj : objs) {
            coll.add(obj);
        }
        return coll;
    }

    public static double lerp(double v1, double v2, double t) {
        return (v2 - v1) * t + v1;
    }

    public static void assignFinalField(Object obj, String strField, Object val) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = obj.getClass().getDeclaredField(strField);
        boolean accessible = f.isAccessible();
        f.setAccessible(true);
        f.set(obj, val);
        if (!accessible) {
            f.setAccessible(false);
        }
    }

    public static interface DoubleComparator {
        public int compare(double var1, double var3);
    }
}

