/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UncUtil {
    public static boolean isShared(String filename) throws IOException {
        return UncUtil.isShared(filename, UncUtil.buildSharedMap());
    }

    public static boolean isShared(String filename, Map<String, String> sharedMap) {
        Set<String> sharedSet;
        Iterator<String> iter;
        if (!((String)filename).contains("\\")) {
            filename = (String)filename + "\\";
        }
        if ((iter = (sharedSet = sharedMap.keySet()).iterator()).hasNext()) {
            String key = iter.next();
            if (((String)filename).startsWith(key)) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public static boolean isInAdminShare(String filename) throws IOException {
        return UncUtil.isInAdminShare(filename, UncUtil.buildSharedMap());
    }

    public static boolean isInAdminShare(String filename, Map<String, String> sharedMap) {
        Set<String> sharedSet = sharedMap.keySet();
        ArrayList<String> paths = new ArrayList<String>(sharedSet);
        Collections.sort(paths, new LengthSorter());
        for (int i = 0; i < paths.size(); ++i) {
            String value = sharedMap.get(paths.get(i));
            if (!filename.startsWith((String)paths.get(i))) continue;
            return value.contains("$");
        }
        return false;
    }

    public static String convertToUnc(String filename) throws IOException {
        return UncUtil.convertToUnc(filename, UncUtil.buildSharedMap());
    }

    public static String convertToUnc(String filename, Map<String, String> sharedMap) {
        String value;
        String key;
        int i;
        if (!((String)filename).contains("\\")) {
            filename = (String)filename + "\\";
        }
        Set<String> sharedSet = sharedMap.keySet();
        ArrayList<String> sharedList = new ArrayList<String>(sharedSet);
        Collections.sort(sharedList, new LengthSorter());
        for (i = 0; i < sharedList.size(); ++i) {
            key = (String)sharedList.get(i);
            value = sharedMap.get(key);
            if (!((String)filename).startsWith(key) || value.contains("$")) continue;
            filename = ((String)filename).replace(key, value);
            return filename;
        }
        for (i = 0; i < sharedList.size(); ++i) {
            key = (String)sharedList.get(i);
            value = sharedMap.get(key);
            if (!((String)filename).startsWith(key)) continue;
            filename = ((String)filename).replace(key, value);
            return filename;
        }
        return filename;
    }

    public static Map<String, String> buildSharedMap() throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        String hostname = UncUtil.getHostname();
        Runtime runTime = Runtime.getRuntime();
        Process process = runTime.exec("net share");
        InputStream inStream = process.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String line = null;
        while (null != (line = bufferedReader.readLine())) {
            Object resName;
            String[] components = line.split("\\s+");
            if (components.length < 2) continue;
            Object shareName = components[0];
            if (!((String)shareName).endsWith("\\")) {
                shareName = (String)shareName + "\\";
            }
            if (!((String)(resName = components[1])).contains(":")) continue;
            if (!((String)resName).endsWith("\\")) {
                resName = (String)resName + "\\";
            }
            String uncPrefix = String.format("\\\\%s\\%s", hostname, shareName);
            result.put((String)resName, uncPrefix);
        }
        Process process2 = runTime.exec("net use");
        InputStream is = process2.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        line = null;
        while (null != (line = br.readLine())) {
            String[] components;
            if (line.equals("\\s") || (components = line.split("\\s+")).length <= 1 || !components[1].contains(":")) continue;
            if (!components[2].endsWith("\\")) {
                result.put(components[1] + "\\", components[2] + "\\");
                continue;
            }
            result.put(components[1] + "\\", components[2]);
        }
        return result;
    }

    private static String getHostname() throws IOException {
        InetAddress addr = InetAddress.getLocalHost();
        String hostname = addr.getHostName();
        return hostname;
    }

    public static void main(String[] args) {
        String filename = "C:\\Users\\spare\\Desktop\\MyGreatStuff\\woot.text";
        try {
            if (UncUtil.isShared(filename)) {
                System.out.println("This folder is shared! Lucky you.");
            } else {
                System.out.println("This folder isn't shared.");
            }
            if (UncUtil.isInAdminShare(filename)) {
                System.out.println("Oops. This requires admin access. Are you famous enough?");
            } else {
                System.out.println("This folder is shared with everyone; you're good to go!");
            }
            String newFile = UncUtil.convertToUnc(filename);
            if (newFile.equals(filename)) {
                System.out.println("The conversion didn't work. Boo.");
            } else {
                System.out.printf("Wowzers! You converted %s to UNC. It now says: %s", filename, newFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class LengthSorter
    implements Comparator<Object> {
        private LengthSorter() {
        }

        @Override
        public int compare(Object arg0, Object arg1) {
            if (arg0 == null && arg1 == null) {
                return 0;
            }
            if (arg0 == null && arg1 != null) {
                return -1;
            }
            if (arg0 != null && arg1 == null) {
                return 1;
            }
            return arg0.toString().compareToIgnoreCase(arg1.toString());
        }
    }
}

