/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class SortCache<T>
implements Serializable,
Iterable<T> {
    static final long serialVersionUID = 1L;
    private ArrayList<T> d_ixObjMap;
    private Map<T, Integer> d_objIxMap;

    public SortCache(Collection<? extends T> objs, Comparator<T> sorter) {
        this(theUtil.sort(sorter, objs));
    }

    public SortCache(Collection<? extends T> sortedObjs) {
        this(sortedObjs, true);
    }

    public SortCache(Collection<? extends T> sortedObjs, boolean identityHash) {
        this.d_objIxMap = identityHash ? new IdentityHashMap(sortedObjs.size()) : new HashMap(sortedObjs.size());
        this.d_ixObjMap = new ArrayList(sortedObjs.size());
        int ix = 0;
        for (T obj : sortedObjs) {
            this.d_objIxMap.put(obj, ix++);
            this.d_ixObjMap.add(obj);
        }
        this.d_ixObjMap.trimToSize();
    }

    public T get(int index) {
        return this.d_ixObjMap.get(index);
    }

    public int indexOf(T obj) {
        Integer ix = this.d_objIxMap.get(obj);
        return ix == null ? -1 : ix;
    }

    public int find(T obj, Comparator<T> comp) {
        return theUtil.binarySearch(this.d_ixObjMap, obj, comp);
    }

    public int findGeneric(Object obj, Comparator<Object> comp) {
        return theUtil.binarySearch(this.d_ixObjMap, obj, comp);
    }

    public int size() {
        return this.d_ixObjMap.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.d_ixObjMap.iterator();
    }
}

