/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObservable;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObserver;

public class ObservableProxy
implements IObservable {
    private final IObservable d_owner;
    private boolean d_changed;
    private int d_pauseCounter;
    private List<Object> d_observers;

    public ObservableProxy(IObservable owner) {
        this.d_owner = owner;
        this.d_pauseCounter = 0;
        this.d_changed = false;
        this.d_observers = null;
    }

    @Override
    public synchronized void addObserver(IObserver observer, boolean weakRef) {
        Object ref;
        Object object = ref = weakRef ? new WeakReference<IObserver>(observer) : observer;
        if (this.d_observers == null) {
            this.d_observers = new ArrayList<Object>(5);
        }
        this.d_observers.add(ref);
    }

    @Override
    public synchronized void deleteObserver(IObserver o) {
        if (this.d_observers != null) {
            Iterator<Object> it = this.d_observers.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (next instanceof WeakReference) {
                    WeakReference ref = (WeakReference)next;
                    Object refobj = ref.get();
                    if (refobj != null && refobj != o) continue;
                    it.remove();
                    break;
                }
                if (next != o) continue;
                it.remove();
                break;
            }
            if (this.d_observers.isEmpty()) {
                this.d_observers = null;
            }
        }
    }

    public synchronized int countObservers() {
        return this.d_observers.size();
    }

    private synchronized void fireNotification(Object arg) {
        if (this.d_observers != null) {
            Object[] observers;
            for (Object obj : observers = this.d_observers.toArray(new Object[this.d_observers.size()])) {
                if (obj instanceof WeakReference) {
                    WeakReference ref = (WeakReference)obj;
                    IObserver obs = (IObserver)ref.get();
                    if (obs == null) continue;
                    obs.update(this.d_owner, arg);
                    continue;
                }
                ((IObserver)obj).update(this.d_owner, arg);
            }
        }
    }

    public void pause() {
        ++this.d_pauseCounter;
    }

    public boolean resume() {
        --this.d_pauseCounter;
        assert (this.d_pauseCounter >= 0);
        return this.tryFireNotification(null);
    }

    protected boolean tryFireNotification() {
        return this.tryFireNotification(null);
    }

    protected boolean tryFireNotification(Object objs) {
        if (this.d_pauseCounter == 0 && this.d_changed) {
            this.fireNotification(objs);
            this.d_changed = false;
            return true;
        }
        return false;
    }

    public void setChanged(boolean changed) {
        this.d_changed = changed;
        this.tryFireNotification();
    }
}

