/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Formatter;

public class Global {
    public static String s_engLenFormat = "ft;in;";
    public static final int NUM_DISPLAY_SIG_DIGS = 6;
    public static final Formatter FORMATTER = new Formatter();
    private static Map<Unit, String> s_unitDisplays = new HashMap<Unit, String>();

    public static String formatFixedWidth(double n, int w) {
        return FORMATTER.formatFixedWidth(n, w);
    }

    public static String formatFloat(double n, int w) {
        return FORMATTER.formatFloat(n, w);
    }

    public static String formatSci(double n, int w) {
        return FORMATTER.formatSci(n, w);
    }

    public static String format(double n) {
        return Global.format(n, 6);
    }

    public static String format(double n, int maxPrecision) {
        return FORMATTER.format(n, maxPrecision);
    }

    public static String formatGraph(double number) {
        DecimalFormat df = new DecimalFormat();
        if (Math.abs(number) == 0.0) {
            df.applyPattern("##0.0");
        } else if (Math.abs(number) < 9999.0 && Math.abs(number) >= 100.0) {
            df.applyPattern("###0.0");
        } else if (Math.abs(number) < 100.0 && Math.abs(number) >= 1.0) {
            df.applyPattern("#0.00");
        } else if (Math.abs(number) < 1.0 && Math.abs(number) > 0.099) {
            df.applyPattern("#.000");
        } else {
            df.applyPattern("0.0##E00");
        }
        return df.format(number);
    }

    public static double parseDouble(String origText) throws ParseException {
        Number num;
        int badExp;
        NumberFormat nf = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        Object text = origText.toUpperCase();
        if (((String)text).startsWith("+") && ((String)text).length() > 1) {
            text = ((String)text).substring(1);
        }
        if ((badExp = ((String)text).indexOf("E+")) > 0 && ((String)text).length() > badExp + 1) {
            text = ((String)text).substring(0, badExp) + "E" + ((String)text).substring(badExp + 2, ((String)text).length());
        }
        if ((num = nf.parse(((String)text).toUpperCase(), pos)) == null || pos.getIndex() != ((String)text).length()) {
            String msg = String.format(Intl.intl("Unparseable number: %s"), origText);
            throw new ParseException(msg, pos.getIndex());
        }
        return num.doubleValue();
    }

    public static UnitDouble parseUnitDouble(String value) throws ParseException {
        return Global.parseUnitDouble(value, null);
    }

    public static UnitDouble parseUnitDouble(String value, Unit defUnit) throws ParseException {
        StringTokenizer tok = new StringTokenizer(value, " ");
        int numToks = tok.countTokens();
        if (numToks == 0) {
            return null;
        }
        if (numToks == 1) {
            if (defUnit == null) {
                defUnit = Unit.ONE;
            }
            return new UnitDouble(Global.parseDouble(tok.nextToken()), defUnit);
        }
        double val = Global.parseDouble(tok.nextToken());
        String unitName = tok.nextToken();
        try {
            Unit u = Unit.valueOf(unitName);
            if (defUnit != null && !UnitDouble.areCompatible(u, defUnit)) {
                String msg = String.format(Intl.intl("Invalid unit: \"%1$s\" is incompatible with \"%2$s\"."), unitName, defUnit.toString());
                throw new ParseException(msg, 0);
            }
            return new UnitDouble(val, u);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Throwable e) {
            String txt = String.format(Intl.intl("Unrecognized unit: %s"), unitName);
            throw new ParseException(txt, 0);
        }
    }

    public static String format(UnitDouble val) {
        return Global.format(val.getValueNoUnit(), val.getUnit());
    }

    public static String format(double val, Unit unit) {
        return Global.format(val) + " " + String.valueOf(unit);
    }

    static {
        s_unitDisplays.put(NonSI.FOOT, "'");
        s_unitDisplays.put(NonSI.INCH, "\"");
    }
}

