/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.util.AEventRec;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeEvtRec;
import pyrosim.legacy_2012_1.thunderheadeng.util.EventChannel;
import pyrosim.legacy_2012_1.thunderheadeng.util.IEventObserver;
import pyrosim.legacy_2012_1.thunderheadeng.util.IEventRecord;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.WeakHashSet;

public class Events {
    public static final Object EVT_GENERAL = "Events.EVT_GENERAL";
    private final Set<IEventObserver> d_observers = new WeakHashSet<IEventObserver>();
    private final Map<Class, EventChannel> d_typeChannelMap = new HashMap<Class, EventChannel>();
    private final Map<Class, Set<EventChannel>> d_superclassChannelMap = new HashMap<Class, Set<EventChannel>>();
    private int d_pauseCounter = 0;
    private boolean d_listening = true;
    private int d_lastListeningPos = 0;
    private boolean d_changed = false;
    private boolean d_identityObjHashes;
    private static final IEventRecord EMPTY_EVENT_REC = new AEventRec(){

        @Override
        public boolean isModified() {
            return false;
        }

        @Override
        public Set getAddedObjs() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set getRemovedObjs() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set getChanges() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set getChangedObjs(Object ... changes) {
            return Collections.EMPTY_SET;
        }

        @Override
        public boolean isChanged(Object obj) {
            return false;
        }

        @Override
        public boolean containsChange(Object change) {
            return false;
        }
    };
    private boolean d_tryFireLock = false;

    public Events() {
        this(true);
    }

    public Events(boolean identityObjHashes) {
        this.d_identityObjHashes = identityObjHashes;
    }

    public boolean isListening() {
        return this.d_listening;
    }

    public void addObserver(IEventObserver o) {
        this.d_observers.add(o);
    }

    public void removeObserver(IEventObserver o) {
        this.d_observers.remove(o);
    }

    public void clearObservers() {
        this.d_observers.clear();
    }

    public void resetEvents() {
        this.d_typeChannelMap.clear();
        this.d_superclassChannelMap.clear();
    }

    @Deprecated
    public boolean isChannelAffected(Class type) {
        return !this.isAffected(type);
    }

    public boolean isAffected(Class type) {
        return !this.getAffectedChannels(type, new Class[0]).isEmpty();
    }

    public <T> Set<EventChannel<? extends T>> getAffectedChannels(Class<T> type, Class ... exclusions) {
        IdentityHashSet<EventChannel<T>> affectedChannels = new IdentityHashSet<EventChannel<T>>();
        Set<EventChannel> channels = this.d_superclassChannelMap.get(type);
        if (channels != null) {
            for (EventChannel channel : channels) {
                if (!channel.isModified()) continue;
                affectedChannels.add(channel);
            }
        }
        for (Class exclusion : exclusions) {
            Set<EventChannel> exlChannels = this.d_superclassChannelMap.get(exclusion);
            if (exlChannels == null) continue;
            affectedChannels.removeAll(exlChannels);
        }
        return affectedChannels;
    }

    public <T> IEventRecord<T> getEvents(Class<T> type, Class ... exclusions) {
        Set<EventChannel<T>> channels = this.getAffectedChannels(type, exclusions);
        if (channels.isEmpty()) {
            return EMPTY_EVENT_REC;
        }
        return channels.size() == 1 ? (IEventRecord)channels.iterator().next() : new CompositeEvtRec<T>(channels);
    }

    public void pause() {
        this.pause(true);
    }

    public void pause(boolean listenToEvents) {
        ++this.d_pauseCounter;
        if (!this.d_listening) {
            return;
        }
        this.d_listening = listenToEvents;
        if (this.d_listening) {
            this.d_lastListeningPos = this.d_pauseCounter;
        }
    }

    public boolean resume() {
        assert (this.d_pauseCounter > 0);
        if (this.d_pauseCounter > this.d_lastListeningPos) {
            --this.d_pauseCounter;
            if (this.d_pauseCounter == this.d_lastListeningPos) {
                this.d_listening = true;
            }
            return false;
        }
        --this.d_pauseCounter;
        --this.d_lastListeningPos;
        return this.tryFireNotification();
    }

    public boolean willFireOnResume() {
        return this.d_pauseCounter == 1 && this.d_changed;
    }

    private boolean tryFireNotification() {
        if (this.d_pauseCounter == 0 && this.d_changed) {
            if (this.d_tryFireLock) {
                return false;
            }
            this.d_tryFireLock = true;
            this.fireNotification();
            for (EventChannel channel : this.d_typeChannelMap.values()) {
                channel.eventDispatched();
            }
            this.d_changed = false;
            this.d_tryFireLock = false;
            return true;
        }
        return false;
    }

    protected void fireNotification() {
        for (IEventObserver observer : this.d_observers) {
            observer.update(this);
        }
    }

    public Collection<EventChannel> getChannels() {
        return this.d_typeChannelMap.values();
    }

    public boolean added(Object obj) {
        if (!this.d_listening) {
            return false;
        }
        return this.tryChange(this.getSpecificChannel(obj).added(obj));
    }

    public boolean added(Object ... objs) {
        if (!this.d_listening) {
            return false;
        }
        boolean changed = false;
        for (Object obj : objs) {
            if (!this.getSpecificChannel(obj).added(obj)) continue;
            changed = true;
        }
        return this.tryChange(changed);
    }

    public boolean added(Collection<?> objs) {
        if (!this.d_listening) {
            return false;
        }
        boolean changed = false;
        for (Object obj : objs) {
            changed |= this.getSpecificChannel(obj).added(obj);
        }
        return this.tryChange(changed);
    }

    public boolean removed(Object obj) {
        if (!this.d_listening) {
            return false;
        }
        return this.tryChange(this.getSpecificChannel(obj).removed(obj));
    }

    public boolean removed(Object ... objs) {
        if (!this.d_listening) {
            return false;
        }
        boolean changed = false;
        for (Object obj : objs) {
            if (!this.getSpecificChannel(obj).removed(obj)) continue;
            changed = true;
        }
        return this.tryChange(changed);
    }

    public boolean removed(Collection<?> objs) {
        if (!this.d_listening) {
            return false;
        }
        boolean changed = false;
        for (Object obj : objs) {
            if (!this.getSpecificChannel(obj).removed(obj)) continue;
            changed = true;
        }
        return this.tryChange(changed);
    }

    public boolean changed(Object obj, Object ... changes) {
        if (!this.d_listening) {
            return false;
        }
        return this.tryChange(this.getSpecificChannel(obj).changed(obj, changes));
    }

    public boolean changed(Collection<?> objs, Object ... changes) {
        if (!this.d_listening) {
            return false;
        }
        boolean changed = false;
        for (Object obj : objs) {
            changed |= this.getSpecificChannel(obj).changed(obj, changes);
        }
        return this.tryChange(changed);
    }

    private EventChannel getSpecificChannel(Object o) {
        Class<?> type = o.getClass();
        EventChannel ec = this.d_typeChannelMap.get(type);
        if (ec == null) {
            ec = new EventChannel(type, this.d_identityObjHashes);
            this.d_typeChannelMap.put(type, ec);
            this.associateSuperclassesWithChannel(type, ec);
        }
        return ec;
    }

    private void associateSuperclassesWithChannel(Class clazz, EventChannel channel) {
        if (clazz == null) {
            return;
        }
        Set<EventChannel> channelSet = this.d_superclassChannelMap.get(clazz);
        if (channelSet == null) {
            channelSet = new IdentityHashSet<EventChannel>();
            this.d_superclassChannelMap.put(clazz, channelSet);
        }
        channelSet.add(channel);
        this.associateSuperclassesWithChannel(clazz.getSuperclass(), channel);
        for (Class<?> ifaceClass : clazz.getInterfaces()) {
            this.associateSuperclassesWithChannel(ifaceClass, channel);
        }
    }

    private boolean tryChange(boolean changed) {
        if (changed) {
            this.d_changed = true;
            return this.tryFireNotification();
        }
        return false;
    }
}

