/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.util.AEventRec;
import pyrosim.legacy_2012_1.thunderheadeng.util.Events;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;

public class EventChannel<ObjT>
extends AEventRec<ObjT> {
    public static final Object EVT_GENERAL = Events.EVT_GENERAL;
    private final Set<ObjT> d_adds;
    private final Set<ObjT> d_removes;
    private final Map<Object, Set<ObjT>> d_changeMap;
    private final Class<ObjT> d_type;
    private final boolean d_identityObjHash;

    public EventChannel(Class<ObjT> objType, boolean identityObjHash) {
        this.d_type = objType;
        this.d_identityObjHash = identityObjHash;
        this.d_adds = identityObjHash ? new LinkedIdentityHashSet() : new LinkedHashSet();
        this.d_removes = identityObjHash ? new LinkedIdentityHashSet() : new LinkedHashSet();
        this.d_changeMap = new LinkedHashMap<Object, Set<ObjT>>();
    }

    public Class<ObjT> getObjectType() {
        return this.d_type;
    }

    public boolean handlesSubType(Class type) {
        return type.isAssignableFrom(this.d_type);
    }

    protected Set<ObjT> newObjSet() {
        return this.d_identityObjHash ? new IdentityHashSet() : new HashSet();
    }

    public boolean added(ObjT obj) {
        if (!this.d_removes.remove(obj)) {
            this.d_adds.add(obj);
            return true;
        }
        return this.changed(obj, new Object[0]);
    }

    public boolean added(ObjT ... objs) {
        boolean evtFired = false;
        for (ObjT obj : objs) {
            if (!this.added(obj)) continue;
            evtFired = true;
        }
        return evtFired;
    }

    public boolean added(Collection<? extends ObjT> objs) {
        boolean evtFired = false;
        for (ObjT obj : objs) {
            if (!this.added(obj)) continue;
            evtFired = true;
        }
        return evtFired;
    }

    private void removeChangesTo(ObjT obj) {
        Iterator<Map.Entry<Object, Set<ObjT>>> changeIt = this.d_changeMap.entrySet().iterator();
        while (changeIt.hasNext()) {
            Map.Entry<Object, Set<ObjT>> entry = changeIt.next();
            Set<ObjT> objs = entry.getValue();
            if (!objs.remove(obj) || !objs.isEmpty()) continue;
            changeIt.remove();
        }
    }

    private void addChangeTo(ObjT obj, Object change) {
        Set<ObjT> changedObjs = this.d_changeMap.get(change);
        if (changedObjs == null) {
            changedObjs = this.newObjSet();
            this.d_changeMap.put(change, changedObjs);
        }
        changedObjs.add(obj);
    }

    public boolean removed(ObjT obj) {
        if (!this.d_adds.remove(obj)) {
            this.removeChangesTo(obj);
            this.d_removes.add(obj);
            return true;
        }
        return false;
    }

    public boolean removed(ObjT ... objs) {
        boolean evtFired = false;
        for (ObjT obj : objs) {
            evtFired |= this.removed(obj);
        }
        return evtFired;
    }

    public boolean removed(Collection<? extends ObjT> objs) {
        boolean evtFired = false;
        for (ObjT obj : objs) {
            evtFired |= this.removed(obj);
        }
        return evtFired;
    }

    public boolean changed(ObjT obj, Object ... changes) {
        if (!this.d_adds.contains(obj) && !this.d_removes.contains(obj)) {
            if (changes.length == 0) {
                this.addChangeTo(obj, EVT_GENERAL);
            } else {
                for (Object change : changes) {
                    this.addChangeTo(obj, change);
                }
            }
            return true;
        }
        return false;
    }

    public boolean changed(Collection<? extends ObjT> objs, Object ... changes) {
        boolean evtFired = false;
        for (ObjT obj : objs) {
            evtFired |= this.changed(obj, changes);
        }
        return evtFired;
    }

    @Override
    public Set<ObjT> getAddedObjs() {
        return Collections.unmodifiableSet(this.d_adds);
    }

    @Override
    public Set<ObjT> getRemovedObjs() {
        return Collections.unmodifiableSet(this.d_removes);
    }

    @Override
    public Set<Object> getChanges() {
        return Collections.unmodifiableSet(this.d_changeMap.keySet());
    }

    @Override
    public Set<ObjT> getChangedObjs(Object ... changes) {
        if (this.d_changeMap.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        if (changes.length == 0) {
            if (this.d_changeMap.size() == 1) {
                return this.d_changeMap.values().iterator().next();
            }
            Set<ObjT> allObjs = this.newObjSet();
            for (Set<ObjT> objs : this.d_changeMap.values()) {
                allObjs.addAll(objs);
            }
            return allObjs;
        }
        if (changes.length == 1) {
            Set<ObjT> changedObjs = this.d_changeMap.get(changes[0]);
            if (changedObjs == null) {
                return Collections.EMPTY_SET;
            }
            return changedObjs;
        }
        Set<ObjT> objs = this.newObjSet();
        for (Object change : changes) {
            Set<ObjT> changedObjs = this.d_changeMap.get(change);
            if (changedObjs == null) continue;
            objs.addAll(changedObjs);
        }
        return objs;
    }

    @Override
    public boolean isChanged(Object obj) {
        for (Set<ObjT> changedObjs : this.d_changeMap.values()) {
            if (!changedObjs.contains(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsChange(Object change) {
        return this.d_changeMap.containsKey(change);
    }

    protected void eventDispatched() {
        this.d_adds.clear();
        this.d_removes.clear();
        this.d_changeMap.clear();
    }

    public String toString() {
        return "EventChannel of " + String.valueOf(this.d_type);
    }
}

