/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Diff {
    public static final int OP_NOP = 0;
    public static final int OP_ADD = 1;
    public static final int OP_DEL = 2;

    public static int getEditDistance(String s, String t) {
        int i;
        assert (s != null);
        assert (t != null);
        int m = s.length() + 1;
        int n = t.length() + 1;
        int[][] d = new int[m][n];
        for (i = 0; i < m; ++i) {
            d[i][0] = i;
        }
        for (int j = 0; j < n; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i < m; ++i) {
            for (int j = 1; j < n; ++j) {
                int cost = s.charAt(i - 1) == t.charAt(j - 1) ? 0 : 1;
                int insert = d[i - 1][j] + 1;
                int delete = d[i][j - 1] + 1;
                int subst = d[i - 1][j - 1] + cost;
                d[i][j] = Math.min(insert, Math.min(delete, subst));
            }
        }
        return d[m - 1][n - 1];
    }

    public static Op[] diff(String s1, String s2) {
        ArrayList<Op> open = new ArrayList<Op>();
        Diff.addAdjOps(open, s2, null, Diff.getEditDistance("", s2), "", s1, s2);
        Collections.sort(open);
        while (!open.isEmpty()) {
            Op node = (Op)open.remove(0);
            if (node._s.equals(s2)) {
                return Diff.path(node);
            }
            Diff.addAdjOps(open, s2, node, node._d, node._s, node._s1, node._s2);
            Collections.sort(open);
        }
        assert (false);
        return null;
    }

    private static Op[] path(Op o) {
        ArrayList<Op> opPath = new ArrayList<Op>();
        while (o != null) {
            opPath.add(0, o);
            o = o._parent;
        }
        return opPath.toArray(new Op[opPath.size()]);
    }

    public static List<Boolean> diffToBool(Op[] edits) {
        ArrayList<Boolean> bools = new ArrayList<Boolean>();
        block4: for (int i = 0; i < edits.length; ++i) {
            Op o = edits[i];
            switch (o._type) {
                case 0: {
                    bools.add(false);
                    continue block4;
                }
                case 1: {
                    bools.add(true);
                    continue block4;
                }
            }
        }
        return bools;
    }

    public static String diffToStr(Op[] edits) {
        StringBuffer sb = new StringBuffer();
        block4: for (Op o : edits) {
            switch (o._type) {
                case 0: {
                    sb.append(" ");
                    continue block4;
                }
                case 1: {
                    sb.append("^");
                    continue block4;
                }
            }
        }
        return sb.toString();
    }

    public static void addAdjOps(Collection<Op> c, String target, Op _parent, int _d, String _s, String _s1, String _s2) {
        String s2;
        String s1;
        Object s;
        if (_s1.length() > 0 && _s2.length() > 0) {
            s = _s + _s1.charAt(0);
            s1 = _s1.substring(1);
            s2 = _s2.substring(1);
            Op sub = new Op(_parent, target, 0, 0, (String)s, s1, s2);
            if (sub._d <= _d && target.startsWith((String)s)) {
                c.add(sub);
            }
        }
        if (_s2.length() > 0) {
            s = _s + _s2.charAt(0);
            s1 = _s1;
            s2 = _s2.substring(1);
            Op add = new Op(_parent, target, 1, 1, (String)s, s1, s2);
            if (add._d < _d && target.startsWith((String)s)) {
                c.add(add);
            }
        }
        if (_s1.length() > 0) {
            s = _s;
            s1 = _s1.substring(1);
            s2 = _s2;
            Op del = new Op(_parent, target, 2, 1, (String)s, s1, s2);
            if (del._d <= _d && target.startsWith((String)s)) {
                c.add(del);
            }
        }
    }

    public static class Op
    implements Comparable<Op> {
        public final Op _parent;
        public final String _s;
        public final String _s1;
        public final String _s2;
        public final int _d;
        public final int _type;
        public final int _cost;

        public Op(Op parent, String target, int type, int cost, String s, String s1, String s2) {
            this._parent = parent;
            this._type = type;
            this._s = s;
            this._cost = cost;
            this._s1 = s1;
            this._s2 = s2;
            this._d = Diff.getEditDistance(s + this._s1, target);
        }

        public String toString() {
            return String.format("Op[%s:%s]", this._s, this._s1);
        }

        @Override
        public int compareTo(Op o) {
            return this._cost + this._d - (o._cost + o._d);
        }
    }
}

