/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.units;

import java.io.Serializable;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class UnitPoint3D
implements Serializable,
ILegacy_2012_1 {
    static final long serialVersionUID = 1L;
    private final double x;
    private final double y;
    private final double z;
    private final Unit d_unit;

    public UnitPoint3D(List<UnitDouble> coords) {
        this(coords.get(0), coords.get(1), coords.get(2));
    }

    public UnitPoint3D(UnitDouble ... coords) {
        this(coords[0], coords[1], coords[2]);
    }

    public UnitPoint3D(UnitDouble x, UnitDouble y, UnitDouble z) {
        this(x.getValueNoUnit(), y.getValue(x.getUnit()), z.getValue(x.getUnit()), x.getUnit());
    }

    public UnitPoint3D(double x, double y, double z, Unit unit) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.d_unit = unit;
    }

    public UnitPoint3D(double[] data, Unit unit) {
        this(data[0], data[1], data[2], unit);
    }

    public UnitPoint3D(Point3d point, Unit u) {
        this(point.x, point.y, point.z, u);
    }

    public UnitPoint3D(Tuple3d vec, Unit unit) {
        this(vec.x, vec.y, vec.z, unit);
    }

    @Override
    public thunderheadeng.units.UnitPoint3D fromLegacy(LegacyDictionary_2012_1 dict) {
        return new thunderheadeng.units.UnitPoint3D(this.x, this.y, this.z, this.d_unit);
    }

    public void add(AABox box, Unit u) {
        box.addPoint(this.x(u), this.y(u), this.z(u));
    }

    public UnitPoint3D convert(Unit u) {
        Converter cvt = this.d_unit.getConverterTo(u);
        return new UnitPoint3D(cvt.convert(this.x), cvt.convert(this.y), cvt.convert(this.z), u);
    }

    public static UnitPoint3D convert(Point3d p, Unit from, Unit to) {
        Converter cvt = from.getConverterTo(to);
        return new UnitPoint3D(cvt.convert(p.x), cvt.convert(p.y), cvt.convert(p.z), to);
    }

    public Point3d getValue(Unit desiredUnit) {
        assert (this.d_unit != null);
        if (desiredUnit.equals(this.d_unit)) {
            return new Point3d(this.x, this.y, this.z);
        }
        return new Point3d(UnitDouble.convert(this.x, this.d_unit, desiredUnit), UnitDouble.convert(this.y, this.d_unit, desiredUnit), UnitDouble.convert(this.z, this.d_unit, desiredUnit));
    }

    public Point3d getPoint3dValue(Unit desiredUnit) {
        return this.getValue(desiredUnit);
    }

    public Vector3d getVector3dValue(Unit desiredUnit) {
        assert (this.d_unit != null);
        if (desiredUnit.equals(this.d_unit)) {
            return new Vector3d(this.x, this.y, this.z);
        }
        return new Vector3d(UnitDouble.convert(this.x, this.d_unit, desiredUnit), UnitDouble.convert(this.y, this.d_unit, desiredUnit), UnitDouble.convert(this.z, this.d_unit, desiredUnit));
    }

    public void getData(double[] data, Unit desiredUnit) {
        assert (data.length >= 3);
        data[0] = this.x(desiredUnit);
        data[1] = this.y(desiredUnit);
        data[2] = this.z(desiredUnit);
    }

    public UnitDouble xu() {
        return new UnitDouble(this.x, this.d_unit);
    }

    public UnitDouble yu() {
        return new UnitDouble(this.y, this.d_unit);
    }

    public UnitDouble zu() {
        return new UnitDouble(this.z, this.d_unit);
    }

    public double x(Unit desiredUnit) {
        return UnitDouble.convert(this.x, this.d_unit, desiredUnit);
    }

    public double y(Unit desiredUnit) {
        return UnitDouble.convert(this.y, this.d_unit, desiredUnit);
    }

    public double z(Unit desiredUnit) {
        return UnitDouble.convert(this.z, this.d_unit, desiredUnit);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public Unit getUnit() {
        return this.d_unit;
    }

    public UnitPoint3D add(UnitPoint3D p) {
        if (p.x == 0.0 && p.y == 0.0 && p.z == 0.0) {
            return this;
        }
        return new UnitPoint3D(this.x + p.x(this.d_unit), this.y + p.y(this.d_unit), this.z + p.z(this.d_unit), this.d_unit);
    }

    public UnitPoint3D sub(UnitPoint3D p) {
        if (p.x == 0.0 && p.y == 0.0 && p.z == 0.0) {
            return this;
        }
        return new UnitPoint3D(this.x - p.x(this.d_unit), this.y - p.y(this.d_unit), this.z - p.z(this.d_unit), this.d_unit);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UnitPoint3D)) {
            return false;
        }
        UnitPoint3D p = (UnitPoint3D)obj;
        if (this.d_unit.equals(p.d_unit)) {
            return this.x == p.x && this.y == p.y && this.z == p.z;
        }
        return UnitDouble.areCompatible(this.d_unit, p.d_unit) && this.x == p.x(this.d_unit) && this.y == p.y(this.d_unit) && this.z == p.z(this.d_unit);
    }

    public int hashCode() {
        return UnitDouble.hashCode(this.x + this.y + this.z, this.d_unit);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ") " + String.valueOf(this.d_unit);
    }
}

