/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.units;

import java.io.Serializable;
import java.text.NumberFormat;
import org.jscience.physics.units.ConversionException;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class UnitDouble
implements Serializable,
Comparable,
ILegacy_2012_1 {
    static final long serialVersionUID = 1L;
    private final double d_value;
    private final Unit d_unit;

    public UnitDouble(double value, Unit unit) throws ConversionException {
        this.d_value = value;
        this.d_unit = unit;
    }

    @Override
    public thunderheadeng.units.UnitDouble fromLegacy(LegacyDictionary_2012_1 dict) {
        return new thunderheadeng.units.UnitDouble(this.d_value, this.d_unit);
    }

    public UnitDouble reinterpret(Unit newUnit) {
        return this.isCompatible(newUnit) ? this : new UnitDouble(this.d_value, newUnit);
    }

    public UnitDouble convert(Unit unit) throws ConversionException {
        return UnitDouble.from(this.d_value, this.d_unit, unit);
    }

    public static UnitDouble from(double val, Unit from, Unit to) {
        return new UnitDouble(UnitDouble.convert(val, from, to), to);
    }

    public static UnitDouble maxValue(Unit unit) {
        return new UnitDouble(Double.MAX_VALUE, unit);
    }

    public static UnitDouble maxNegValue(Unit unit) {
        return new UnitDouble(-1.7976931348623157E308, unit);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.d_value);
    }

    public boolean isCompatible(Unit unit) {
        return UnitDouble.areCompatible(this.d_unit, unit);
    }

    public double getValue(Unit unit) throws ConversionException {
        double returnValue = 0.0;
        if (this.d_unit == unit) {
            returnValue = this.d_value;
        } else if (UnitDouble.areCompatible(this.d_unit, unit)) {
            returnValue = this.d_unit.getConverterTo(unit).convert(this.d_value);
        } else {
            throw UnitDouble.formatError(this.d_unit, unit);
        }
        return returnValue;
    }

    public double getValueNoUnit() {
        return this.d_value;
    }

    public Unit getUnit() {
        return this.d_unit;
    }

    public static double convert(double value, Unit from, Unit to) throws ConversionException {
        if (from.equals(to)) {
            return value;
        }
        if (UnitDouble.areCompatible(from, to)) {
            return from.getConverterTo(to).convert(value);
        }
        throw UnitDouble.formatError(from, to);
    }

    public UnitDouble diff(UnitDouble val) {
        if (this.d_unit == val.d_unit) {
            double diff = Math.abs(this.d_value - val.d_value);
            return new UnitDouble(diff, this.d_unit);
        }
        if (this.d_unit == null && val.d_unit != null) {
            double diff = Math.abs(this.d_value - val.d_value);
            return new UnitDouble(diff, val.d_unit);
        }
        if (this.d_unit != null && val.d_unit == null) {
            double diff = Math.abs(this.d_value - val.d_value);
            return new UnitDouble(diff, this.d_unit);
        }
        if (this.d_unit == null && val.d_unit == null) {
            double diff = Math.abs(this.d_value - val.d_value);
            return new UnitDouble(diff, null);
        }
        Unit otherUnit = val.getUnit();
        Converter cvt = otherUnit.getConverterTo(this.d_unit);
        double otherVal = cvt.convert(val.d_value);
        double diff = Math.abs(this.d_value - otherVal);
        return new UnitDouble(diff, this.d_unit);
    }

    public UnitDouble add(UnitDouble rhs) throws ConversionException {
        return this.add(rhs.d_value, rhs.d_unit);
    }

    protected UnitDouble add(double val, Unit unit) throws ConversionException {
        double newValue;
        if (this.d_unit == unit) {
            newValue = this.d_value + val;
        } else if (UnitDouble.areCompatible(this.d_unit, unit)) {
            newValue = this.d_value + unit.getConverterTo(this.d_unit).convert(val);
        } else {
            throw UnitDouble.formatError(this.d_unit, unit);
        }
        return new UnitDouble(newValue, this.d_unit);
    }

    public UnitDouble sub(UnitDouble rhs) throws ConversionException {
        return this.add(-rhs.d_value, rhs.d_unit);
    }

    public UnitDouble multiply(UnitDouble rhs) {
        return new UnitDouble(this.d_value * rhs.d_value, this.d_unit.multiply(rhs.d_unit));
    }

    public UnitDouble divide(UnitDouble rhs) {
        return new UnitDouble(this.d_value / rhs.d_value, this.d_unit.divide(rhs.d_unit));
    }

    public UnitDouble scale(double rhs) {
        return new UnitDouble(this.d_value * rhs, this.d_unit);
    }

    public UnitDouble abs() {
        return new UnitDouble(Math.abs(this.d_value), this.d_unit);
    }

    public UnitDouble negate() {
        return new UnitDouble(-this.d_value, this.d_unit);
    }

    public static UnitDouble min(UnitDouble ud1, UnitDouble ud2) throws ConversionException {
        UnitDouble ud;
        Unit unit2;
        Unit unit1 = ud1.getUnit();
        if (unit1 == (unit2 = ud2.getUnit())) {
            ud = ud1.getValue(unit1) < ud2.getValue(unit2) ? ud1 : ud2;
        } else if (UnitDouble.areCompatible(unit1, unit2)) {
            ud = ud1.getValue(unit1) < unit2.getConverterTo(unit1).convert(ud2.getValue(unit2)) ? ud1 : ud2;
        } else {
            throw UnitDouble.formatError(unit1, unit2);
        }
        return ud;
    }

    public static UnitDouble max(UnitDouble ud1, UnitDouble ud2) throws ConversionException {
        UnitDouble ud;
        Unit unit2;
        Unit unit1 = ud1.getUnit();
        if (unit1 == (unit2 = ud2.getUnit())) {
            ud = ud1.getValue(unit1) > ud2.getValue(unit2) ? ud1 : ud2;
        } else if (UnitDouble.areCompatible(unit1, unit2)) {
            ud = ud1.getValue(unit1) > unit2.getConverterTo(unit1).convert(ud2.getValue(unit2)) ? ud1 : ud2;
        } else {
            throw UnitDouble.formatError(unit1, unit2);
        }
        return ud;
    }

    public int compareTo(Object obj) throws ConversionException {
        int result;
        UnitDouble d = (UnitDouble)obj;
        Unit unit = d.getUnit();
        if (this.d_unit == unit) {
            result = Double.compare(this.d_value, d.d_value);
        } else if (UnitDouble.areCompatible(this.d_unit, unit)) {
            result = Double.compare(this.d_value, unit.getConverterTo(this.d_unit).convert(d.d_value));
        } else {
            throw UnitDouble.formatError(this.d_unit, unit);
        }
        return result;
    }

    private static ConversionException formatError(Unit invalidUnit, Unit expectedUnit) {
        String msg = String.format(Intl.intl("Cannot convert from %1$s to %2$s."), invalidUnit, expectedUnit);
        throw new ConversionException(msg);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnitDouble)) {
            return false;
        }
        UnitDouble val = (UnitDouble)obj;
        if (!UnitDouble.areCompatible(this.d_unit, val.d_unit)) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return UnitDouble.hashCode(this.d_value, this.d_unit);
    }

    public static int hashCode(double val, Unit u) {
        Unit systemUnit = u.getSystemUnit();
        double systemVal = u.getConverterTo(systemUnit).convert(val);
        return theUtil.hashCode(systemVal);
    }

    public boolean tolEquals(UnitDouble obj) {
        if (obj == null) {
            return false;
        }
        double a = this.d_value;
        double b = UnitDouble.convert(obj.getValue(obj.getUnit()), obj.getUnit(), this.getUnit());
        double diff = Math.abs(a - b);
        if (diff == 0.0) {
            return true;
        }
        double tol = Math.abs(Math.min(a, b) / 1000000.0);
        return diff <= tol;
    }

    public boolean epsilonEquals(UnitDouble obj, double tol) {
        if (obj == null) {
            return false;
        }
        double a = this.d_value;
        double b = UnitDouble.convert(obj.getValue(obj.getUnit()), obj.getUnit(), this.getUnit());
        return Math.abs(a - b) <= tol;
    }

    public String format(NumberFormat nf) {
        return nf.format(this.d_value) + " " + String.valueOf(this.d_unit);
    }

    public String toString() {
        return this.d_value + " " + String.valueOf(this.d_unit);
    }

    public static boolean areCompatible(Unit u1, Unit u2) {
        if (!u1.isCompatible(u2)) {
            return false;
        }
        try {
            u1.getConverterTo(u2);
        }
        catch (ConversionException e) {
            return false;
        }
        return true;
    }
}

