/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.units;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class GeomUtil {
    public static UnitPoint3D xform(Matrix4d xform, UnitPoint3D p) {
        Point3d p3d = p.getPoint3dValue(SI.METER);
        xform.transform(p3d);
        Converter converter = SI.METER.getConverterTo(p.getUnit());
        return new UnitPoint3D(converter.convert(p3d.x), converter.convert(p3d.y), converter.convert(p3d.z), p.getUnit());
    }

    public static UnitPoint3D[] rectify(UnitPoint3D p1, UnitPoint3D p2) {
        double maxz;
        double minz;
        double maxy;
        double miny;
        double maxx;
        double minx;
        Unit u = p1.getUnit();
        double x1 = p1.x();
        double y1 = p1.y();
        double z1 = p1.z();
        double x2 = p2.x(u);
        double y2 = p2.y(u);
        double z2 = p2.z(u);
        if (x1 <= x2) {
            minx = x1;
            maxx = x2;
        } else {
            minx = x2;
            maxx = x1;
        }
        if (y1 <= y2) {
            miny = y1;
            maxy = y2;
        } else {
            miny = y2;
            maxy = y1;
        }
        if (z1 <= z2) {
            minz = z1;
            maxz = z2;
        } else {
            minz = z2;
            maxz = z1;
        }
        return new UnitPoint3D[]{new UnitPoint3D(minx, miny, minz, u), new UnitPoint3D(maxx, maxy, maxz, u)};
    }
}

