/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class PlanarConstraint
implements ISnapConstraint {
    public final Plane3d plane;

    public PlanarConstraint(Plane3d plane) {
        this.plane = plane;
    }

    @Override
    public Pair<Point3d, Point3d> snapRay(Point3d rayBegin, Vector3d rayDir) {
        Point3d p = Inter3D.linePlaneIntersection(rayBegin, rayDir, this.plane, 1.0E-9);
        return p == null ? null : new Pair<Point3d, Point3d>(p, p);
    }

    @Override
    public Point3d snapPoint(Point3d p) {
        return this.plane.projectOntoPlane(p);
    }

    @Override
    public ISnapConstraint transform(Matrix4d xform) {
        return new PlanarConstraint(this.plane.transformBy(xform));
    }
}

