/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IBoxCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IPickable;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.LineConstraint;

public class OrthoSnap
implements IPickable {
    public final Point3d origin;
    public final Vector3d[] axes;

    public OrthoSnap(Point3d origin) {
        this(origin, GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS);
    }

    public OrthoSnap(Point3d origin, Vector3d ... axes) {
        this.origin = origin;
        this.axes = axes;
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        for (Vector3d dir : this.axes) {
            double[] t;
            LineConstraint constraint = new LineConstraint(this.origin, dir);
            if (!filter.acceptPickObject(constraint) || !filter.acceptGeomType(constraint, GeomType.EDGE) || (t = Inter3D.lineLineProximityT(rayBegin, rayDirN, this.origin, dir, 1.0E-9)) == null) continue;
            Point3d isect = Util3D.linePoint(this.origin, dir, t[1]);
            isects.addInfinite(constraint, isect, GeomType.EDGE, new LineSeg(this.origin, Util3D.add(this.origin, (Tuple3d)dir)));
        }
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull region) {
    }

    @Override
    public void getAll(IBoxCollector result, IIsectFilter filter) {
    }
}

