/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools;

import java.awt.AWTException;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiUtil;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Camera;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.AToolFunction;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.CursorTool;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.navtools.ISelector;

public class RoamFunc<T extends CursorTool>
extends AToolFunction<T> {
    public static final Cursor CURSOR = guiUtil.createTeciCursor("Freelook", "blank16.gif", 15, 16);
    public static final Icon ICON = guiUtil.loadTeciIcon("running_man.gif");
    private final ISelector<T> d_selectionTool;
    private Robot d_robot;
    private Point d_lastMouseLocation;
    private boolean d_roamMode = false;
    private AABox d_modelBounds;
    private double d_rotX = 0.0;
    private double d_rotZ = 0.0;

    public RoamFunc(ISelector<T> selectionTool) {
        this.d_selectionTool = selectionTool;
        try {
            this.d_robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    public void setModelBounds(AABox modelBounds) {
        this.d_modelBounds = modelBounds;
    }

    protected double getMovementSpeed(T tool) {
        AABox modelBounds = this.d_modelBounds;
        return modelBounds == null ? 0.05 : 0.001 * modelBounds.getMin().distance(modelBounds.getMax());
    }

    @Override
    public boolean isAltMenuAccessEnabled() {
        return false;
    }

    @Override
    public boolean isDrawable(T tool) {
        return false;
    }

    @Override
    public boolean enableZoomAboutPoint(T tool) {
        return false;
    }

    @Override
    public Cursor getCursor(T tool) {
        return Cursor.getPredefinedCursor(0);
    }

    @Override
    public void keyReleased(T tool, KeyEvent e) {
        switch (e.getKeyCode()) {
            case 27: {
                ((CursorTool)tool).restoreSystemCursor();
                this.d_roamMode = false;
                ((CursorTool)tool).repaintSurface();
            }
        }
    }

    @Override
    public void mousePressed(T tool, MouseEvent e) {
    }

    @Override
    public void mouseDragged(T tool, MouseEvent e) {
        this.respondToMouse(tool, e);
    }

    @Override
    public void mouseMoved(T tool, MouseEvent e) {
        if (!this.d_roamMode) {
            return;
        }
        ((CursorTool)tool).getAttachedComponent().setCursor(CURSOR);
        this.respondToMouse(tool, e);
    }

    @Override
    public void mouseReleased(T tool, MouseEvent e) {
        if (!((CursorTool)tool).dragAboveTolerance(0)) {
            if (e.getButton() == 2) {
                if (this.d_roamMode) {
                    ((CursorTool)tool).restoreSystemCursor();
                } else {
                    ((CursorTool)tool).getAttachedComponent().setCursor(CURSOR);
                }
                boolean bl = this.d_roamMode = !this.d_roamMode;
            }
            if (!this.d_roamMode) {
                this.d_selectionTool.select(tool, e);
            }
        }
        this.d_lastMouseLocation = null;
    }

    public void respondToMouse(T tool, MouseEvent e) {
        int translateModVertical2;
        int translateModVertical;
        int translateModRight2;
        int translateModRight;
        int translateModForward2;
        int translateModForward;
        if (this.d_robot == null) {
            this.d_roamMode = false;
        }
        this.calculateRotation(tool);
        if (this.d_lastMouseLocation == null) {
            this.d_lastMouseLocation = e.getPoint();
        }
        int dx = e.getX() - this.d_lastMouseLocation.x;
        int dy = e.getY() - this.d_lastMouseLocation.y;
        int orbitMod = 0;
        if (this.d_roamMode) {
            Point windowLocation = ((CursorTool)tool).getAttachedComponent().getLocationOnScreen();
            this.d_robot.mouseMove(windowLocation.x + this.d_lastMouseLocation.x, windowLocation.y + this.d_lastMouseLocation.y);
            translateModForward = 128;
            translateModForward2 = 1024;
            translateModRight = translateModForward;
            translateModRight2 = translateModForward2;
            translateModVertical = 512;
            translateModVertical2 = 4096;
        } else {
            translateModForward2 = translateModForward = 1152;
            translateModRight2 = translateModRight = translateModForward;
            translateModVertical2 = translateModVertical = 1536;
        }
        boolean shouldTranslateVert = (e.getModifiersEx() & translateModVertical) == translateModVertical || (e.getModifiersEx() & translateModVertical2) == translateModVertical2;
        boolean shouldTranslateForward = (e.getModifiersEx() & translateModForward) == translateModForward || (e.getModifiersEx() & translateModForward2) == translateModForward2;
        boolean shouldTranslateRight = (e.getModifiersEx() & translateModRight) == translateModRight || (e.getModifiersEx() & translateModRight2) == translateModRight2;
        boolean shouldTranslate = shouldTranslateVert || shouldTranslateForward || shouldTranslateRight;
        boolean shouldOrbit = !shouldTranslate && (e.getModifiersEx() & orbitMod) == orbitMod;
        Camera c = ((CursorTool)tool).getView().getCamera();
        if (shouldTranslate) {
            double speed = this.getMovementSpeed(tool);
            double paramX = (double)dx * speed;
            double paramY = (double)dy * -speed;
            if (shouldTranslateVert) {
                c.translateWorld(new Vector3d(0.0, 0.0, paramY), true);
            }
            if (shouldTranslateForward) {
                Vector3d right = c.getRightVector();
                Vector3d forward = new Vector3d();
                forward.cross(new Vector3d(0.0, 0.0, 1.0), right);
                forward.normalize();
                forward.scale(paramY);
                c.translateWorld(forward, true);
            }
            if (shouldTranslateRight) {
                c.translateEye(paramX, 0.0, 0.0, true);
            }
        }
        if (shouldOrbit) {
            this.d_rotX -= (double)dy * 0.175;
            this.d_rotZ -= (double)dx * 0.175;
            double overRotX = this.d_rotX / 360.0;
            if (overRotX > 1.0) {
                this.d_rotX = (overRotX - Math.floor(overRotX)) * 360.0;
            } else if (overRotX < -1.0) {
                this.d_rotX = (overRotX - Math.ceil(overRotX)) * 360.0;
            }
            double overRotY = this.d_rotZ / 360.0;
            if (overRotY > 1.0) {
                this.d_rotZ = (overRotY - Math.floor(overRotY)) * 360.0;
            } else if (overRotY < -1.0) {
                this.d_rotZ = (overRotY - Math.ceil(overRotY)) * 360.0;
            }
            if (this.d_rotX > 89.0) {
                this.d_rotX = 89.0;
            } else if (this.d_rotX < -89.0) {
                this.d_rotX = -89.0;
            }
            c.resetRotation();
            c.rotate(this.d_rotX, 1.0, 0.0, 0.0);
            c.rotate(this.d_rotZ, 0.0, 0.0, 1.0);
        }
        ((CursorTool)tool).repaintSurface();
        if (!this.d_roamMode) {
            this.d_lastMouseLocation = e.getPoint();
        }
    }

    private void calculateRotation(T tool) {
        Camera c = ((CursorTool)tool).getView().getCamera();
        Point3d pos = new Point3d(c.getPosition());
        Point3d ref = new Point3d(c.getReference());
        Vector3d view = new Vector3d();
        view.sub(ref, pos);
        Vector3d y = new Vector3d(0.0, 1.0, 0.0);
        Vector3d xy = new Vector3d(view.x, view.y, 0.0);
        double zAngleR = y.angle(xy);
        Vector3d zSign = new Vector3d();
        zSign.cross(y, xy);
        if (zSign.z < 0.0) {
            zAngleR = -zAngleR;
        }
        if (Double.valueOf(zAngleR).isNaN()) {
            zAngleR = 0.0;
        }
        AxisAngle4d axisAngle = new AxisAngle4d(0.0, 0.0, 1.0, -zAngleR);
        Matrix3d rot = new Matrix3d();
        rot.set(axisAngle);
        rot.transform(view);
        Vector3d yz = new Vector3d(0.0, view.y, view.z);
        double xAngleR = y.angle(yz);
        Vector3d xSign = new Vector3d();
        xSign.cross(y, yz);
        if (xSign.x < 0.0) {
            xAngleR = -xAngleR;
        }
        if (Double.valueOf(xAngleR).isNaN()) {
            xAngleR = 0.0;
        }
        this.d_rotZ = zAngleR * 180.0 / Math.PI;
        this.d_rotX = xAngleR * 180.0 / Math.PI;
    }
}

