/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.util.Arrays;
import java.util.HashSet;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.Native;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ConcreteRenderSurface;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderSurface;

public class RenderWindow
extends ConcreteRenderSurface {
    private static final long serialVersionUID = 3143271052495260201L;
    public static final int CAP_FAST_DEPTH_READS = 1;
    public static final int CAP_FAST_COLOR_READS = 2;
    public static final int CAP_FAST_VERTEX_BUFFERS = 4;
    public static final int CAP_FAST_SHADERS = 8;
    public static final int ALL_CAPS = 15;
    private static final int method_getPrimaryDisplayAdapterInfo = 0;
    private IRenderSurface d_sharingSurface = null;

    public RenderWindow() {
        this(null);
    }

    @Override
    public Class resolveNativeClass() {
        return RenderWindow.class;
    }

    public RenderWindow(IRenderSurface sharingSurface) {
        this.d_sharingSurface = sharingSurface;
    }

    public IRenderSurface getSharingSurface() {
        return this.d_sharingSurface;
    }

    public void setSharingSurface(IRenderSurface sharingSurf) {
        this.d_sharingSurface = sharingSurf;
    }

    public static DeviceInfo getPrimaryDisplayAdapterInfo() {
        Native.manager.lockWriteBuffer();
        Native.manager.execStaticMethod(RenderWindow.class, 0, new Object[0]);
        Native.manager.flush();
        DeviceInfo di = new DeviceInfo(Native.manager.readString(), Native.manager.readString(), Native.manager.readString(), Native.manager.readString());
        Native.manager.unlockWriteBuffer();
        return di;
    }

    public static int testCapabilities(int tests) {
        int result = 0;
        DeviceInfo di = RenderWindow.getPrimaryDisplayAdapterInfo();
        String desc = di.desc.toLowerCase();
        HashSet<String> tokens = new HashSet<String>(Arrays.asList(desc.split("\\W")));
        if (tokens.contains("nvidia")) {
            result = tests;
        } else if (tokens.contains("ati")) {
            result = tests & 0xFFFFFFFE;
        }
        return result;
    }

    public static class DeviceInfo {
        public final String name;
        public final String desc;
        public final String id;
        public final String key;

        public DeviceInfo(String name, String desc, String id, String key) {
            this.name = name;
            this.desc = desc;
            this.id = id;
            this.key = key;
        }
    }
}

