/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderSurface;

public class RSAnimator {
    private final IRenderSurface d_surface;
    private final long d_delayMS;
    private Thread d_animatingThread = null;

    public RSAnimator(IRenderSurface surface, long delayMS) {
        this.d_surface = surface;
        this.d_delayMS = delayMS;
    }

    public void start() {
        this.stop();
        this.d_animatingThread = new Thread(new Painter());
        this.d_animatingThread.start();
    }

    public void pause() {
        this.stop();
    }

    public void stop() {
        if (this.d_animatingThread != null) {
            this.d_animatingThread.interrupt();
            this.d_animatingThread = null;
        }
    }

    private class Painter
    implements Runnable {
        private Painter() {
        }

        @Override
        public void run() {
            while (true) {
                RSAnimator.this.d_surface.repaint();
                try {
                    Thread.sleep(RSAnimator.this.d_delayMS);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

