/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Camera;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.CameraRecord;

public class PerspectiveCamera
extends Camera {
    private static final long serialVersionUID = 7202473711234151243L;
    private static final double s_maxFOVRad = 2.9845130209103035;
    private static final double s_minFarClip = 10000.0;
    private static final double s_maxNearClip = 0.1;
    private double d_resetFovRad;
    private double d_fovRad;

    private PerspectiveCamera() {
    }

    public PerspectiveCamera(Point3d pos, Point3d ref, Vector3d up, double near, double far, double fovDeg) {
        super(pos, ref, up, near, far);
        this.d_fovRad = this.d_resetFovRad = fovDeg * Math.PI / 180.0;
        this.nativeConstructed(PerspectiveCamera.class);
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        super.writeNativeData(writer);
        writer.writeDouble(this.d_fovRad);
    }

    @Override
    public Class resolveNativeClass() {
        return PerspectiveCamera.class;
    }

    @Override
    public Camera createCopyCam() {
        PerspectiveCamera cam = new PerspectiveCamera();
        cam.setCopyCam(this);
        return cam;
    }

    public void setFOV(double fov) {
        this.d_resetFovRad = fov;
        this.d_fovRad = fov;
        this.markDirty();
    }

    public double getFOV() {
        return this.d_fovRad;
    }

    protected double getMinZoom() {
        return 0.25;
    }

    @Override
    protected Point3d constrainPointToView(Point3d refPoint, Point3d desiredLocation) {
        Point3d refLocV = this.worldToView(refPoint);
        Point3d desiredLocV = this.worldToView(desiredLocation);
        desiredLocV.z = refLocV.z;
        return this.viewToWorld(desiredLocV);
    }

    @Override
    protected double calcScreenZValue(double distFromCamera) {
        double distFromNear = distFromCamera - this.getNearClip();
        double invfmn = 1.0 / (this.getFarClip() - this.getNearClip());
        double a = -(this.getFarClip() + this.getNearClip()) * invfmn;
        double b = -2.0 * this.getNearClip() * this.getFarClip() * invfmn;
        double view = -a - b / -distFromNear;
        return view * 0.5 + 0.5;
    }

    @Override
    public AABox ensureValidForReset(AABox bb, double maxVal) {
        return bb.ensureValidSize(maxVal, 1.0E-6);
    }

    @Override
    public double getSubjectSize() {
        return this.d_fovRad * this.getDistance();
    }

    @Override
    public void reset(Vector3d viewDir, Vector3d upDir, AABox bb, int screenWidth, int screenHeight) {
        super.reset(viewDir, upDir, bb, screenWidth, screenHeight);
        assert (Math.abs(viewDir.angle(upDir) - 1.5707963267948966) <= 1.0E-4);
        this.d_fovRad = this.d_resetFovRad;
        double size = bb.getMin().distance(bb.getMax());
        double halfSize = size * 0.5;
        Point3d center = new Point3d();
        center.add(bb.getMin(), bb.getMax());
        center.scale(0.5);
        double dist = halfSize / Math.sin(this.getFOV() * 0.5);
        Vector3d eyeOffset = new Vector3d(viewDir);
        eyeOffset.normalize();
        eyeOffset.scale(dist);
        Point3d eye = new Point3d();
        eye.sub(center, eyeOffset);
        this.setPosition(eye);
        this.setReference(center);
        this.setUpVector(upDir);
        this.fitClipping(bb);
        this.markDirty();
    }

    @Override
    public Vector3d getViewVector(Point3d reference) {
        Vector3d view = new Vector3d();
        view.sub(reference, this.getPosition());
        return view;
    }

    @Override
    public CameraRecord capture() {
        return new CameraRecord(this.getPosition(), this.getReference(), this.getUpVector(), this.getZoom(), this.getZoomLoc(), this.getNearClip(), this.getFarClip(), this.getFOV());
    }

    @Override
    public void apply(CameraRecord cc) {
        this.pauseUpdates();
        super.apply(cc);
        this.setFOV(cc.extra);
        this.resumeUpdates();
    }
}

