/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Camera;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.CameraRecord;

public class OrthoCamera
extends Camera {
    private static final long serialVersionUID = -7514484926758313826L;
    private double d_height;

    private OrthoCamera() {
    }

    public OrthoCamera(Point3d pos, Point3d ref, Vector3d up, double near, double far, double worldHeight) {
        super(pos, ref, up, near, far);
        this.d_height = worldHeight;
        this.nativeConstructed(OrthoCamera.class);
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        super.writeNativeData(writer);
        writer.writeDouble(this.d_height);
    }

    @Override
    public Class resolveNativeClass() {
        return OrthoCamera.class;
    }

    @Override
    public Camera createCopyCam() {
        OrthoCamera cam = new OrthoCamera();
        cam.setCopyCam(this);
        return cam;
    }

    public void setWorldHeight(double worldHeight) {
        this.d_height = worldHeight;
        this.markDirty();
    }

    public double getWorldHeight() {
        return this.d_height;
    }

    @Override
    protected Point3d constrainPointToView(Point3d refPoint, Point3d desiredLocation) {
        Point3d camLoc = this.getPosition();
        Vector3d viewDir = this.getViewVector();
        viewDir.normalize();
        Vector3d camToRef = new Vector3d();
        camToRef.sub(refPoint, camLoc);
        double refDistFromCamPlane = viewDir.dot(camToRef);
        Vector3d camToDesired = new Vector3d();
        camToDesired.sub(desiredLocation, camLoc);
        double desiredDistFromCamPlane = viewDir.dot(camToDesired);
        double moveDist = refDistFromCamPlane - desiredDistFromCamPlane;
        Point3d constrainedLoc = new Point3d(viewDir);
        constrainedLoc.scale(moveDist);
        constrainedLoc.add(desiredLocation);
        return constrainedLoc;
    }

    @Override
    protected double calcScreenZValue(double distFromCamera) {
        double invfmn = 1.0 / (this.getFarClip() - this.getNearClip());
        double a = -2.0 * invfmn;
        double b = -(this.getFarClip() - this.getNearClip()) * invfmn;
        double view = a * distFromCamera + b;
        return view * 0.5 + 0.5;
    }

    @Override
    public double getSubjectSize() {
        return this.d_height;
    }

    @Override
    public void reset(Vector3d viewDir, Vector3d upDir, AABox bb, int screenWidth, int screenHeight) {
        super.reset(viewDir, upDir, bb, screenWidth, screenHeight);
        Point3d min = bb.getMin();
        Point3d max = bb.getMax();
        Point3d[] points = new Point3d[]{new Point3d(min.x, min.y, min.z), new Point3d(min.x, min.y, max.z), new Point3d(min.x, max.y, min.z), new Point3d(min.x, max.y, max.z), new Point3d(max.x, min.y, min.z), new Point3d(max.x, min.y, max.z), new Point3d(max.x, max.y, min.z), new Point3d(max.x, max.y, max.z)};
        Matrix3d xform = this.getLocalTransformLHR();
        Point3d localMin = new Point3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Point3d localMax = new Point3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (int m = 0; m < 8; ++m) {
            xform.transform(points[m]);
            if (points[m].x < localMin.x) {
                localMin.x = points[m].x;
            }
            if (points[m].x > localMax.x) {
                localMax.x = points[m].x;
            }
            if (points[m].y < localMin.y) {
                localMin.y = points[m].y;
            }
            if (points[m].y > localMax.y) {
                localMax.y = points[m].y;
            }
            if (-points[m].z < localMin.z) {
                localMin.z = -points[m].z;
            }
            if (!(-points[m].z > localMax.z)) continue;
            localMax.z = -points[m].z;
        }
        Vector3d diag = new Vector3d();
        diag.sub(localMax, localMin);
        double boundsAspect = diag.y / diag.x;
        double screenAspect = (double)screenHeight / (double)screenWidth;
        double orthoScale = boundsAspect >= screenAspect ? diag.y : diag.x * screenAspect;
        orthoScale *= 1.1;
        Point3d boundsCenter = new Point3d();
        boundsCenter.add(min, max);
        boundsCenter.scale(0.5);
        Vector3d viewVec = this.getViewVector();
        viewVec.normalize();
        double scale = Math.max(diag.z * 0.5 + 10.0, Math.sqrt(diag.x * diag.x + diag.y * diag.y));
        Point3d camLoc = new Point3d();
        camLoc.scale(scale, viewVec);
        camLoc.sub(boundsCenter, camLoc);
        this.setWorldHeight(orthoScale);
        this.setPosition(camLoc);
        this.setReference(boundsCenter);
        this.fitClipping(bb);
    }

    @Override
    public Vector3d getViewVector(Point3d reference) {
        return this.getViewVector();
    }

    @Override
    public CameraRecord capture() {
        return new CameraRecord(this.getPosition(), this.getReference(), this.getUpVector(), this.getZoom(), this.getZoomLoc(), this.getNearClip(), this.getFarClip(), this.getWorldHeight());
    }

    @Override
    public void apply(CameraRecord cc) {
        this.pauseUpdates();
        super.apply(cc);
        this.setWorldHeight(cc.extra);
        this.resumeUpdates();
    }
}

