/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyLine;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.Native;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IGeomSource;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IMaterial;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IDisplayable;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ISceneObject;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Material;
import pyrosim.legacy_2012_1.thunderheadeng.util.Keyable;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class GeomDisplay
extends ISceneObject {
    private static final long serialVersionUID = 6764469365996011489L;
    private static final int method_setSelected = 0;
    private boolean d_selected = false;
    private INativeDisplayProps d_dispProps;
    private IGeomSource d_source;

    public GeomDisplay(INativeDisplayProps dispProps, IGeomSource source) {
        this.d_dispProps = dispProps;
        this.d_source = source;
        this.nativeConstructed(GeomDisplay.class);
    }

    @Override
    public Class resolveNativeClass() {
        return GeomDisplay.class;
    }

    public IDisplayable[] getDisplayObjs() {
        return new IDisplayable[]{this};
    }

    public INativeDisplayProps getDisplayProps() {
        return this.d_dispProps;
    }

    public void setSelected(boolean selected) {
        if (this.d_selected == selected) {
            return;
        }
        this.d_selected = selected;
        Native.manager.execMethod(GeomDisplay.class, this, 0, selected);
    }

    public boolean isSelected() {
        return this.d_selected;
    }

    public IGeomSource getSource() {
        return this.d_source;
    }

    public void setSource(IGeomSource source) {
        this.d_source = source;
        this.update();
    }

    public void update() {
        this.markNativeDirty();
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        super.writeNativeData(writer);
        writer.writeInts(0, 0, 0, 0);
        DisplayGeom dg = this.d_source.getDisplayGeom(this.d_dispProps);
        IGeom geom = dg.geom;
        IPropsSrc props = dg.props;
        this.writeGeom(writer, geom, props, 0, dg.texuv);
        writer.writeInt(GeomType.GT_END.ordinal());
    }

    private int writeGeom(INativeStream writer, IGeom geom, IPropsSrc props, int primOffset, ITexCoordGenerator texuv) {
        if (geom instanceof Point) {
            this.writePoint(writer, (Point)geom, props.get(primOffset++));
        } else if (geom instanceof LineSeg) {
            this.writeLineSeg(writer, (LineSeg)geom, props.get(primOffset++));
        } else if (geom instanceof PolyLine) {
            this.writeLineStrip(writer, (PolyLine)geom, props.get(primOffset++));
        } else if (geom instanceof Triangle) {
            this.writeTriangle(writer, (Triangle)geom, props.get(primOffset), primOffset, texuv);
            ++primOffset;
        } else if (geom instanceof Quad) {
            this.writeQuad(writer, (Quad)geom, props.get(primOffset), primOffset, texuv);
            ++primOffset;
        } else if (geom instanceof IPolygon) {
            this.writePoly(writer, (IPolygon)geom, props.get(primOffset), primOffset, texuv);
            ++primOffset;
        } else if (geom instanceof Mesh) {
            primOffset = this.writeMesh(writer, (Mesh)geom, props, primOffset, texuv, null);
        } else if (geom instanceof ICurve) {
            Mesh mesh = ((ICurve)geom).getSegments(this.d_dispProps.getCurveError());
            primOffset = this.writeMesh(writer, mesh, props, primOffset, texuv, (ICurve)geom);
        } else if (geom instanceof IFace) {
            Mesh mesh = ((IFace)geom).triangulate(this.d_dispProps.getFaceError());
            primOffset = this.writeMesh(writer, mesh, props, primOffset, texuv, (IFace)geom);
        } else if (geom.canExplode()) {
            Collection<IGeom> pieces = geom.explode(new ArrayList<IGeom>());
            for (IGeom subGeom : pieces) {
                primOffset = this.writeGeom(writer, subGeom, props, primOffset, texuv);
            }
        } else {
            assert (geom.getNumPrims(7) == 0);
            primOffset += geom.getNumPrims(7);
        }
        return primOffset;
    }

    private static List<Point2d> generateTexUV(IPolygon face, IPrimProps props, int pOffset, ITexCoordGenerator texuv) {
        if (GeomDisplay.needsTexUV(props)) {
            ArrayList<Point2d> coords = new ArrayList<Point2d>();
            texuv.generate(pOffset, face, props, coords);
            return coords;
        }
        return Collections.EMPTY_LIST;
    }

    private static void write(INativeStream writer, List<Point2d> tcoords) {
        writer.writeInt(tcoords.size());
        for (Point2d p : tcoords) {
            writer.writeFloat((float)p.x);
            writer.writeFloat((float)p.y);
        }
    }

    private void writePoint(INativeStream writer, Point point, IPrimProps props) {
        this.beginGeom(writer, point, GeomType.GT_POINT.ordinal(), props);
        this.write(writer, point.loc);
    }

    private void writeLineSeg(INativeStream writer, LineSeg line, IPrimProps props) {
        this.beginGeom(writer, line, GeomType.GT_LINESEG.ordinal(), props);
        this.write(writer, line.p1, line.p2);
    }

    private void writeLineStrip(INativeStream writer, PolyLine line, IPrimProps props) {
        this.beginGeom(writer, line, GeomType.GT_LINE_STRIP.ordinal(), props);
        this.writeArray(writer, line.verts);
    }

    private void writeTriangle(INativeStream writer, Triangle tri, IPrimProps props, int pOffset, ITexCoordGenerator texuv) {
        this.beginGeom(writer, tri, GeomType.GT_TRIANGLE.ordinal(), props);
        GeomDisplay.write(writer, GeomDisplay.generateTexUV(tri, props, pOffset, texuv));
        this.write(writer, tri.p1, tri.p2, tri.p3);
    }

    private void writeQuad(INativeStream writer, Quad quad, IPrimProps props, int pOffset, ITexCoordGenerator texuv) {
        this.beginGeom(writer, quad, GeomType.GT_QUAD.ordinal(), props);
        GeomDisplay.write(writer, GeomDisplay.generateTexUV(quad, props, pOffset, texuv));
        this.write(writer, quad.p1, quad.p2, quad.p3, quad.p4);
    }

    private void writePoly(INativeStream writer, IPolygon poly, IPrimProps props, int pOffset, ITexCoordGenerator texuv) {
        this.beginGeom(writer, poly, GeomType.GT_POLYGON.ordinal(), props);
        GeomDisplay.write(writer, GeomDisplay.generateTexUV(poly, props, pOffset, texuv));
        writer.writeInt(poly.getNumLoops());
        for (int m = 0; m < poly.getNumLoops(); ++m) {
            writer.writeInt(poly.getNumPoints(m));
            for (int n = 0; n < poly.getNumPoints(m); ++n) {
                Point3d p = poly.getPoint(m, n);
                this.write(writer, p);
            }
        }
    }

    private int writeMesh(INativeStream writer, Mesh mesh, IPropsSrc props, int pOffset, ITexCoordGenerator texuv, IPrimitive source) {
        int numProps;
        writer.writeInt(GeomType.GT_MESH.ordinal());
        boolean smoothNormals = mesh.testFlag(2);
        writer.writeBoolean(smoothNormals);
        switch (mesh.primtype) {
            case 0: {
                writer.writeInt(GeomType.GT_POINT.ordinal());
                break;
            }
            case 1: {
                writer.writeInt(GeomType.GT_LINESEG.ordinal());
                break;
            }
            case 2: {
                writer.writeInt(GeomType.GT_TRIANGLE.ordinal());
                break;
            }
            case 3: {
                writer.writeInt(GeomType.GT_QUAD.ordinal());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        boolean isFaceType = mesh.primtype == 3 || mesh.primtype == 2;
        boolean needsTexUV = false;
        int numPrims = mesh.getNumPrims(7);
        int n = numProps = source != null ? 1 : numPrims;
        if (props.isUniform(pOffset, numProps)) {
            writer.writeInt(1);
            IPrimProps meshProps = props.get(pOffset);
            this.writeMeta(writer, mesh, meshProps);
            needsTexUV = isFaceType && GeomDisplay.needsTexUV(meshProps);
        } else {
            LinkedIdentityHashMap<IPrimProps, Integer> metas = new LinkedIdentityHashMap<IPrimProps, Integer>();
            int[] ixes = new int[numProps];
            for (int m = 0; m < numProps; ++m) {
                IPrimProps pprops = props.get(pOffset + m);
                needsTexUV = needsTexUV || isFaceType && GeomDisplay.needsTexUV(pprops);
                Integer ix = (Integer)metas.get(pprops);
                if (ix == null) {
                    ix = metas.size();
                    metas.put(pprops, ix);
                }
                ixes[m] = ix;
            }
            writer.writeInt(metas.size());
            if (metas.size() == 1) {
                this.writeMeta(writer, mesh, (IPrimProps)metas.keySet().iterator().next());
            } else if (!metas.isEmpty()) {
                for (IPrimProps pprops : metas.keySet()) {
                    this.writeMeta(writer, mesh, pprops);
                }
                this.writeArray(writer, ixes);
            }
        }
        List<Point2d> texCoords = Collections.EMPTY_LIST;
        if (needsTexUV) {
            if (source != null) {
                texCoords = new ArrayList<Point2d>();
                texuv.generate(pOffset, (IFace)source, props.get(pOffset), mesh, texCoords);
            } else {
                Pair<Mesh, List<Point2d>> result = GeomDisplay.generateTexUV(texuv, mesh, props, pOffset, numPrims);
                mesh = (Mesh)result.v1;
                texCoords = (List)result.v2;
            }
        }
        this.writeArray(writer, mesh.vertices);
        GeomDisplay.write(writer, texCoords);
        this.writeArray(writer, mesh.indices);
        return pOffset + numProps;
    }

    private static boolean needsTexUV(IPrimProps props) {
        IMaterial mat = props.getMaterial();
        return mat != null && (mat.getDiffuse().v2 != null || mat.getNormal() != null || mat.getSpecular().v2 != null);
    }

    private static Pair<Mesh, List<Point2d>> generateTexUV(ITexCoordGenerator texGen, Mesh mesh, IPropsSrc props, int propix, int numPrims) {
        Point2d defuv = new Point2d(0.0, 0.0);
        ArrayList<Point2d> uvs = new ArrayList<Point2d>(mesh.vertices.length);
        for (int m = 0; m < mesh.vertices.length; ++m) {
            uvs.add(null);
        }
        ArrayList<Point3d> locs = new ArrayList<Point3d>(Arrays.asList(mesh.vertices));
        int[] ixes = new int[mesh.indices.length];
        int numVertsPerPrim = mesh.primtype == 3 ? 4 : 3;
        ArrayList<Point2d> tempUV = new ArrayList<Point2d>(numVertsPerPrim);
        int m = 0;
        int primix = 0;
        while (m < mesh.indices.length) {
            IPrimProps primProps = props.get(propix + primix);
            if (!GeomDisplay.needsTexUV(primProps)) {
                for (int n = 0; n < numVertsPerPrim; ++n) {
                    ixes[m + n] = mesh.indices[m + n];
                }
            } else {
                AFace poly = mesh.primtype == 2 ? new Triangle(mesh.vertices[mesh.indices[m + 0]], mesh.vertices[mesh.indices[m + 1]], mesh.vertices[mesh.indices[m + 2]]) : new Quad(mesh.vertices[mesh.indices[m + 0]], mesh.vertices[mesh.indices[m + 1]], mesh.vertices[mesh.indices[m + 2]], mesh.vertices[mesh.indices[m + 3]]);
                tempUV.clear();
                texGen.generate(propix + primix, (IPolygon)((Object)poly), primProps, (List<Point2d>)tempUV);
                assert (tempUV.size() == numVertsPerPrim);
                for (int n = 0; n < numVertsPerPrim; ++n) {
                    int oldix;
                    int newix = oldix = mesh.indices[m + n];
                    Point2d existingUV = (Point2d)uvs.get(oldix);
                    Point2d newUV = (Point2d)tempUV.get(n);
                    if (existingUV == null) {
                        uvs.set(oldix, newUV);
                    } else if (!existingUV.equals(newUV)) {
                        newix = locs.size();
                        locs.add(mesh.vertices[oldix]);
                        uvs.add(newUV);
                    }
                    ixes[m + n] = newix;
                }
            }
            m += numVertsPerPrim;
            ++primix;
        }
        for (m = 0; m < uvs.size(); ++m) {
            if (uvs.get(m) != null) continue;
            uvs.set(m, defuv);
        }
        Point3d[] newverts = locs.size() == mesh.vertices.length ? mesh.vertices : locs.toArray(new Point3d[locs.size()]);
        mesh = new Mesh(newverts, ixes, mesh.primtype, mesh.flags);
        return new Pair<Mesh, List<Point2d>>(mesh, uvs);
    }

    private void beginGeom(INativeStream writer, IGeom geom, int type, IPrimProps props) {
        writer.writeInt(type);
        this.writeMeta(writer, geom, props);
    }

    private void writeMeta(INativeStream writer, IGeom geom, IPrimProps props) {
        IMaterial mat = props.getMaterial();
        Material nmat = null;
        if (mat != null) {
            nmat = this.d_dispProps.getNativeMat(mat);
        }
        writer.write((Keyable)nmat);
        Color color = props.getColor();
        assert (color != null || mat != null) : "Either a material or a color must be specified.";
        writer.writeBoolean(color != null);
        if (color != null) {
            this.write(writer, color);
        }
        writer.writeFloat((float)props.getEdgeWidth());
        writer.writeFloat((float)props.getPointSize());
        writer.writeBoolean(props.getCullFace());
    }

    private void write(INativeStream writer, Color color) {
        float[] comps = new float[4];
        color.getComponents(comps);
        writer.writeFloats(comps[0], comps[1], comps[2], comps[3]);
    }

    private void writeArray(INativeStream writer, Point3d ... points) {
        writer.writeInt(points.length);
        this.write(writer, points);
    }

    private void write(INativeStream writer, Point3d ... points) {
        for (Point3d t : points) {
            this.write(writer, t);
        }
    }

    private void writeArray(INativeStream writer, int ... vals) {
        writer.writeInt(vals.length);
        for (int v : vals) {
            writer.writeInt(v);
        }
    }

    private void write(INativeStream writer, Point3d t) {
        writer.writeFloats((float)t.x, (float)t.y, (float)t.z);
    }

    private static enum GeomType {
        GT_END,
        GT_POINT,
        GT_LINE_STRIP,
        GT_LINESEG,
        GT_TRIANGLE,
        GT_QUAD,
        GT_POLYGON,
        GT_MESH;

    }
}

