/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.ANativelyMirrored;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ILayer;

public class ClearableBackground
extends ANativelyMirrored
implements ILayer {
    private static final long serialVersionUID = -3149735012750956397L;
    private Color d_clearColor = Color.BLACK;
    private double d_clearDepth;
    private int d_clearStencil;
    private boolean d_clearColorEnabled = false;
    private boolean d_clearDepthEnabled = false;
    private boolean d_clearStencilEnabled = false;

    public ClearableBackground(boolean clearColor, boolean clearDepth) {
        this.setColorClearEnabled(clearColor);
        this.setClearColor(Color.WHITE);
        this.setDepthClearEnabled(clearDepth);
        this.setClearDepth(1.0);
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        writer.writeBooleans(this.d_clearColorEnabled, this.d_clearDepthEnabled, this.d_clearStencilEnabled);
        float[] color = new float[4];
        this.d_clearColor.getComponents(color);
        writer.writeFloats(color);
        writer.writeDouble(this.d_clearDepth);
        writer.writeInt(this.d_clearStencil);
    }

    @Override
    public Class resolveNativeClass() {
        return ClearableBackground.class;
    }

    public void setColorClearEnabled(boolean enabled) {
        this.d_clearColorEnabled = enabled;
        this.markNativeDirty();
    }

    public void setDepthClearEnabled(boolean enabled) {
        this.d_clearDepthEnabled = enabled;
        this.markNativeDirty();
    }

    public void setStencilClearEnabled(boolean enabled) {
        this.d_clearStencilEnabled = enabled;
        this.markNativeDirty();
    }

    public void setClearColor(Color color) {
        this.d_clearColor = color;
        this.markNativeDirty();
    }

    public void setClearDepth(double depth) {
        this.d_clearDepth = depth;
        this.markNativeDirty();
    }

    public void setClearStencil(int stencil) {
        this.d_clearStencil = stencil;
        this.markNativeDirty();
    }

    public void setColor(Color c) {
        this.setClearColor(c);
    }
}

