/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.FlattenedProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.UniformProps;

public class PropsBuilder
implements IPropsSrc {
    static final long serialVersionUID = 1L;
    private final ArrayList<Object> d_props = new ArrayList();
    private final ArrayList<RangeEntry> d_ranges = new ArrayList();

    @Override
    public thunderheadeng.scene3d.geom.IPropsSrc fromLegacy(LegacyDictionary_2012_1 dict) {
        int count;
        thunderheadeng.scene3d.geom.PropsBuilder builder = new thunderheadeng.scene3d.geom.PropsBuilder();
        int size = this.size();
        for (int m = 0; m < size; m += count) {
            IPrimProps props = this.get(m);
            count = this.getUniformCount(m);
            builder.add((thunderheadeng.scene3d.geom.IPrimProps)dict.get(props), count);
        }
        return builder.finalizeProps();
    }

    @Override
    public IPropsSrc subset(int startix, int count) {
        PropsBuilder builder = new PropsBuilder();
        while (count > 0) {
            int numUniform = Math.min(this.getUniformCount(startix), count);
            builder.add(this.get(startix), numUniform, false);
            startix += numUniform;
            count -= numUniform;
        }
        return builder.finalizeProps();
    }

    public void add(IPropsSrc src, int count) {
        this.add(src, count, true);
    }

    public void add(IPropsSrc src, int count, boolean collapseWithPrevious) {
        if (src instanceof UniformProps) {
            this.add(src.get(0), count);
        } else if (src instanceof PropsBuilder) {
            PropsBuilder builder = (PropsBuilder)src;
            for (Object p : builder.d_props) {
                if (p instanceof IPrimProps) {
                    this.add((IPrimProps)p, collapseWithPrevious);
                    continue;
                }
                RangeEntry re = (RangeEntry)p;
                this.add(re.props, re.gmax - re.gmin + 1);
            }
        } else {
            for (int m = 0; m < count; ++m) {
                this.add(src.get(m), collapseWithPrevious);
            }
        }
    }

    public void add(IPrimProps props) {
        this.add(props, true);
    }

    public void add(IPrimProps props, boolean collapseWithPrevious) {
        if (collapseWithPrevious && !this.d_props.isEmpty()) {
            Object prev = this.d_props.get(this.d_props.size() - 1);
            if (prev instanceof RangeEntry && ((RangeEntry)prev).props.equals(props)) {
                RangeEntry re = (RangeEntry)prev;
                ++re.gmax;
                return;
            }
            if (props.equals(prev)) {
                int currSize = this.size();
                RangeEntry re = new RangeEntry(props, currSize - 1, currSize, this.d_props.size() - 1);
                this.d_props.set(re.lix, re);
                this.d_ranges.add(re);
                return;
            }
        }
        this.d_props.add(props);
    }

    public void add(IPrimProps props, int numPrims) {
        this.add(props, numPrims, true);
    }

    public void add(IPrimProps props, int numPrims, boolean collapseWithPrevious) {
        if (numPrims == 1) {
            this.add(props, collapseWithPrevious);
            return;
        }
        int lix = this.d_props.size();
        int gmin = this.size();
        int gmax = gmin + numPrims - 1;
        RangeEntry re = new RangeEntry(props, gmin, gmax, lix);
        this.d_ranges.add(re);
        this.d_props.add(re);
    }

    public int size() {
        if (this.d_ranges.isEmpty()) {
            return this.d_props.size();
        }
        RangeEntry lastRange = this.d_ranges.get(this.d_ranges.size() - 1);
        int diff = this.d_props.size() - lastRange.lix;
        return lastRange.gmax + diff;
    }

    @Override
    public IPrimProps get(int ix) {
        RangeEntry re = this.getPreviousRangeEntry(ix);
        if (re == null) {
            return (IPrimProps)this.d_props.get(ix);
        }
        if (ix <= re.gmax) {
            return re.props;
        }
        int propix = ix - re.gmax + re.lix;
        return (IPrimProps)this.d_props.get(propix);
    }

    @Override
    public boolean isUniform(int startix, int count) {
        return count == 1 || count > 0 && this.getUniformCount(startix) >= count;
    }

    public int getUniformCount(int startix) {
        RangeEntry re = this.getPreviousRangeEntry(startix);
        if (re != null && startix < re.gmax) {
            return re.gmax - startix + 1;
        }
        return 1;
    }

    private RangeEntry getPreviousRangeEntry(int ix) {
        if (this.d_ranges.isEmpty()) {
            return null;
        }
        int rangeix = Collections.binarySearch(this.d_ranges, ix);
        if (rangeix < 0) {
            if ((rangeix = -rangeix - 1) == 0) {
                return null;
            }
            --rangeix;
        }
        return this.d_ranges.get(rangeix);
    }

    public IPropsSrc finalizeProps() {
        if (this.d_props.size() == 1) {
            Object props = this.d_props.get(0);
            IPrimProps p = props instanceof RangeEntry ? ((RangeEntry)props).props : (IPrimProps)props;
            return new UniformProps(p);
        }
        if (this.d_ranges.isEmpty()) {
            IPrimProps[] props = new IPrimProps[this.d_props.size()];
            for (int m = 0; m < props.length; ++m) {
                props[m] = (IPrimProps)this.d_props.get(m);
            }
            return new FlattenedProps(props);
        }
        this.d_props.trimToSize();
        this.d_ranges.trimToSize();
        return this;
    }

    private static class RangeEntry
    implements Comparable<Integer>,
    Serializable {
        static final long serialVersionUID = 1L;
        public final IPrimProps props;
        public final int gmin;
        public int gmax;
        public final int lix;

        public RangeEntry(IPrimProps props, int gmin, int gmax, int lix) {
            this.props = props;
            this.gmin = gmin;
            this.gmax = gmax;
            this.lix = lix;
        }

        @Override
        public int compareTo(Integer o) {
            return this.gmin - o;
        }
    }
}

