/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.theHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.IHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.PtrHasher;

public class theLinkedHashMap<K, V>
extends theHashMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    private transient Entry<K, V> header;
    private final boolean accessOrder;

    public theLinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.accessOrder = false;
    }

    public theLinkedHashMap(int initialCapacity, float loadFactor, IHasher<K> hasher) {
        super(initialCapacity, loadFactor, hasher);
        this.accessOrder = false;
    }

    public theLinkedHashMap(int initialCapacity) {
        super(initialCapacity);
        this.accessOrder = false;
    }

    public theLinkedHashMap(int initialCapacity, IHasher<K> hasher) {
        super(initialCapacity, hasher);
        this.accessOrder = false;
    }

    public theLinkedHashMap() {
        this.accessOrder = false;
    }

    public theLinkedHashMap(IHasher<K> hasher) {
        super(hasher);
        this.accessOrder = false;
    }

    public theLinkedHashMap(Map<? extends K, ? extends V> m) {
        super(m);
        this.accessOrder = false;
    }

    public theLinkedHashMap(IHasher<K> hasher, Map<? extends K, ? extends V> m) {
        super(hasher, m);
        this.accessOrder = false;
    }

    public theLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    public theLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder, IHasher<K> hasher) {
        super(initialCapacity, loadFactor, hasher);
        this.accessOrder = accessOrder;
    }

    @Override
    void init() {
        this.header = new Entry<Object, Object>(this.getHasher(), -1, null, null, null);
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    void transfer(theHashMap.Entry[] newTable) {
        int newCapacity = newTable.length;
        Entry e = this.header.after;
        while (e != this.header) {
            int index = theLinkedHashMap.indexFor(e.hash, newCapacity);
            e.next = newTable[index];
            newTable[index] = e;
            e = e.after;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            Entry e = this.header.after;
            while (e != this.header) {
                if (e.value == null) {
                    return true;
                }
                e = e.after;
            }
        } else {
            Entry e = this.header.after;
            while (e != this.header) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.after;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Entry e = (Entry)this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.recordAccess(this);
        return (V)e.value;
    }

    @Override
    public void clear() {
        super.clear();
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    Iterator<K> newKeyIterator() {
        return new KeyIterator(this);
    }

    @Override
    Iterator<V> newValueIterator() {
        return new ValueIterator(this);
    }

    @Override
    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator(this);
    }

    @Override
    void addEntry(int hash, K key, V value, int bucketIndex) {
        this.createEntry(hash, key, value, bucketIndex);
        Entry eldest = this.header.after;
        if (this.removeEldestEntry(eldest)) {
            this.removeEntryForKey(eldest.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    @Override
    void createEntry(int hash, K key, V value, int bucketIndex) {
        Entry<K, V> e;
        theHashMap.Entry old = this.table[bucketIndex];
        this.table[bucketIndex] = e = new Entry<K, V>(this.getHasher(), hash, key, value, old);
        e.addBefore(this.header);
        ++this.size;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    @Override
    public Map<K, V> convert() {
        if (this.getHasher() instanceof PtrHasher) {
            return new LinkedIdentityHashMap(this);
        }
        return new LinkedHashMap(this);
    }

    private static class Entry<K, V>
    extends theHashMap.Entry<K, V> {
        Entry<K, V> before;
        Entry<K, V> after;

        Entry(IHasher<K> hasher, int hash, K key, V value, theHashMap.Entry<K, V> next) {
            super(hasher, hash, key, value, next);
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(Entry<K, V> existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        void recordAccess(theHashMap<K, V> m) {
            theLinkedHashMap lm = (theLinkedHashMap)m;
            if (lm.accessOrder) {
                ++lm.modCount;
                this.remove();
                this.addBefore(lm.header);
            }
        }

        @Override
        void recordRemoval(theHashMap<K, V> m) {
            this.remove();
        }
    }

    private class KeyIterator
    extends LinkedHashIterator<K> {
        private KeyIterator(theLinkedHashMap theLinkedHashMap2) {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends LinkedHashIterator<V> {
        private ValueIterator(theLinkedHashMap theLinkedHashMap2) {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class EntryIterator
    extends LinkedHashIterator<Map.Entry<K, V>> {
        private EntryIterator(theLinkedHashMap theLinkedHashMap2) {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        Entry<K, V> nextEntry;
        Entry<K, V> lastReturned;
        int expectedModCount;

        private LinkedHashIterator() {
            this.nextEntry = theLinkedHashMap.this.header.after;
            this.lastReturned = null;
            this.expectedModCount = theLinkedHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != theLinkedHashMap.this.header;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (theLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            theLinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = theLinkedHashMap.this.modCount;
        }

        Entry<K, V> nextEntry() {
            if (theLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == theLinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            Entry e = this.lastReturned;
            this.nextEntry = e.after;
            return e;
        }
    }
}

