/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.io;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.MultiLineLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiTextField;

public class MPIUtil {
    public static boolean mpiAuth(Window parent, File mpi, int mpiPort) {
        try {
            String uname;
            if (MPIUtil.checkValidation(mpi, mpiPort)) {
                return true;
            }
            List<String> listing = MPIUtil.listInput(mpi, mpiPort, "-whoami");
            String name = listing.isEmpty() ? "" : listing.get(listing.size() - 1);
            int sep = name.indexOf(92);
            if (0 <= sep) {
                String domain = name.substring(0, sep);
                uname = name.substring(sep + 1);
                name = String.format("%s\\%s", domain.toUpperCase(), uname);
            }
            while (true) {
                PasswordDlg dlg;
                if ((dlg = new PasswordDlg(parent, name)).doModal() != 1) {
                    return false;
                }
                uname = dlg.getUser();
                if (uname.isEmpty()) {
                    MPIUtil.authError(parent, Intl.intl("MPI requires a user name."));
                    continue;
                }
                char[] pw = dlg.getPassword();
                if (pw.length == 0) {
                    MPIUtil.authError(parent, Intl.intl("MPI requires a non-blank password."));
                    continue;
                }
                String[] args = MPIUtil.getMPIArgs(mpi, mpiPort, "-register");
                Process p = Runtime.getRuntime().exec(args, null, mpi.getParentFile());
                PrintWriter stdin = new PrintWriter(p.getOutputStream());
                stdin.println(uname);
                stdin.println(pw);
                stdin.println(pw);
                stdin.flush();
                Arrays.fill(pw, '0');
                MPIUtil.listInput(p, false);
                if (MPIUtil.checkValidation(mpi, mpiPort)) {
                    return true;
                }
                MPIUtil.authError(parent, Intl.intl("The password you entered is invalid."));
            }
        }
        catch (MPIAuthException e) {
            String msg = e.getLocalizedMessage();
            if (msg.isEmpty()) {
                msg = MPIUtil.formatException(e);
            }
            MPIUtil.authError(parent, msg);
        }
        catch (IOException e) {
            e.printStackTrace();
            String msg = MPIUtil.formatException(e);
            MPIUtil.authError(parent, msg);
        }
        return false;
    }

    private static String formatException(Exception e) {
        return String.format(Intl.intl("An unknown error ocurred running mpiexec:%n%s"), e.getClass().getSimpleName() + ": " + e.getLocalizedMessage());
    }

    private static void authError(Window parent, String msg) {
        JOptionPane.showMessageDialog(parent, msg, Intl.intl("Authorization Error"), 0);
    }

    private static boolean checkValidation(File mpi, int port) throws IOException, MPIAuthException {
        List<String> listing = MPIUtil.listInput(mpi, port, "-validate");
        Object exceptionMsg = "";
        for (String line : listing) {
            System.out.println(line);
            if (line.toUpperCase().startsWith("SUCCESS")) {
                return true;
            }
            if (line.toUpperCase().startsWith("FAIL")) {
                return false;
            }
            if (line.isEmpty()) continue;
            if (!((String)exceptionMsg).isEmpty()) {
                exceptionMsg = (String)exceptionMsg + "\n";
            }
            exceptionMsg = (String)exceptionMsg + line;
        }
        throw new MPIAuthException((String)exceptionMsg);
    }

    private static List<String> listInput(File mpi, int port, String mpiArgument) throws IOException {
        String[] args = MPIUtil.getMPIArgs(mpi, port, mpiArgument);
        File dir = mpi.getParentFile();
        Process p = Runtime.getRuntime().exec(args, null, dir);
        return MPIUtil.listInput(p, false);
    }

    private static List<String> listInput(Process p, boolean inline) throws IOException {
        InputCatcher inCatcher = new InputCatcher(p.getInputStream());
        if (inline) {
            inCatcher.run();
            new InputCatcher(p.getErrorStream()).run();
        } else {
            Thread tIn = new Thread(inCatcher);
            Thread tErr = new Thread(new InputCatcher(p.getErrorStream()));
            tIn.start();
            tErr.start();
            try {
                p.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                tIn.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                tErr.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (inCatcher.d_caughtError != null) {
            throw inCatcher.d_caughtError;
        }
        return inCatcher.d_input;
    }

    private static String[] getMPIArgs(File mpi, int mpiPort, String arg) {
        return new String[]{mpi.getAbsolutePath(), arg, "-port", Integer.toString(mpiPort)};
    }

    public static void main(String[] args) {
        File mpi = new File("C:\\Program Files\\PyroSim 2011\\fds64\\mpiexec.exe");
        MPIUtil.mpiAuth(null, mpi, 52401);
    }

    private static class PasswordDlg
    extends guiDialog {
        private static final long serialVersionUID = -466812672112895258L;
        private final JPasswordField d_password;
        private final guiTextField d_user;

        public PasswordDlg(Window owner, String username) {
            super(owner, Intl.intl("Enter Password"), 9);
            MultiLineLabel header = new MultiLineLabel(Intl.intl("Please enter a password for MPI to start processes on your computer."));
            header.setColumns(30);
            guiLabel userLabel = new guiLabel(Intl.intl("Username:"));
            guiLabel passLabel = new guiLabel(Intl.intl("Password:"));
            this.d_user = new guiTextField(username);
            this.d_password = new JPasswordField();
            this.d_password.setEchoChar('*');
            guiPanel panel = this.getDialogPane();
            panel.setLayout(new GridBagLayout());
            GridBagUtil.add(panel, header, 0, 0, 2, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, userLabel, 0, 1, 1, 1, 0, 0, 12, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, this.d_user, 1, 1, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(panel, passLabel, 0, 2, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, this.d_password, 1, 2, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    d_user.requestFocusInWindow();
                }
            });
        }

        public char[] getPassword() {
            return this.d_password.getPassword();
        }

        public String getUser() {
            return this.d_user.getValue();
        }
    }

    private static class MPIAuthException
    extends Exception {
        private static final long serialVersionUID = -905313115129454536L;

        public MPIAuthException(String msg) {
            super(msg);
        }
    }

    private static class InputCatcher
    implements Runnable {
        private final List<String> d_input;
        private final InputStream d_stream;
        private IOException d_caughtError = null;

        public InputCatcher(InputStream is) {
            this.d_stream = is;
            this.d_input = new ArrayList<String>();
        }

        @Override
        public void run() {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.d_stream));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.d_input.add(line);
                }
            }
            catch (IOException e) {
                this.d_caughtError = e;
            }
        }
    }
}

