/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.table;

import java.awt.GridBagLayout;
import javax.swing.JScrollPane;
import pyrosim.legacy_2012_1.thunderheadeng.gui.CmdButton;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiCheckBox;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiTable;

public class guiTableEditor
extends guiPanel {
    private static final long serialVersionUID = 8078258993353607763L;
    public static final int NONE = 0;
    public static final int REMOVE_ROW = 2;
    public static final int INSERT_ROW = 4;
    public static final int MOVE_ROW_UP_DOWN = 8;
    public static final int CUT_COPY_PASTE = 16;
    public static final int SORT_BOX = 32;
    public static final int ALL = 62;
    public static final int ALL_NO_SORT = 30;
    private guiTable d_table;
    private CmdButton d_removeRow;
    private CmdButton d_insertRow;
    private CmdButton d_rowUp;
    private CmdButton d_rowDown;
    private guiCheckBox d_sortBox;

    public guiTableEditor(guiTable table, int options) {
        this.d_table = table;
        this.initialize(options);
    }

    private void initialize(int options) {
        this.setLayout(new GridBagLayout());
        JScrollPane sPane = new JScrollPane(this.d_table);
        GridBagUtil.add(this, sPane, 0, 0, 1, 10, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
        sPane.getViewport().setScrollMode(2);
        boolean insert = (options & 4) != 0;
        boolean remove = (options & 2) != 0;
        boolean sort = (options & 0x20) != 0;
        boolean upDown = (options & 8) != 0;
        boolean cutCopyPaste = (options & 0x10) != 0;
        int nextRow = 0;
        int separationSpace = 0;
        if (insert) {
            this.d_insertRow = new CmdButton(this.d_table.getInsertRowCommand());
            GridBagUtil.add(this, this.d_insertRow, 1, nextRow++, 1, 1, 0, 11, 0, 0, 2, 0.0, 0.0, 11);
        }
        if (remove) {
            this.d_removeRow = new CmdButton(this.d_table.getRemoveRowCommand());
            GridBagUtil.add(this, this.d_removeRow, 1, nextRow++, 1, 1, 5, 11, 0, 0, 2, 0.0, 0.0, 11);
        }
        if (insert || remove) {
            separationSpace = 6;
        }
        if (upDown) {
            this.d_rowUp = new CmdButton(this.d_table.getMoveRowUpCommand());
            this.d_rowDown = new CmdButton(this.d_table.getMoveRowDownCommand());
            GridBagUtil.add(this, this.d_rowUp, 1, nextRow++, 1, 1, 5 + separationSpace, 11, 0, 0, 2, 0.0, 0.0, 11);
            GridBagUtil.add(this, this.d_rowDown, 1, nextRow++, 1, 1, 5, 11, 0, 0, 2, 0.0, 0.0, 11);
            separationSpace = 6;
        }
        if (cutCopyPaste) {
            GridBagUtil.add(this, new CmdButton(this.d_table.getCopyCommand()), 1, nextRow++, 1, 1, 5 + separationSpace, 11, 0, 0, 2, 0.0, 0.0, 11);
            GridBagUtil.add(this, new CmdButton(this.d_table.getPasteCommand()), 1, nextRow++, 1, 1, separationSpace, 11, 0, 0, 2, 0.0, 0.0, 11);
            GridBagUtil.add(this, new CmdButton(this.d_table.getCutCommand()), 1, nextRow++, 1, 1, separationSpace, 11, 0, 0, 2, 0.0, 0.0, 11);
            separationSpace = 6;
        }
        if (sort) {
            this.d_sortBox = new guiCheckBox(this.d_table.getEnableSortCommand());
            GridBagUtil.add(this, this.d_sortBox, 1, nextRow++, 1, 1, 5 + separationSpace, 11, 0, 0, 2, 0.0, 0.0, 11);
        }
    }

    public guiTable getTable() {
        return this.d_table;
    }
}

