/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.table;

import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.ResizableTableModel;

public class guiDefaultTableModel
extends DefaultTableModel
implements ResizableTableModel {
    private static final long serialVersionUID = -5736190724477829675L;
    private int d_maxRows;
    private int d_maxColumns;
    private boolean d_canAddRows;
    private boolean d_canAddColumns;
    private Vector d_columnClasses;

    public guiDefaultTableModel() {
        this(0, 0);
    }

    public guiDefaultTableModel(int rows, int columns) {
        this(rows, columns, true, Integer.MAX_VALUE, true, Integer.MAX_VALUE);
    }

    public guiDefaultTableModel(int rows, int columns, boolean canAddRows, int maxRows, boolean canAddColumns, int maxColumns) {
        super(rows, columns);
        this.d_canAddRows = canAddRows;
        this.d_maxRows = maxRows;
        this.d_canAddColumns = canAddColumns;
        this.d_maxColumns = maxColumns;
        this.d_columnClasses = new Vector(columns);
        this.d_columnClasses.setSize(columns);
    }

    @Override
    public int getMaxRows() {
        return this.d_maxRows;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex >= this.getColumnCount()) {
            return this.getColumnClass(this.getColumnCount() - 1);
        }
        Class c = (Class)this.d_columnClasses.get(columnIndex);
        if (c == null) {
            return super.getColumnClass(columnIndex);
        }
        return c;
    }

    public void setColumnClass(int columnIndex, Class colClass) {
        this.d_columnClasses.set(columnIndex, colClass);
    }

    public void setColumnClass(Class colClass) {
        int max = this.getColumnCount();
        for (int i = 0; i < max; ++i) {
            this.setColumnClass(i, colClass);
        }
    }

    @Override
    public void setColumnCount(int count) {
        this.d_columnClasses.setSize(count);
        super.setColumnCount(count);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        boolean ok = true;
        if (rowIndex >= this.getRowCount()) {
            if (this.d_canAddRows && rowIndex < this.d_maxRows) {
                this.setRowCount(rowIndex + 1);
            } else {
                ok = false;
            }
        }
        if (columnIndex >= this.getColumnCount()) {
            if (this.d_canAddColumns && columnIndex < this.d_maxColumns) {
                this.setColumnCount(columnIndex + 1);
            } else {
                ok = false;
            }
        }
        if (ok) {
            super.setValueAt(aValue, rowIndex, columnIndex);
        }
    }

    @Override
    public void insertRow(int row, Object[] rowData) {
        if (this.d_canAddRows && this.getRowCount() < this.d_maxRows) {
            super.insertRow(row, rowData);
        }
    }
}

