/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.table;

import java.util.Arrays;
import javax.swing.table.TableModel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.SortObject;

class SortMod {
    public static final int NONE = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    private TableModel d_model;
    private SortObject[] d_sortArray;
    private int d_sortColIndex;
    private int d_sortDir;

    public int getSortOrder() {
        return this.d_sortDir;
    }

    public int getSortColumn() {
        return this.d_sortColIndex;
    }

    public void sort(TableModel mod, int column, int dir) {
        this.d_model = mod;
        this.d_sortColIndex = column;
        this.d_sortDir = dir;
        this.d_sortArray = null;
        if (dir != 0) {
            int numRows = this.d_model.getRowCount();
            this.d_sortArray = new SortObject[numRows];
            for (int i = 0; i < numRows; ++i) {
                this.d_sortArray[i] = new SortObject((Comparable)this.d_model.getValueAt(i, column), i);
            }
            Arrays.sort(this.d_sortArray);
        }
    }

    public int getModelIndex(int sortedIndex) {
        if (this.d_sortArray == null) {
            return sortedIndex;
        }
        if (sortedIndex < 0) {
            return -1;
        }
        if (sortedIndex >= this.d_sortArray.length) {
            return sortedIndex;
        }
        if (this.d_sortDir == 1) {
            return this.d_sortArray[sortedIndex].getIndex();
        }
        if (this.d_sortDir == 2) {
            int maxrow = this.d_model.getRowCount() - 1;
            return this.d_sortArray[maxrow - sortedIndex].getIndex();
        }
        return sortedIndex;
    }

    public int getSortIndex(int modelRowIndex) {
        if (modelRowIndex < 0) {
            return -1;
        }
        if (this.d_sortDir == 0) {
            return modelRowIndex;
        }
        for (int i = 0; i < this.d_sortArray.length; ++i) {
            if (this.d_sortArray[i].getIndex() != modelRowIndex) continue;
            if (this.d_sortDir == 1) {
                return i;
            }
            int maxrow = this.d_model.getRowCount() - 1;
            return maxrow - i;
        }
        return -1;
    }
}

