/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.table;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.StringTokenizer;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ClipboardTableModel
implements TableModel {
    public static final String COL_SEPARATOR = "\t";
    public static final String ROW_SEPARATOR = "\n";
    private TableModel d_theModel;

    public ClipboardTableModel(TableModel theModel) {
        this.d_theModel = theModel;
    }

    public void paste(int pasteRow, int pasteCol) {
        String str;
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable content = cb.getContents(this);
        try {
            str = (String)content.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Throwable e) {
            return;
        }
        StringTokenizer rows = new StringTokenizer(str, ROW_SEPARATOR, true);
        String lastRowToken = "";
        String currRowToken = "";
        int row = pasteRow;
        while (rows.hasMoreTokens()) {
            currRowToken = rows.nextToken();
            if (currRowToken.equals(ROW_SEPARATOR)) {
                if (lastRowToken.equals(ROW_SEPARATOR)) {
                    this.d_theModel.setValueAt("", row, pasteCol);
                } else {
                    this.pasteRow(lastRowToken, row, pasteCol);
                }
                ++row;
            }
            lastRowToken = currRowToken;
        }
        if (!lastRowToken.equals(ROW_SEPARATOR)) {
            this.pasteRow(lastRowToken, row, pasteCol);
        }
    }

    private void pasteRow(String data, int row, int col) {
        String lastColToken = "";
        String currColToken = "";
        StringTokenizer columns = new StringTokenizer(data, COL_SEPARATOR, true);
        while (columns.hasMoreTokens()) {
            currColToken = columns.nextToken();
            if (currColToken.equals(COL_SEPARATOR)) {
                if (lastColToken.equals(COL_SEPARATOR)) {
                    this.d_theModel.setValueAt("", row, col);
                } else {
                    this.d_theModel.setValueAt(lastColToken, row, col);
                }
                ++col;
            }
            lastColToken = currColToken;
        }
        if (!lastColToken.equals(COL_SEPARATOR)) {
            this.d_theModel.setValueAt(lastColToken, row, col);
        }
    }

    @Override
    public int getRowCount() {
        return this.d_theModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.d_theModel.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.d_theModel.getColumnName(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.d_theModel.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.d_theModel.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.d_theModel.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.d_theModel.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.d_theModel.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.d_theModel.removeTableModelListener(l);
    }
}

