/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiStatusMessage;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiStatusMessageListener;

public class guiStatusBar
extends JPanel
implements guiStatusMessageListener {
    private static final long serialVersionUID = -5906246783055426440L;
    public static Border BEVEL_BORDER = BorderFactory.createBevelBorder(1);
    public static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(3, 3, 3, 3);
    public static final double SEPARATOR_HEIGHT_SCALE = 1.1;
    private ArrayList<JComponent> d_labels;
    private int d_paneHeight;
    private int d_nextX;
    private Border d_border = EMPTY_BORDER;
    private guiStatusMessage d_message;

    public guiStatusBar() {
        super(new GridBagLayout());
        this.init(new double[]{-1.0});
    }

    public guiStatusBar(String[] exampleValues) {
        super(new GridBagLayout());
        this.init(new double[]{-1.0});
    }

    public guiStatusBar(double[] widths) {
        super(new GridBagLayout());
        this.init(widths);
    }

    private void init(double[] widths) {
        this.d_labels = new ArrayList();
        this.d_nextX = 0;
        JLabel lab = new JLabel(" ");
        this.d_paneHeight = lab.getPreferredSize().height;
        for (int i = 0; i < widths.length; ++i) {
            this.addPane(lab, widths[i]);
            lab = new JLabel(" ");
        }
    }

    public int addPane(JComponent pane, double width) {
        int index = this.d_labels.size();
        if (index > 0) {
            this.addSeparator();
        }
        this.d_labels.add(pane);
        Border oldBorder = pane.getBorder();
        pane.setBorder(BorderFactory.createCompoundBorder(this.d_border, oldBorder));
        int fill = 3;
        double weight = 0.0;
        if (width < 0.0) {
            fill = 1;
            weight = -width;
        } else {
            pane.setPreferredSize(new Dimension((int)width, this.d_paneHeight));
        }
        GridBagUtil.add(this, pane, this.d_nextX++, 0, 1, 1, 0, 0, 0, 0, fill, weight, 1.0);
        return index;
    }

    protected void addSeparator() {
        JSeparator separator = new JSeparator(1){
            private static final long serialVersionUID = -8434096832730239730L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, (int)Math.round((double)guiStatusBar.this.d_paneHeight * 1.1));
            }
        };
        GridBagUtil.add(this, separator, this.d_nextX++, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 15);
    }

    public void setLabelBorder(Border border) {
        this.d_border = border;
        for (JComponent comp : this.d_labels) {
            comp.setBorder(border);
        }
    }

    public void setStatusMessage(guiStatusMessage message) {
        JButton b = new JButton();
        b.addActionListener(null);
        if (this.d_message != null) {
            this.d_message.removeStatusListener(this);
        }
        this.d_message = message;
        if (this.d_message != null) {
            this.d_message.addStatusListener(this);
        }
    }

    public guiStatusMessage getStatusMessage() {
        return this.d_message;
    }

    public void setMessage(String message) {
        this.setMessage(0, message);
    }

    public void setMessage(int panelIndex, String message) {
        JComponent c;
        if (message == null || message.equals("")) {
            message = " ";
        }
        if ((c = this.d_labels.get(panelIndex)) instanceof JLabel) {
            ((JLabel)c).setText(message);
        } else {
            c.setName(message);
        }
    }

    public void clearMessages() {
        for (int i = 0; i < this.d_labels.size(); ++i) {
            this.setMessage(i, "");
        }
    }

    @Override
    public void statusMessageChanged(String oldMessage, String newMessage) {
        this.setMessage(newMessage);
    }
}

