/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;

public class guiProgressMonitor {
    private guiDialog d_dialog;
    private guiLabel d_noteLbl;
    private guiLabel d_messageLbl;
    private JProgressBar d_progBar;
    private boolean d_indeterminate;
    private volatile boolean d_cancelled;
    private volatile boolean d_showingProgress;
    private Component d_parent;
    private String d_title;
    private String d_note;
    private String d_message;

    public guiProgressMonitor(Component parentComponent, String message, String note, int min, int max) {
        assert (parentComponent instanceof JFrame || parentComponent instanceof JDialog);
        this.d_cancelled = false;
        this.d_showingProgress = false;
        this.d_parent = parentComponent;
        this.d_title = Intl.intl("Progress");
        this.d_note = note;
        this.d_message = message;
        this.d_progBar = new JProgressBar();
        this.setMinimum(min);
        this.setMaximum(max);
        this.d_noteLbl = new guiLabel(this.d_note);
        this.d_messageLbl = new guiLabel(this.d_message);
        this.d_dialog = new guiDialog(null);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.d_progBar.setIndeterminate(indeterminate);
        this.checkProgress();
    }

    public boolean isIndeterminate() {
        return this.d_progBar.isIndeterminate();
    }

    public void show() {
        this.d_showingProgress = true;
        this.d_dialog = this.createDialog();
        new Thread(){

            @Override
            public void run() {
                int result = guiProgressMonitor.this.d_dialog.doModal();
                if (result != 1) {
                    guiProgressMonitor.this.d_cancelled = true;
                    guiProgressMonitor.this.d_showingProgress = false;
                }
            }
        }.start();
    }

    public void close() {
        this.close(16);
    }

    private void close(int status) {
        this.d_showingProgress = false;
        this.d_dialog.endModal(status);
    }

    public int getMaximum() {
        return this.d_progBar.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.d_progBar.setMaximum(maximum);
    }

    public int getMinimum() {
        return this.d_progBar.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.d_progBar.setMinimum(minimum);
    }

    public String getMessage() {
        return this.d_message;
    }

    public void setMessage(String message) {
        this.d_message = message;
        this.d_messageLbl.setText(message);
        this.d_dialog.repaint();
    }

    public String getNote() {
        return this.d_note;
    }

    public void setNote(String note) {
        this.d_note = note;
        this.d_noteLbl.setText(note);
        this.d_dialog.repaint();
    }

    public boolean isCancelled() {
        return this.d_cancelled;
    }

    public void setProgress(int nv) {
        this.d_progBar.setValue(nv);
        this.checkProgress();
    }

    private guiDialog createDialog() {
        guiDialog dialog = this.d_parent instanceof JFrame ? new guiDialog((Window)((JFrame)this.d_parent), this.d_title, 8) : new guiDialog((Window)((JDialog)this.d_parent), this.d_title, 8);
        Icon icon = UIManager.getIcon("OptionPane.informationIcon");
        guiLabel iconLbl = new guiLabel(icon);
        this.d_progBar.setPreferredSize(new Dimension(200, this.d_progBar.getPreferredSize().height));
        guiPanel iconPanel = new guiPanel(new BorderLayout());
        iconPanel.add((Component)iconLbl, "North");
        guiPanel messagePanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(messagePanel, this.d_messageLbl, 0, 0, 1, 1, 0, 6, 6, 0, 0, 1.0, 1.0, 17);
        GridBagUtil.add(messagePanel, this.d_noteLbl, 0, 1, 1, 1, 0, 6, 6, 0, 0, 1.0, 1.0, 17);
        GridBagUtil.add(messagePanel, this.d_progBar, 0, 2, 1, 1, 0, 6, 0, 0, 2, 1.0, 1.0, 17);
        guiPanel cp = dialog.getDialogPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)iconPanel, "West");
        cp.add((Component)messagePanel, "Center");
        dialog.setResizable(true);
        return dialog;
    }

    private void checkProgress() {
        if (!this.d_showingProgress) {
            if (this.d_progBar.getValue() < this.d_progBar.getMaximum() || this.d_progBar.isIndeterminate()) {
                this.show();
            }
        } else if (this.d_progBar.getValue() >= this.d_progBar.getMaximum() && !this.d_progBar.isIndeterminate()) {
            this.close(1);
        }
    }
}

