/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Modifiable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.SimpleColorChooser;

public class ColorChooser {
    private Window d_owner;
    private String d_title;
    private Color d_color;
    private SimpleColorChooser d_chooser;

    public ColorChooser(Window owner, String title) {
        this(owner, title, new JButton().getBackground());
    }

    public ColorChooser(Window owner, String title, Color initialColor) {
        this.d_owner = owner;
        this.d_title = title;
        this.d_color = initialColor == null ? Color.GRAY : initialColor;
    }

    public JButton createEditorButton() {
        ColorButton btn = new ColorButton();
        btn.setColor(this.d_color);
        return btn;
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color c) {
        this.d_color = c;
    }

    class ColorButton
    extends JButton
    implements Modifiable {
        private static final long serialVersionUID = 6914609526722247896L;
        private boolean d_modified = false;

        public ColorButton() {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (ColorChooser.this.d_chooser == null) {
                        ColorChooser.this.d_chooser = new SimpleColorChooser(ColorChooser.this.d_owner, ColorChooser.this.d_title);
                    }
                    ColorChooser.this.d_chooser.setColor(ColorChooser.this.d_color);
                    if (ColorChooser.this.d_chooser.doModal() == 1) {
                        ColorButton.this.setColor(ColorChooser.this.d_chooser.getColor());
                    }
                }
            });
            this.setText("MMM");
        }

        public void setColor(Color c) {
            ColorChooser.this.d_color = c;
            this.d_modified = true;
            this.repaint();
        }

        public Color getColor() {
            return ColorChooser.this.d_color;
        }

        @Override
        public void paintComponent(Graphics g) {
            Rectangle rect = this.getVisibleRect();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, rect.width, rect.height);
            super.paintBorder(g);
            int offsetX = 6;
            int offsetY = 5;
            rect.width -= 2 * offsetX + 1;
            rect.height -= 2 * offsetY + 1;
            g.setColor(ColorChooser.this.d_color);
            g.fillRect(offsetX, offsetY, rect.width, rect.height);
            g.setColor(Color.black);
            g.drawRect(offsetX, offsetY, rect.width, rect.height);
        }

        @Override
        public boolean isModified() {
            return this.d_modified;
        }

        @Override
        public void setModified(boolean modified) {
            this.d_modified = modified;
        }
    }
}

