/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Modifiable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.SimpleColorChooser;
import pyrosim.legacy_2012_1.thunderheadeng.util.ColorPool;
import thunderheadeng.gui.Application;

public class ColorButton
extends JButton
implements Modifiable {
    private static final long serialVersionUID = -6531505849770221371L;
    private SimpleColorChooser d_chooser;
    private Color d_color = this.getBackground();
    private boolean d_modified = false;
    private final List d_observers = new LinkedList();

    public ColorButton() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorButton.this.editColor();
            }
        });
        this.setText("MMM");
    }

    public void editColor() {
        if (this.d_chooser == null) {
            this.d_chooser = new SimpleColorChooser((Window)Application.getApp().getActiveFrame(), Intl.intl("Color"));
        }
        this.d_chooser.setColor(this.d_color);
        if (this.d_chooser.doModal() == 1) {
            this.setColor(this.d_chooser.getColor());
            this.yell();
        }
    }

    public void setColor(Color c) {
        this.d_color = c;
        this.d_modified = true;
        this.repaint();
    }

    public Color getColor() {
        return this.d_color;
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle rect = this.getVisibleRect();
        super.paintComponent(g);
        int offsetX = 6;
        int offsetY = 5;
        rect.width -= 2 * offsetX + 1;
        rect.height -= 2 * offsetY + 1;
        Color fillColor = this.d_color.getAlpha() == 255 ? this.d_color : ColorPool.get(new Color(this.d_color.getRed(), this.d_color.getGreen(), this.d_color.getBlue(), 255));
        g.setColor(fillColor);
        g.fillRect(offsetX, offsetY, rect.width, rect.height);
        g.setColor(Color.black);
        g.drawRect(offsetX, offsetY, rect.width, rect.height);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }

    public void yell() {
        for (Object o : this.d_observers) {
            ((Observer)o).update(null, null);
        }
    }

    public void addObserver(Observer o) {
        this.d_observers.add(o);
    }

    public void deleteObserver(Observer o) {
        this.d_observers.remove(o);
    }
}

