/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;

public class WaitCursorMgr {
    public static final int DEFAULT_DELAY = 250;
    private List<? extends Component> d_components;
    private static final MouseListener MOUSE_TRAP = new MouseAdapter(){};
    private int d_waitCursorCount = 0;
    private Timer d_waitTimer = null;
    private boolean d_waiting = false;

    public WaitCursorMgr(Component ... comps) {
        this(Arrays.asList(comps));
    }

    public WaitCursorMgr(List<? extends Component> components) {
        this.d_components = components;
    }

    public void setComponents(List<? extends Component> comps) {
        this.d_components = comps;
    }

    public void beginWaitCursor() {
        this.beginWaitCursor(0);
    }

    public void beginWaitCursor(boolean delay) {
        int delayTime = delay ? 250 : 0;
        this.beginWaitCursor(delayTime);
    }

    public void beginWaitCursor(final int delay) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitCursorMgr.this.forceBeginWaitCursor(delay);
                }
            });
        } else {
            this.forceBeginWaitCursor(delay);
        }
    }

    private void forceBeginWaitCursor(int delay) {
        if (++this.d_waitCursorCount == 1) {
            if (delay <= 0) {
                this.startWaitCursor();
            } else {
                this.d_waitTimer = new Timer();
                this.d_waitTimer.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        WaitCursorMgr waitCursorMgr = WaitCursorMgr.this;
                        synchronized (waitCursorMgr) {
                            WaitCursorMgr.this.startWaitCursor();
                        }
                    }
                }, delay);
            }
        }
    }

    private void startWaitCursor() {
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        for (Component component : this.d_components) {
            if (component instanceof RootPaneContainer) {
                JRootPane root = ((RootPaneContainer)((Object)component)).getRootPane();
                root.setCursor(waitCursor);
                Component glass = root.getGlassPane();
                glass.addMouseListener(MOUSE_TRAP);
                glass.setVisible(true);
                continue;
            }
            component.setCursor(waitCursor);
        }
        this.d_waiting = true;
    }

    public void endWaitCursor() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitCursorMgr.this.forceEndWaitCursor();
                }
            });
        } else {
            this.forceEndWaitCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceEndWaitCursor() {
        if (--this.d_waitCursorCount == 0) {
            if (this.d_waitTimer != null) {
                this.d_waitTimer.cancel();
                this.d_waitTimer = null;
            }
            WaitCursorMgr waitCursorMgr = this;
            synchronized (waitCursorMgr) {
                if (this.d_waiting) {
                    this.stopWaitCursor();
                }
            }
        }
    }

    private void stopWaitCursor() {
        for (Component component : this.d_components) {
            if (component instanceof RootPaneContainer) {
                JRootPane root = ((RootPaneContainer)((Object)component)).getRootPane();
                root.setCursor(null);
                Component glass = root.getGlassPane();
                glass.removeMouseListener(MOUSE_TRAP);
                glass.setVisible(false);
                continue;
            }
            component.setCursor(null);
        }
        this.d_waiting = false;
    }
}

