/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value;
    private Thread thread;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x) {
        this.value = x;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread t;
        while ((t = this.threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        this.init();
    }

    private void init() {
        RunConstructor doConstruct = new RunConstructor();
        Thread t = new Thread(doConstruct);
        this.threadVar = new ThreadVar(t);
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.start();
        } else {
            this.init();
            t = this.threadVar.get();
            t.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }

    private class RunConstructor
    implements Runnable {
        private RunConstructor() {
        }

        @Override
        public void run() {
            try {
                SwingWorker.this.setValue(SwingWorker.this.construct());
            }
            finally {
                SwingWorker.this.threadVar.clear();
            }
            SwingUtilities.invokeLater(new DoFinished());
        }
    }

    private class DoFinished
    implements Runnable {
        private DoFinished() {
        }

        @Override
        public void run() {
            SwingWorker.this.finished();
        }
    }
}

