/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.basic.BasicArrowButton;

public class SplitButton
extends JButton {
    private static final long serialVersionUID = -8868284652560095900L;
    private JPopupMenu dropDownMenu;
    private int d_orient;
    private boolean d_mouseInside = false;
    private Point d_mouseEvtLoc = null;

    public SplitButton() {
        this(" ");
    }

    public SplitButton(String text) {
        this(text, 5);
    }

    public SplitButton(String text, int orientation) {
        super(text);
        this.d_orient = orientation;
        this.setHorizontalAlignment(2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SplitButton.this.d_mouseInside = true;
                SplitButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SplitButton.this.d_mouseInside = false;
                SplitButton.this.repaint();
            }
        });
    }

    public void setArrowOrient(int orient) {
        this.d_orient = orient;
    }

    public int getArrowOrient() {
        return this.d_orient;
    }

    public void setMenu(JPopupMenu menu) {
        this.dropDownMenu = menu;
    }

    public JPopupMenu getMenu() {
        return this.dropDownMenu;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        this.d_mouseEvtLoc = e.getPoint();
        super.processMouseEvent(e);
        this.d_mouseEvtLoc = null;
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        if (this.isOverDropdownBtn(this.d_mouseEvtLoc)) {
            if (this.dropDownMenu == null) {
                return;
            }
            if (!this.dropDownMenu.isVisible()) {
                int x = 0;
                int y = this.getPreferredSize().height;
                this.dropDownMenu.show(this, x, y);
            } else {
                this.dropDownMenu.setVisible(false);
            }
            return;
        }
        super.fireActionPerformed(event);
    }

    private boolean isOverDropdownBtn(Point p) {
        if (this.d_mouseEvtLoc == null) {
            return false;
        }
        return p.x > this.getActionPreferredSize().width - 3;
    }

    @Override
    public void addActionListener(ActionListener al) {
        super.addActionListener(al);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g = g.create();
        super.paintComponent(g);
        g.translate(this.getActionPreferredSize().width - 3, 0);
        CustomSep sep = new CustomSep();
        g.translate(sep.getPreferredSize().width - 3, 0);
        CustomArrow arrow = new CustomArrow(this.d_orient);
        arrow.setEnabled(this.isEnabled());
        arrow.setSize(new Dimension(arrow.getPreferredSize().width, this.getSize().height));
        arrow.paintComponent(g);
        if (this.d_mouseInside) {
            g.translate(-(sep.getPreferredSize().width - 3), 0);
            sep.setSize(new Dimension(sep.getPreferredSize().width, this.getSize().height - this.getInsets().top - this.getInsets().bottom + 1));
            sep.setEnabled(this.isEnabled());
            int yoffset = this.getInsets().top - 1;
            g.translate(0, yoffset);
            sep.paintComponent(g);
            g.translate(0, -yoffset);
        }
        g.dispose();
    }

    private Dimension getActionPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d1 = this.getActionPreferredSize();
        Dimension d2 = new JSeparator(1).getPreferredSize();
        Dimension d3 = new BasicArrowButton(this.d_orient).getPreferredSize();
        int width = d1.width + d2.width + d3.width - 6;
        int height = d1.height;
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.isMinimumSizeSet() ? super.getMinimumSize() : this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.isMaximumSizeSet() ? super.getMaximumSize() : this.getPreferredSize();
    }

    private static class CustomSep
    extends JSeparator {
        private static final long serialVersionUID = -3599408847522726590L;

        public CustomSep() {
            super(1);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
        }
    }

    private static class CustomArrow
    extends BasicArrowButton {
        private static final long serialVersionUID = 4360551273472906899L;

        public CustomArrow(int direction) {
            super(direction);
        }

        @Override
        public void paintComponent(Graphics g) {
            int w = this.getSize().width + 2;
            int h = this.getSize().height;
            int size = Math.min((h - 4) / 3, (w - 4) / 3);
            size = Math.max(size, 2);
            this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, this.isEnabled());
        }
    }
}

