/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

public class SplashScreen {
    private static final int DefaultMillisVisible = 7000;
    private JWindow d_splash;
    private URL d_imageURL;
    private int d_minMillisVisible;
    private int d_hideCount = 0;

    public SplashScreen(URL imageURL) {
        this(imageURL, 7000);
    }

    public SplashScreen(URL imageURL, int minMillisVisible) {
        this.d_imageURL = imageURL;
        this.d_minMillisVisible = minMillisVisible;
        this.showSplash();
    }

    public JWindow getWindow() {
        return this.d_splash;
    }

    public void showSplash() {
        this.d_splash = new JWindow();
        JLabel label = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.d_imageURL)));
        label.setBorder(BorderFactory.createLineBorder(Color.black));
        this.d_splash.getContentPane().add(label);
        this.d_splash.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.d_splash.setLocation(screenSize.width / 2 - this.d_splash.getSize().width / 2, screenSize.height / 2 - this.d_splash.getSize().height / 2);
        this.d_splash.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SplashScreen.this.hideSplash();
            }
        });
        this.d_splash.setVisible(true);
    }

    public void toFront() {
        if (this.d_splash != null) {
            this.d_splash.toFront();
        }
    }

    public void hideSplash() {
        if (++this.d_hideCount > 0 && this.d_splash != null) {
            this.d_splash.setVisible(false);
            this.d_splash.dispose();
            this.d_splash = null;
        }
    }
}

