/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.IDnDTreeModel;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public abstract class AbstractDnDTree
extends JTree
implements DragGestureListener,
DropTargetListener,
DragSourceListener {
    private static final long serialVersionUID = -6453938749789904326L;
    private static final Container CONTAINER = new Container();
    private static final Rectangle ICON_BOUNDS = new Rectangle();
    private static final int ON_ICON = 0;
    private static final int ABOVE = 1;
    private static final int INSIDE = 2;
    private static final int BELOW = 3;
    private static final DataFlavor FLAVOR_OBJ_ARR = new DataFlavor(Object[].class, "Objects in PyroSim's Tree");
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{FLAVOR_OBJ_ARR};
    private final Composite ALPHA_COMPOSITE = AlphaComposite.getInstance(3, 0.8f);
    private final List d_renderNodes;
    private final Point d_mouseDown = new Point();
    private final Point d_mouseCurrent = new Point();
    private final Timer d_hover;
    private boolean d_hoverFeedback;
    private boolean d_canHover = true;
    private IDnDTreeModel.IDragPacket d_dragPacket;
    private Object d_dropTarget = null;
    private int d_dropIndex = -1;
    private boolean d_dropped = false;
    private final DragSource d_dragSource;
    private TreePath d_lastPath = null;
    private final Comparator d_sorter;
    private boolean d_selectParentOnCollapse = true;

    public AbstractDnDTree(IDnDTreeModel model) {
        super(model);
        this.d_renderNodes = new ArrayList();
        this.d_sorter = new PathSorter();
        this.d_dragSource = DragSource.getDefaultDragSource();
        this.d_dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        new DropTarget(this, this);
        this.d_hover = new HoverTimer();
        new MultiSelectHack(this);
    }

    public void setSelectNodeOnCollapse(boolean select) {
        this.d_selectParentOnCollapse = select;
    }

    public boolean selectNodeOnCollapse() {
        return this.d_selectParentOnCollapse;
    }

    @Override
    public void collapsePath(TreePath path) {
        if (this.d_selectParentOnCollapse) {
            super.collapsePath(path);
        } else {
            TreeSelectionModel tsm = this.getSelectionModel();
            this.setSelectionModel(null);
            super.collapsePath(path);
            this.setSelectionModel(tsm);
        }
    }

    @Override
    public void collapseRow(int row) {
        if (this.d_selectParentOnCollapse) {
            super.collapseRow(row);
        } else {
            TreeSelectionModel tsm = this.getSelectionModel();
            this.setSelectionModel(null);
            super.collapseRow(row);
            this.setSelectionModel(tsm);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.getDnDModel().isDragging()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Composite old = g2d.getComposite();
        g2d.setComposite(this.ALPHA_COMPOSITE);
        int dx = this.d_mouseCurrent.x - this.d_mouseDown.x;
        int dy = this.d_mouseCurrent.y - this.d_mouseDown.y;
        for (int i = 0; i < this.d_renderNodes.size(); ++i) {
            Image compImg = ((RenderNode)this.d_renderNodes.get((int)i)).nodeImg;
            Rectangle visRect = ((RenderNode)this.d_renderNodes.get((int)i)).bounds;
            g2d.drawImage(compImg, visRect.x + dx, visRect.y + dy, this);
        }
        if (this.d_dropIndex >= 0) {
            int row;
            TreePath targetPath = this.getSelectionModel().getSelectionPath();
            int childCount = this.getModel().getChildCount(this.d_dropTarget);
            if (childCount == 0) {
                row = this.getRowForPath(targetPath) + 1;
            } else if (childCount <= this.d_dropIndex) {
                child = this.getModel().getChild(this.d_dropTarget, this.d_dropIndex - 1);
                TreePath path = targetPath.pathByAddingChild(child);
                row = this.getRowForPath(path) + 1;
            } else {
                child = this.getModel().getChild(this.d_dropTarget, this.d_dropIndex);
                TreePath path = targetPath.pathByAddingChild(child);
                row = this.getRowForPath(path);
            }
            int y = row * this.getRowHeight();
            g.setColor(Color.BLACK);
            g.drawLine(0, y, this.getWidth(), y);
        }
        if (this.d_hoverFeedback) {
            g.setColor(Color.RED);
            g2d.draw(this.getExpandedIconBounds(this.d_lastPath));
        }
        g2d.setComposite(old);
    }

    public IDnDTreeModel getDnDModel() {
        return (IDnDTreeModel)this.getModel();
    }

    protected IDnDTreeModel.IDragPacket prepareDragPacket() {
        TreeSelectionModel selModel = this.getSelectionModel();
        TreePath[] selPaths = selModel.getSelectionPaths();
        Arrays.sort(selPaths, this.d_sorter);
        TreeCellRenderer cr = this.getCellRenderer();
        Rectangle treeVisRect = this.getVisibleRect();
        int minY = Math.max(0, treeVisRect.y - treeVisRect.height);
        int maxY = treeVisRect.y + treeVisRect.height * 2;
        List<TreePath> paths = Arrays.asList(selPaths);
        for (int i = 0; i < selPaths.length; ++i) {
            Rectangle visRect = this.getPathBounds(selPaths[i]);
            if (visRect == null) continue;
            int pathMinY = visRect.y;
            int pathMaxY = visRect.y + visRect.height;
            if (pathMinY >= maxY || pathMaxY <= minY) continue;
            Component comp = cr.getTreeCellRendererComponent(this, selPaths[i].getLastPathComponent(), false, false, false, 0, false);
            this.d_renderNodes.add(new RenderNode(this, comp, visRect));
        }
        return this.getDnDModel().preparePacket(paths);
    }

    public Rectangle getExpandedIconBounds(TreePath path) {
        BasicTreeUI ui = (BasicTreeUI)this.getUI();
        Rectangle pathBnds = this.getPathBounds(path);
        if (pathBnds == null) {
            ICON_BOUNDS.setBounds(0, 0, 0, 0);
            return ICON_BOUNDS;
        }
        int wid = ui.getExpandedIcon().getIconWidth() + 1;
        int ht = ui.getExpandedIcon().getIconHeight() + 1;
        int x = pathBnds.x - ui.getRightChildIndent() - wid / 2 + 1;
        int y = pathBnds.y + ht / 2 - 2;
        ICON_BOUNDS.setBounds(x, y, wid, ht);
        return ICON_BOUNDS;
    }

    private int getCursorPos(TreePath anchorPath, Point pt) {
        Rectangle nodeRect = this.getPathBounds(anchorPath);
        if (this.getExpandedIconBounds(anchorPath).contains(pt)) {
            return 0;
        }
        if (nodeRect.y + nodeRect.height / 3 > pt.y) {
            return 1;
        }
        if (nodeRect.y + 2 * (nodeRect.height / 3) < pt.y) {
            return 3;
        }
        return 2;
    }

    public TreePath getExtendedPathForLocation(int mx, int my) {
        TreePath closestPath = this.getClosestPathForLocation(mx, my);
        Rectangle labelBounds = this.getPathBounds(closestPath);
        if (labelBounds.contains(mx, my)) {
            return closestPath;
        }
        if (this.getModel().isLeaf(closestPath.getLastPathComponent())) {
            return null;
        }
        Rectangle expansionBounds = this.getExpandedIconBounds(closestPath);
        if (expansionBounds.contains(mx, my)) {
            return closestPath;
        }
        return null;
    }

    public Pair<TreePath, Boolean> getExtendedPathForLocationEx(int mx, int my) {
        TreePath closestPath = this.getClosestPathForLocation(mx, my);
        Rectangle labelBounds = this.getPathBounds(closestPath);
        if (labelBounds.contains(mx, my)) {
            return new Pair<TreePath, Boolean>(closestPath, Boolean.FALSE);
        }
        if (this.getModel().isLeaf(closestPath.getLastPathComponent())) {
            return null;
        }
        Rectangle expansionBounds = this.getExpandedIconBounds(closestPath);
        if (expansionBounds.contains(mx, my)) {
            return new Pair<TreePath, Boolean>(closestPath, Boolean.TRUE);
        }
        return null;
    }

    public boolean isOverExpansionIcon(TreePath path, int mx, int my) {
        Rectangle expansionBounds = this.getExpandedIconBounds(path);
        return expansionBounds.contains(mx, my);
    }

    protected boolean isOwnParent(List selPaths, TreePath targetPath) {
        for (int i = 0; i < selPaths.size(); ++i) {
            if (!((TreePath)selPaths.get(i)).isDescendant(targetPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        TreeSelectionModel selModel = this.getSelectionModel();
        TreePath[] selPaths = selModel.getSelectionPaths();
        if (selPaths == null || selPaths.length == 0) {
            return;
        }
        this.d_mouseDown.setLocation(dge.getDragOrigin());
        this.d_mouseCurrent.setLocation(dge.getDragOrigin());
        TreePath hitPath = this.getPathForLocation(this.d_mouseDown.x, this.d_mouseDown.y);
        if (hitPath == null || !this.getSelectionModel().isPathSelected(hitPath)) {
            return;
        }
        Object[] objs = new Object[selPaths.length];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = selPaths[i].getLastPathComponent();
        }
        Cursor csr = this.selectCursor(dge.getDragAction());
        TransferAdapter xfer = new TransferAdapter(this, objs);
        this.d_dragSource.startDrag(dge, csr, xfer, this);
        this.d_dragPacket = this.prepareDragPacket();
        this.getDnDModel().setDragging(true);
        this.getSelectionModel().clearSelection();
    }

    private Cursor selectCursor(int action) {
        switch (action) {
            case 2: {
                return DragSource.DefaultMoveDrop;
            }
        }
        return Cursor.getDefaultCursor();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.d_mouseCurrent.setLocation(dtde.getLocation());
        TreePath currentPath = this.getClosestPathForLocation(this.d_mouseCurrent.x, this.d_mouseCurrent.y);
        if (this.d_lastPath == null || currentPath.getLastPathComponent() != this.d_lastPath.getLastPathComponent()) {
            this.d_lastPath = currentPath;
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (!this.getDnDModel().canDrop(this.d_dragPacket, this.d_dropTarget)) {
            return;
        }
        this.d_hover.stop();
        if (this.d_dropIndex >= 0) {
            this.getDnDModel().drop(this.d_dragPacket, this.d_dropTarget, this.d_dropIndex);
        } else {
            this.getDnDModel().drop(this.d_dragPacket, this.d_dropTarget);
        }
        this.d_dropped = true;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        Object obj = this.d_lastPath.getLastPathComponent();
        Object parent = this.d_lastPath.getPath()[this.d_lastPath.getPathCount() - 2];
        DragSourceContext ctx = dsde.getDragSourceContext();
        if (this.getModel().isLeaf(obj) && !this.getDnDModel().isLeafDroppable(obj)) {
            this.dragOverLeaf(ctx, parent, obj, this.d_mouseCurrent.x, this.d_mouseCurrent.y);
        } else {
            this.dragOverNonLeaf(ctx, parent, obj, this.d_mouseCurrent.x, this.d_mouseCurrent.y);
        }
        this.autoscroll(this.d_mouseCurrent);
        this.repaint();
    }

    private void dragOverLeaf(DragSourceContext ctx, Object parent, Object target, int x, int y) {
        boolean isBelow;
        boolean canDrop = this.getDnDModel().canDrop(this.d_dragPacket, parent);
        Rectangle targetBounds = this.getPathBounds(this.d_lastPath);
        boolean bl = isBelow = this.d_mouseCurrent.y > targetBounds.y + targetBounds.height / 2;
        if (canDrop) {
            this.d_dropTarget = parent;
            this.d_dropIndex = this.getModel().getIndexOfChild(parent, target);
            if (isBelow) {
                ++this.d_dropIndex;
            }
            this.getSelectionModel().setSelectionPath(this.d_lastPath.getParentPath());
            ctx.setCursor(DragSource.DefaultMoveDrop);
        } else {
            this.d_dropTarget = null;
            this.d_dropIndex = -1;
            this.getSelectionModel().clearSelection();
            ctx.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    private void dragOverNonLeaf(DragSourceContext ctx, Object parent, Object target, int x, int y) {
        TreePath selectPath;
        block17: {
            int cPos;
            block16: {
                cPos = this.getCursorPos(this.d_lastPath, this.d_mouseCurrent);
                if (!this.isExpanded(this.d_lastPath)) break block16;
                switch (cPos) {
                    case 0: {
                        this.d_dropTarget = target;
                        this.d_dropIndex = -1;
                        selectPath = this.d_lastPath;
                        if (this.d_hover.isRunning()) break block17;
                        this.d_hover.restart();
                        break block17;
                    }
                    case 1: {
                        this.d_dropTarget = parent;
                        this.d_dropIndex = this.getModel().getIndexOfChild(parent, target);
                        selectPath = this.d_lastPath.getParentPath();
                        this.d_hover.stop();
                        break block17;
                    }
                    case 2: {
                        this.d_dropTarget = target;
                        this.d_dropIndex = -1;
                        selectPath = this.d_lastPath;
                        this.d_hover.stop();
                        break block17;
                    }
                    case 3: {
                        this.d_dropTarget = target;
                        this.d_dropIndex = 0;
                        selectPath = this.d_lastPath;
                        this.d_hover.stop();
                        break block17;
                    }
                    default: {
                        selectPath = null;
                        assert (false);
                        break block17;
                    }
                }
            }
            switch (cPos) {
                case 0: {
                    this.d_dropTarget = target;
                    this.d_dropIndex = -1;
                    selectPath = this.d_lastPath;
                    if (this.d_hover.isRunning()) break;
                    this.d_hover.restart();
                    break;
                }
                case 1: {
                    this.d_dropTarget = parent;
                    this.d_dropIndex = this.getModel().getIndexOfChild(parent, target);
                    selectPath = this.d_lastPath.getParentPath();
                    this.d_hover.stop();
                    break;
                }
                case 2: {
                    this.d_dropTarget = target;
                    this.d_dropIndex = -1;
                    selectPath = this.d_lastPath;
                    this.d_hover.stop();
                    break;
                }
                case 3: {
                    this.d_dropTarget = parent;
                    this.d_dropIndex = this.getModel().getIndexOfChild(parent, target) + 1;
                    selectPath = this.d_lastPath.getParentPath();
                    this.d_hover.stop();
                    break;
                }
                default: {
                    selectPath = null;
                    assert (false);
                    break;
                }
            }
        }
        if (this.getDnDModel().canDrop(this.d_dragPacket, this.d_dropTarget)) {
            this.getSelectionModel().setSelectionPath(selectPath);
            ctx.setCursor(DragSource.DefaultMoveDrop);
        } else {
            this.getSelectionModel().clearSelection();
            this.d_dropTarget = null;
            this.d_dropIndex = -1;
            ctx.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        DragSourceContext ctx = dse.getDragSourceContext();
        ctx.setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        ArrayList<TreePath> selPaths;
        IDnDTreeModel.IDragPacket packet = this.d_dragPacket;
        Object dropTarget = this.d_dropTarget;
        TreePath lastPath = this.d_lastPath;
        boolean committed = this.d_dropped;
        this.d_dropTarget = null;
        this.d_dropIndex = -1;
        this.d_renderNodes.clear();
        this.d_dragPacket = null;
        this.d_dropIndex = -1;
        this.d_dropTarget = null;
        this.d_dropped = false;
        this.getSelectionModel().clearSelection();
        this.getDnDModel().setDragging(false);
        if (!committed) {
            selPaths = packet.getSelectedPaths();
        } else if (lastPath != null) {
            Object comp;
            ArrayDeque<Object> nodes = new ArrayDeque<Object>();
            for (int m = 0; m < lastPath.getPathCount() && (comp = lastPath.getPathComponent(m)) != dropTarget; ++m) {
                nodes.addLast(comp);
            }
            nodes.addLast(dropTarget);
            ArrayList<TreePath> newPaths = new ArrayList<TreePath>(packet.getSelectedPaths().size());
            for (TreePath treePath : packet.getSelectedPaths()) {
                Object o = treePath.getLastPathComponent();
                nodes.addLast(o);
                newPaths.add(new TreePath(nodes.toArray(new Object[nodes.size()])));
                nodes.removeLast();
            }
            selPaths = newPaths;
        } else {
            selPaths = Collections.EMPTY_LIST;
        }
        this.getSelectionModel().setSelectionPaths(selPaths.toArray(new TreePath[selPaths.size()]));
        this.repaint();
    }

    private void autoscroll(Point pt) {
        boolean atTop;
        int row = this.getClosestRowForLocation(pt.x, pt.y);
        if (row < 0 || row == 0 || row >= this.getRowCount()) {
            return;
        }
        boolean bl = atTop = pt.y + this.getBounds().y <= 12;
        if (atTop) {
            this.scrollRowToVisible(row - 1);
        } else {
            this.scrollRowToVisible(row + 1);
        }
    }

    private class PathSorter
    implements Comparator<TreePath> {
        private PathSorter() {
        }

        @Override
        public int compare(TreePath p1, TreePath p2) {
            int p1Row = AbstractDnDTree.this.getRowForPath(p1);
            int p2Row = AbstractDnDTree.this.getRowForPath(p2);
            return p1Row - p2Row;
        }
    }

    private class HoverTimer
    extends Timer {
        private static final long serialVersionUID = 8772719953158351347L;

        public HoverTimer() {
            super(1000, new HoverTimerListener());
            this.setRepeats(false);
        }

        @Override
        public void restart() {
            if (AbstractDnDTree.this.d_canHover) {
                super.restart();
                AbstractDnDTree.this.d_hoverFeedback = true;
                AbstractDnDTree.this.d_canHover = false;
            }
        }

        @Override
        public void stop() {
            super.stop();
            AbstractDnDTree.this.d_hoverFeedback = false;
            AbstractDnDTree.this.d_canHover = true;
        }
    }

    private class MultiSelectHack
    extends MouseAdapter {
        public MultiSelectHack(JTree tree) {
            int i;
            MouseListener[] listeners = tree.getMouseListeners();
            for (i = 0; i < listeners.length; ++i) {
                tree.removeMouseListener(listeners[i]);
            }
            tree.addMouseListener(this);
            for (i = 0; i < listeners.length; ++i) {
                tree.addMouseListener(listeners[i]);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                if (e.isControlDown()) {
                    return;
                }
                TreePath[] selectedPaths = ((JTree)e.getSource()).getSelectionPaths();
                if (selectedPaths == null || selectedPaths.length == 0) {
                    return;
                }
                TreePath clickedPath = AbstractDnDTree.this.getPathForLocation(e.getX(), e.getY());
                if (clickedPath == null) {
                    return;
                }
                boolean isClickedPathSelected = false;
                for (int i = 0; i < selectedPaths.length && !isClickedPathSelected; ++i) {
                    isClickedPathSelected = selectedPaths[i].equals(clickedPath);
                }
                if (isClickedPathSelected) {
                    e.consume();
                }
            }
        }
    }

    private class RenderNode {
        public final Image nodeImg;
        public final Rectangle bounds;

        public RenderNode(AbstractDnDTree abstractDnDTree, Component stamp, Rectangle bounds) {
            int wid = stamp.getPreferredSize().width;
            int ht = stamp.getPreferredSize().height;
            this.nodeImg = new BufferedImage(wid, ht, 2);
            Graphics g = this.nodeImg.getGraphics();
            SwingUtilities.paintComponent(g, stamp, CONTAINER, 0, 0, wid, ht);
            stamp.paint(g);
            g.dispose();
            this.bounds = bounds;
        }
    }

    private class TransferAdapter
    implements Transferable {
        private final Object d_obj;

        public TransferAdapter(AbstractDnDTree abstractDnDTree, Object obj) {
            this.d_obj = obj;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(FLAVOR_OBJ_ARR);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.d_obj;
        }
    }

    private class HoverTimerListener
    implements ActionListener {
        private HoverTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractDnDTree.this.isExpanded(AbstractDnDTree.this.d_lastPath)) {
                AbstractDnDTree.this.collapsePath(AbstractDnDTree.this.d_lastPath);
            } else {
                AbstractDnDTree.this.expandPath(AbstractDnDTree.this.d_lastPath);
            }
        }
    }
}

