/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AreaUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ShapeUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Spline2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.APrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import thunderheadeng.geometry.objs.ShapeGeom;

public class ShapeGeom
implements IGeom {
    static final long serialVersionUID = 1L;
    public final transient Shape shape;
    public final Matrix4d lwXform;
    private transient SoftReference<Matrix4d> d_wlXform;

    public ShapeGeom(Shape shape, Matrix4d lwXform) {
        this.shape = shape;
        this.lwXform = lwXform;
    }

    public ShapeGeom(Shape shape, Plane3d plane) {
        this(shape, Util.getLocalToWorldXform(plane));
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 dict) {
        return new thunderheadeng.geometry.objs.ShapeGeom(this.shape, this.lwXform);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ShapeUtil.writeShape(out, this.shape);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Shape shape = ShapeUtil.readShape(in);
        try {
            theUtil.assignFinalField(this, "shape", shape);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static Matrix4d invert(Matrix4d xform) {
        Matrix4d invert = new Matrix4d(xform);
        invert.invert();
        return invert;
    }

    public Matrix4d getWLXform() {
        Matrix4d wlxform;
        Matrix4d matrix4d = wlxform = this.d_wlXform != null ? this.d_wlXform.get() : null;
        if (wlxform == null) {
            wlxform = ShapeGeom.invert(this.lwXform);
            this.d_wlXform = new SoftReference<Matrix4d>(wlxform);
        }
        return wlxform;
    }

    @Override
    public boolean isAxisAlignedBlock(Matrix4d parentXform) {
        return false;
    }

    @Override
    public boolean isShell() {
        return true;
    }

    @Override
    public IGeom optimize(IPointOptimizer pool) {
        return this;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        AABox box = ShapeUtil.getBounds(this.shape, this.lwXform);
        aabb.add(box);
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IGeom transform(Matrix4d xform, IGeom.XformOp op) {
        Matrix4d newXform = new Matrix4d(xform);
        newXform.mul(this.lwXform);
        return new ShapeGeom(this.shape, newXform);
    }

    @Override
    public int getNumPrims(int types) {
        if (this.shape instanceof Area) {
            return (types & 1) != 0 ? 1 : 0;
        }
        if ((types & 2) != 0) {
            int numCurves = 0;
            int currNumSegments = 0;
            double[] coords = new double[6];
            PathIterator it = this.shape.getPathIterator(null);
            while (!it.isDone()) {
                int command = it.currentSegment(coords);
                switch (command) {
                    case 0: {
                        if (currNumSegments > 0) {
                            ++numCurves;
                        }
                        currNumSegments = 0;
                        break;
                    }
                    default: {
                        ++currNumSegments;
                    }
                }
                it.next();
            }
            if (currNumSegments > 0) {
                ++numCurves;
            }
            return numCurves;
        }
        return 0;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> prims) {
        if (this.shape instanceof Area) {
            prims.add(new AreaFace((Area)this.shape, this.lwXform, this.getWLXform()));
        } else {
            ShapeGeom.getCurves(prims, this.shape, this.lwXform, this.getWLXform());
        }
        return prims;
    }

    private static void getCurves(Collection<? super ICurve> curves, Shape shape, Matrix4d lwXform, Matrix4d wlXform) {
        int currNumSegments = 0;
        double[] coords = new double[6];
        Path2D.Double currCurve = new Path2D.Double();
        PathIterator it = shape.getPathIterator(null);
        while (!it.isDone()) {
            int command = it.currentSegment(coords);
            if (command == 0) {
                if (currNumSegments > 0) {
                    curves.add(new ShapeCurve(currCurve, lwXform, wlXform));
                    currCurve = new Path2D.Double();
                }
                currNumSegments = 0;
            } else {
                ++currNumSegments;
            }
            switch (command) {
                case 0: {
                    ((Path2D)currCurve).moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    ((Path2D)currCurve).lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    ((Path2D)currCurve).quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    ((Path2D)currCurve).curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    currCurve.closePath();
                }
            }
            it.next();
        }
        if (currNumSegments > 0) {
            curves.add(new ShapeCurve(currCurve, lwXform, wlXform));
        }
    }

    private static Point3d xform(Matrix4d lwXform, Point2d p) {
        Point3d p3d = new Point3d(p.x, p.y, 0.0);
        lwXform.transform(p3d);
        return p3d;
    }

    @Override
    public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        Collection<IGeom> pieces = this.explode(new ArrayList<IGeom>());
        for (IGeom geom : pieces) {
            if (!geom.intersectsBox(source, filter, region)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
        Collection<IGeom> pieces = this.explode(new ArrayList<IGeom>());
        for (IGeom geom : pieces) {
            geom.find(test, result);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> result) {
        Collection<IGeom> pieces = this.explode(new ArrayList<IGeom>());
        for (IGeom geom : pieces) {
            geom.getAll(result);
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        Collection<IGeom> pieces = this.explode(new ArrayList<IGeom>());
        for (IGeom geom : pieces) {
            geom.pickPoints(isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
        }
    }

    private static void pickPoints(IPrimitive primSrc, IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester, Shape shape, Matrix4d lwXform, Matrix4d wlXform) {
        boolean faces;
        GeomType fType;
        GeomType eType;
        GeomType vType;
        if (shape instanceof Area) {
            vType = GeomType.FACE_VERTEX;
            eType = GeomType.FACE_EDGE;
            fType = GeomType.FACE;
        } else {
            vType = GeomType.VERTEX;
            eType = GeomType.EDGE;
            fType = null;
        }
        boolean verts = filter.acceptGeomType(source, vType);
        boolean edges = filter.acceptGeomType(source, eType);
        boolean bl = faces = fType != null && filter.acceptGeomType(source, fType);
        if (!(verts || edges || faces)) {
            return;
        }
        if (edges || faces) {
            rayBegin = Util3D.xform(wlXform, rayBegin);
            rayEnd = Util3D.xform(wlXform, rayEnd);
            rayDirN = Util3D.xform(wlXform, rayDirN);
            rayDirN.normalize();
        }
        if (verts) {
            ShapeGeom.getVerts(primSrc, isects, source, vType, shape, lwXform);
        }
        if (edges) {
            ShapeGeom.getClosestToEdges(primSrc, isects, source, rayBegin, rayEnd, rayDirN, eType, shape, lwXform);
        }
        if (faces) {
            ShapeGeom.getFaceIsect(primSrc, isects, source, rayBegin, rayEnd, rayDirN, shape, lwXform);
        }
    }

    private static void getVerts(IPrimitive primSrc, IIsectCollector isects, Object source, GeomType vType, Shape shape, Matrix4d lwXform) {
        PathIterator path = shape.getPathIterator(null);
        double[] coords = new double[6];
        while (!path.isDone()) {
            int type = path.currentSegment(coords);
            switch (type) {
                case 0: 
                case 1: {
                    isects.add(source, ShapeUtil.extract3d(lwXform, coords, 0), vType, primSrc);
                }
            }
            path.next();
        }
    }

    private static void getClosestToEdges(IPrimitive primSrc, IIsectCollector isects, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, GeomType eType, Shape shape, Matrix4d lwXform) {
        Point3d zIsect = new Point3d();
        if (!Inter3D.lineZPlaneIntersection(zIsect, rayBegin, rayDirN, 0.0, 1.0E-9)) {
            return;
        }
        Point2d point = new Point2d(zIsect.x, zIsect.y);
        double[] coords = new double[6];
        Point2d firstPoint = null;
        Tuple2d lastPoint = null;
        PathIterator path = shape.getPathIterator(null);
        while (!path.isDone()) {
            int type = path.currentSegment(coords);
            switch (type) {
                case 0: {
                    firstPoint = ShapeUtil.extract2d(coords, 0);
                    lastPoint = firstPoint;
                    break;
                }
                case 1: {
                    Point2d currPoint = ShapeUtil.extract2d(coords, 0);
                    Point2d closest = Inter2D.nearestToLineSeg(point, (Point2d)lastPoint, currPoint);
                    isects.add(source, ShapeUtil.xform(lwXform, closest.x, closest.y), eType, primSrc);
                    lastPoint = currPoint;
                    break;
                }
                case 2: {
                    Point2d p1 = ShapeUtil.extract2d(coords, 0);
                    Point2d p2 = ShapeUtil.extract2d(coords, 2);
                    Point2d closest = ShapeGeom.nearestToQuadraticSpline(point, (Point2d)lastPoint, p1, p2);
                    isects.add(source, ShapeUtil.xform(lwXform, closest.x, closest.y), eType, primSrc);
                    lastPoint = p2;
                    break;
                }
                case 3: {
                    Point2d p1 = ShapeUtil.extract2d(coords, 0);
                    Point2d p2 = ShapeUtil.extract2d(coords, 2);
                    Point2d p3 = ShapeUtil.extract2d(coords, 4);
                    Point2d closest = ShapeGeom.nearestToCubicSpline(point, (Point2d)lastPoint, p1, p2, p3);
                    isects.add(source, ShapeUtil.xform(lwXform, closest.x, closest.y), eType, primSrc);
                    lastPoint = p3;
                    break;
                }
                case 4: {
                    if (lastPoint.equals(firstPoint)) break;
                    Point2d closest = Inter2D.nearestToLineSeg(point, (Point2d)lastPoint, firstPoint);
                    isects.add(source, ShapeUtil.xform(lwXform, closest.x, closest.y), eType, primSrc);
                }
            }
            path.next();
        }
    }

    private static Point2d nearestToQuadraticSpline(Point2d tp, Point2d cp, Point2d p1, Point2d p2) {
        Spline2D.Quadratic spline = new Spline2D.Quadratic(cp, p1, p2);
        double t = spline.getClosestT(tp);
        return spline.get(t);
    }

    private static Point2d nearestToCubicSpline(Point2d tp, Point2d cp, Point2d p1, Point2d p2, Point2d p3) {
        Spline2D.Cubic spline = new Spline2D.Cubic(cp, p1, p2, p3);
        double t = spline.getClosestT(tp);
        return spline.get(t);
    }

    private static void getFaceIsect(IPrimitive primSrc, IIsectCollector isects, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, Shape shape, Matrix4d lwXform) {
        Point3d zIsect = new Point3d();
        if (Inter3D.lineZPlaneIntersection(zIsect, rayBegin, rayDirN, 0.0, 1.0E-9) && shape.contains(new Point2D.Double(zIsect.x, zIsect.y))) {
            isects.add(source, ShapeUtil.xform(lwXform, zIsect.x, zIsect.y), GeomType.FACE, primSrc);
        }
    }

    public static class AreaFace
    extends ShapePrimitive<Area>
    implements IFace {
        private static final long serialVersionUID = -6452755988716387307L;

        public AreaFace(Area area, Matrix4d lwXform, Matrix4d wlXform) {
            super(area, lwXform, wlXform);
        }

        @Override
        public Object fromLegacy(LegacyDictionary_2012_1 dict) {
            return new ShapeGeom.AreaFace((Area)this.shape, this.lwXform, this.wlXform, false);
        }

        @Override
        public IFace optimize(IPointOptimizer pool) {
            return this;
        }

        @Override
        protected int getPrimType() {
            return 1;
        }

        @Override
        public Point3d project(Point3d p) {
            return Util.getPlane(this.lwXform).projectOntoPlane(p);
        }

        @Override
        public IFace.PointClassify classify(Point3d p, double tol) {
            Matrix4d wl = this.wlXform;
            p = Util3D.xform(wl, p);
            return ((Area)this.shape).contains(p.x, p.y) ? IFace.PointClassify.INSIDE : IFace.PointClassify.OUTSIDE;
        }

        @Override
        public void getBoundary(List<ICurve> boundary) {
            ShapeGeom.getCurves(boundary, this.shape, this.lwXform, this.wlXform);
        }

        @Override
        public IFace transform(Matrix4d xform) {
            Matrix4d newXform = new Matrix4d(xform);
            newXform.mul(this.lwXform);
            return new AreaFace((Area)this.shape, newXform, ShapeGeom.invert(newXform));
        }

        @Override
        public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
            if (filter.acceptGeomType(source, GeomType.FACE) || filter.acceptGeomType(source, GeomType.FACE_EDGE) || filter.acceptGeomType(source, GeomType.FACE_VERTEX)) {
                IPolygon poly = AreaUtil.toPoly((Area)this.shape, this.lwXform, 0.001);
                return poly.intersectsBox(source, filter, region);
            }
            return false;
        }

        @Override
        public Mesh triangulate(double errorTol) {
            IPolygon poly = AreaUtil.toPoly((Area)this.shape, this.lwXform, errorTol);
            return poly.triangulate(errorTol);
        }
    }

    public static class ShapeCurve
    extends ShapePrimitive<Shape>
    implements ICurve {
        private static final long serialVersionUID = -7757414011108848813L;

        public ShapeCurve(Shape shape, Matrix4d lwXform, Matrix4d wlXform) {
            super(shape, lwXform, wlXform);
        }

        @Override
        public Object fromLegacy(LegacyDictionary_2012_1 dict) {
            return new ShapeGeom.ShapeCurve(this.shape, this.lwXform, this.wlXform);
        }

        @Override
        protected int getPrimType() {
            return 2;
        }

        @Override
        public ICurve optimize(IPointOptimizer pool) {
            return this;
        }

        @Override
        public Point3d project(Point3d p, double tol) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICurve transform(Matrix4d xform) {
            Matrix4d newXform = new Matrix4d(xform);
            newXform.mul(this.lwXform);
            return new ShapeCurve(this.shape, newXform, ShapeGeom.invert(newXform));
        }

        @Override
        public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
            if (filter.acceptGeomType(source, GeomType.EDGE) || filter.acceptGeomType(source, GeomType.VERTEX)) {
                return this.getSegments(0.001).intersectsBox(source, filter, region);
            }
            return false;
        }

        @Override
        public Mesh getSegments(double errorTol) {
            double[] coords = new double[6];
            Point3d firstPoint = null;
            ArrayList<Point3d> points = new ArrayList<Point3d>();
            PathIterator path = ShapeUtil.getPathIterator(this.shape, null, errorTol);
            while (!path.isDone()) {
                int type = path.currentSegment(coords);
                switch (type) {
                    case 0: {
                        assert (points.isEmpty());
                        firstPoint = ShapeUtil.extract3d(this.lwXform, coords, 0);
                        points.add(firstPoint);
                        break;
                    }
                    case 4: {
                        points.add(firstPoint);
                        break;
                    }
                    case 1: {
                        points.add(ShapeUtil.extract3d(this.lwXform, coords, 0));
                    }
                }
                path.next();
            }
            Point3d[] verts = points.toArray(new Point3d[points.size()]);
            int numSegs = verts.length - 1;
            int[] ixes = new int[numSegs * 2];
            int ixix = 0;
            for (int m = 0; m < numSegs; ++m) {
                ixes[ixix++] = m;
                ixes[ixix++] = m + 1;
            }
            return new Mesh(verts, ixes, 1);
        }
    }

    private static abstract class ShapePrimitive<T extends Shape>
    extends APrimitive {
        private static final long serialVersionUID = 8072615106973088279L;
        public final T shape;
        public final Matrix4d lwXform;
        public final Matrix4d wlXform;

        public ShapePrimitive(T shape, Matrix4d lwXform, Matrix4d wlXform) {
            this.shape = shape;
            this.lwXform = lwXform;
            this.wlXform = wlXform;
        }

        @Override
        public AABox getBoundingBox(AABox aabb) {
            AABox box = ShapeUtil.getBounds(this.shape, this.lwXform);
            aabb.add(box);
            return aabb;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.FREE;
        }

        @Override
        public IGeom transform(Matrix4d xform, IGeom.XformOp op) {
            return this.transform(xform);
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
            ShapeGeom.pickPoints(this, isects, filter, source, rayBegin, rayEnd, rayDirN, tester, this.shape, this.lwXform, this.wlXform);
        }
    }
}

