/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ACurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ILinearCurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NullOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;

public class PolyLine
extends ACurve
implements ILinearCurve,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final Point3d[] verts;

    public PolyLine(Point3d ... verts) {
        this.verts = verts;
        assert (verts.length > 1);
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 dict) {
        return new thunderheadeng.geometry.objs.PolyLine(this.verts);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.verts);
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public int getNumVerts() {
        return this.verts.length;
    }

    @Override
    public Point3d getVert(int ix) {
        return this.verts[ix];
    }

    @Override
    public boolean isAxisAlignedBlock(Matrix4d parentXform) {
        return false;
    }

    @Override
    public boolean isShell() {
        return true;
    }

    @Override
    public ICurve optimize(IPointOptimizer pool) {
        if (pool instanceof NullOptimizer) {
            return this;
        }
        boolean modified = false;
        Point3d[] newVerts = new Point3d[this.verts.length];
        for (int m = 0; m < this.verts.length; ++m) {
            Point3d ov = this.verts[m];
            Point3d nv = pool.getExisting(ov);
            modified |= nv != ov;
            newVerts[m] = nv;
        }
        return modified ? new PolyLine(newVerts) : this;
    }

    public IGeom transform(Matrix4d xform, boolean quick) {
        return this.transform(xform);
    }

    @Override
    public ICurve transform(Matrix4d xform) {
        return new PolyLine(GeomUtil.xformVerts(this.verts, xform));
    }

    @Override
    public Mesh getSegments(double errorTol) {
        int[] indices = new int[(this.verts.length - 1) * 2];
        int indexix = 0;
        int m = 0;
        while (m < this.verts.length - 1) {
            indices[indexix++] = m++;
            indices[indexix++] = m;
        }
        return new Mesh(this.verts, indices, 1);
    }

    @Override
    public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        block3: {
            block2: {
                if (!filter.acceptGeomType(source, GeomType.EDGE)) break block2;
                for (int m = 0; m < this.verts.length - 1; ++m) {
                    Point3d p1 = this.verts[m];
                    Point3d p2 = this.verts[m + 1];
                    if (!region.intersectsLineSeg(p1, p2, 1.0E-6)) continue;
                    return true;
                }
                break block3;
            }
            if (!filter.acceptGeomType(source, GeomType.VERTEX)) break block3;
            for (Point3d p : this.verts) {
                if (!region.contains(p, 1.0E-6)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (filter.acceptGeomType(source, GeomType.VERTEX)) {
            for (Point3d p : this.verts) {
                isects.add(source, p, GeomType.VERTEX, this);
            }
        }
        if (filter.acceptGeomType(source, GeomType.EDGE)) {
            for (int m = 0; m < this.verts.length - 1; ++m) {
                Point3d p1 = this.verts[m];
                Point3d p2 = this.verts[m + 1];
                double[] isect = Inter3D.lineSegLineSegProximityT(rayBegin, rayEnd, p1, p2, 1.0E-6);
                if (isect == null || isect[1] == 1.0 && m < this.verts.length - 2) continue;
                isects.add(source, Util3D.linesegPoint(p1, p2, isect[1]), GeomType.EDGE, this);
            }
        }
    }

    @Override
    public Point3d project(Point3d p, double tol) {
        Point3d nearestp = null;
        double nearestDistSq = Double.MAX_VALUE;
        for (int m = 0; m < this.verts.length - 1; ++m) {
            Point3d p1 = this.verts[m];
            Point3d p2 = this.verts[m + 1];
            Point3d nearp = Inter3D.nearestPointOnLineSeg(p1, p2, p);
            double distsq = p.distanceSquared(nearp);
            if (!(distsq < nearestDistSq)) continue;
            nearestDistSq = distsq;
            nearestp = nearp;
        }
        return nearestp;
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>(this.verts.length);
        for (int m = 0; m < this.verts.length; ++m) {
            handles.add(new Handle(this, m));
        }
        return handles;
    }

    private static class Handle
    implements IHandle {
        private PolyLine d_geom;
        private final int d_ix;
        private Point3d[] t_verts;

        public Handle(PolyLine geom, int ix) {
            this.d_geom = geom;
            this.d_ix = ix;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle && ((Handle)obj).d_ix == this.d_ix;
        }

        @Override
        public IGeom getGeom() {
            return new Point(this.d_geom.verts[this.d_ix]);
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.t_verts = Arrays.copyOf(this.d_geom.verts, this.d_geom.verts.length);
        }

        @Override
        public Object modify(Point3d newLoc) throws Exception {
            this.t_verts[this.d_ix] = newLoc;
            this.d_geom = new PolyLine(this.t_verts);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.t_verts = null;
            return this.d_geom;
        }
    }
}

