/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.APrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;

public class Point
extends APrimitive
implements IPrimitive,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final Point3d loc;

    public Point(Point3d location) {
        this.loc = location;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 dict) {
        return new thunderheadeng.geometry.objs.Point(this.loc);
    }

    @Override
    public Point optimize(IPointOptimizer pool) {
        Point3d nloc = pool.getExisting(this.loc);
        return nloc != this.loc ? new Point(nloc) : this;
    }

    public int hashCode() {
        return 65087 + this.loc.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Point && ((Point)o).loc.equals(this.loc);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.loc);
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public Point transform(Matrix4d xform) {
        return new Point(Util3D.xform(xform, this.loc));
    }

    @Override
    protected int getPrimType() {
        return 4;
    }

    @Override
    public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        if (filter.acceptGeomType(source, GeomType.VERTEX)) {
            return region.contains(this.loc, 1.0E-6);
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (filter.acceptGeomType(source, GeomType.VERTEX)) {
            isects.add(source, this.loc, GeomType.VERTEX, this);
        }
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new Handle(this));
    }

    private static class Handle
    implements IHandle {
        private Point geom;

        public Handle(Point geom) {
            this.geom = geom;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle;
        }

        @Override
        public IGeom getGeom() {
            return this.geom;
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public Object modify(Point3d newLoc) throws Exception {
            this.geom = new Point(newLoc);
            return this.geom;
        }

        @Override
        public Object end() {
            return this.geom;
        }
    }
}

