/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NullOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Mesh
implements IGeom,
IManipulatable {
    static final long serialVersionUID = 1L;
    public static final byte PT_POINTS = 0;
    public static final byte PT_LINESEGS = 1;
    public static final byte PT_TRIANGLES = 2;
    public static final byte PT_QUADS = 3;
    public static final int FLAG_SMOOTHNORMALS = 2;
    public static final int FLAG_SOLID = 4;
    public final byte primtype;
    public final Point3d[] vertices;
    public final int[] indices;
    public final int flags;

    public Mesh(Point3d[] vertices, int[] indices, byte primType) {
        this(vertices, indices, primType, 0);
    }

    public Mesh(Point3d[] vertices, int[] indices, byte primType, int flags) {
        assert (indices.length % Mesh.getNumVertsPerElement(primType) == 0);
        this.vertices = vertices;
        this.indices = indices;
        this.flags = flags;
        this.primtype = primType;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 dict) {
        return new thunderheadeng.geometry.objs.Mesh(this.vertices, this.indices, this.primtype, this.flags);
    }

    @Override
    public IGeom optimize(IPointOptimizer pool) {
        int numPrims = this.getNumPrims(7);
        if (numPrims == 1) {
            return this.getPrimitive(0).optimize(pool);
        }
        if (pool instanceof NullOptimizer) {
            return this;
        }
        boolean changed = false;
        Point3d[] npoints = new Point3d[this.vertices.length];
        for (int m = 0; m < this.vertices.length; ++m) {
            npoints[m] = pool.getExisting(this.vertices[m]);
            changed |= npoints[m] != this.vertices[m];
        }
        return changed ? new Mesh(npoints, this.indices, this.primtype, this.flags) : this;
    }

    public Mesh toSolid() {
        if (this.testFlag(4)) {
            return this;
        }
        return new Mesh(this.vertices, this.indices, this.primtype, this.flags | 4);
    }

    public Mesh toShell() {
        if (!this.testFlag(4)) {
            return this;
        }
        return new Mesh(this.vertices, this.indices, this.primtype, this.flags & 0xFFFFFFFB);
    }

    public boolean testFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    public int getNumVertsPerPrim() {
        switch (this.primtype) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return -1;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.vertices);
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IGeom transform(Matrix4d xform, IGeom.XformOp op) {
        return new Mesh(GeomUtil.xformVerts(this.vertices, xform), this.indices, this.primtype, this.flags);
    }

    @Override
    public boolean isAxisAlignedBlock(Matrix4d parentXform) {
        return false;
    }

    @Override
    public boolean isShell() {
        return !this.testFlag(4);
    }

    private static int getNumVertsPerElement(byte type) {
        switch (type) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public int getNumPrims(int types) {
        if ((types & 1) != 0 && (this.primtype == 2 || this.primtype == 3)) {
            return this.indices.length / Mesh.getNumVertsPerElement(this.primtype);
        }
        if ((types & 2) != 0 && this.primtype == 1) {
            return this.indices.length / 2;
        }
        if ((types & 4) != 0 && this.primtype == 0) {
            return this.indices.length;
        }
        return 0;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> prims) {
        Point3d[] verts = this.vertices;
        switch (this.primtype) {
            case 0: {
                int ix = 0;
                while (ix < this.indices.length) {
                    Point3d p1 = verts[this.indices[ix++]];
                    prims.add(new Point(p1));
                }
                break;
            }
            case 1: {
                int ix = 0;
                while (ix < this.indices.length) {
                    Point3d p1 = verts[this.indices[ix++]];
                    Point3d p2 = verts[this.indices[ix++]];
                    prims.add(new LineSeg(p1, p2));
                }
                break;
            }
            case 2: {
                int ix = 0;
                while (ix < this.indices.length) {
                    Point3d p1 = verts[this.indices[ix++]];
                    Point3d p2 = verts[this.indices[ix++]];
                    Point3d p3 = verts[this.indices[ix++]];
                    prims.add(new Triangle(p1, p2, p3));
                }
                break;
            }
            case 3: {
                int ix = 0;
                while (ix < this.indices.length) {
                    Point3d p1 = verts[this.indices[ix++]];
                    Point3d p2 = verts[this.indices[ix++]];
                    Point3d p3 = verts[this.indices[ix++]];
                    Point3d p4 = verts[this.indices[ix++]];
                    prims.add(new Quad(p1, p2, p3, p4));
                }
                break;
            }
        }
        return prims;
    }

    public boolean isValid() {
        for (int i : this.indices) {
            if (i < this.vertices.length && i >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isClosed() {
        return this.testClosed().v1 == ClosedTest.CLOSED;
    }

    public Pair<ClosedTest, Object> testClosed() {
        int elCount;
        if (this.primtype != 2 && this.primtype != 3) {
            return new Pair<ClosedTest, Object>(ClosedTest.WRONG_TYPE, null);
        }
        int n = elCount = this.primtype == 2 ? 3 : 4;
        if (this.indices.length == elCount) {
            return new Pair<ClosedTest, Object>(ClosedTest.ONE_FACE, null);
        }
        HashMap<EdgeHash, Integer> edgeCounts = new HashMap<EdgeHash, Integer>();
        for (int m = 0; m < this.indices.length; m += elCount) {
            for (int n2 = 0; n2 < elCount; ++n2) {
                int e1 = this.indices[m + n2];
                int e2 = this.indices[m + (n2 + 1) % elCount];
                EdgeHash edge = new EdgeHash(e1, e2);
                Integer count = (Integer)edgeCounts.get(edge);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                edgeCounts.put(edge, count);
            }
        }
        for (Map.Entry entry : edgeCounts.entrySet()) {
            int adjCount = (Integer)entry.getValue();
            if (adjCount > 1) continue;
            Point3d e1 = this.vertices[((EdgeHash)entry.getKey()).e1];
            Point3d e2 = this.vertices[((EdgeHash)entry.getKey()).e2];
            return new Pair<ClosedTest, Point3d[]>(ClosedTest.EDGE_OPEN, new Point3d[]{e1, e2});
        }
        return new Pair<ClosedTest, Object>(ClosedTest.CLOSED, null);
    }

    public static Mesh merge(Mesh ... meshes) {
        if (meshes.length == 0) {
            return new Mesh(new Point3d[0], new int[0], 0);
        }
        byte type = meshes[0].primtype;
        LinkedHashMap<Point3d, Integer> pmap = new LinkedHashMap<Point3d, Integer>();
        ArrayList<Integer> ixes = new ArrayList<Integer>();
        for (Mesh mesh : meshes) {
            assert (mesh.primtype == type);
            int[] vixes = new int[mesh.vertices.length];
            for (int m = 0; m < mesh.vertices.length; ++m) {
                Point3d p = mesh.vertices[m];
                Integer ix = (Integer)pmap.get(p);
                if (ix == null) {
                    ix = pmap.size();
                    pmap.put(p, ix);
                }
                vixes[m] = ix;
            }
            for (int ix : mesh.indices) {
                ixes.add(vixes[ix]);
            }
        }
        return new Mesh(pmap.keySet().toArray(new Point3d[pmap.size()]), theUtil.toIntArray(ixes), type);
    }

    @Override
    public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        switch (this.primtype) {
            case 0: {
                if (!filter.acceptGeomType(source, GeomType.VERTEX)) break;
                for (int m = 0; m < this.indices.length; ++m) {
                    if (!region.contains(this.vertices[this.indices[m]])) continue;
                    return true;
                }
                break;
            }
            case 1: {
                if (filter.acceptGeomType(source, GeomType.EDGE)) {
                    int m = 0;
                    while (m < this.indices.length) {
                        Point3d p2;
                        Point3d p1;
                        if (!region.intersectsLineSeg(p1 = this.vertices[this.indices[m++]], p2 = this.vertices[this.indices[m++]], 1.0E-6)) continue;
                        return true;
                    }
                } else {
                    if (!filter.acceptGeomType(source, GeomType.VERTEX)) break;
                    for (Point3d p : this.vertices) {
                        if (!region.contains(p, 1.0E-6)) continue;
                        return true;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                if (filter.acceptGeomType(source, GeomType.FACE)) {
                    Point3d[] meshFace = new Point3d[Mesh.getNumVertsPerElement(this.primtype)];
                    int m = 0;
                    while (m < this.indices.length) {
                        for (int n = 0; n < meshFace.length; ++n) {
                            meshFace[n] = this.vertices[this.indices[m++]];
                        }
                        if (!region.intersectsConvexPoly(1.0E-6, meshFace)) continue;
                        return true;
                    }
                } else if (filter.acceptGeomType(source, GeomType.FACE_EDGE)) {
                    int vertsPerPrim = Mesh.getNumVertsPerElement(this.primtype);
                    for (int m = 0; m < this.indices.length; m += vertsPerPrim) {
                        for (int n = 0; n < vertsPerPrim; ++n) {
                            Point3d p1 = this.vertices[this.indices[m + n]];
                            Point3d p2 = this.vertices[this.indices[m + (n + 1) % vertsPerPrim]];
                            if (!region.intersectsLineSeg(p1, p2, 1.0E-6)) continue;
                            return true;
                        }
                    }
                } else {
                    if (!filter.acceptGeomType(source, GeomType.FACE_VERTEX)) break;
                    for (Point3d p : this.vertices) {
                        if (!region.contains(p)) continue;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        GeomType vType = null;
        GeomType eType = null;
        GeomType fType = null;
        switch (this.primtype) {
            case 0: {
                vType = GeomType.VERTEX;
                break;
            }
            case 1: {
                vType = GeomType.VERTEX;
                eType = GeomType.EDGE;
                break;
            }
            case 2: 
            case 3: {
                vType = GeomType.FACE_VERTEX;
                eType = GeomType.FACE_EDGE;
                fType = GeomType.FACE;
            }
        }
        if (vType != null && filter.acceptGeomType(source, vType)) {
            this.pickVerts(isects, source, vType);
        }
        if (eType != null && filter.acceptGeomType(source, eType)) {
            this.pickEdges(isects, source, rayBegin, rayEnd, rayDirN, tester);
        }
        if (fType != null && filter.acceptGeomType(source, fType)) {
            this.pickFaces(isects, source, rayBegin, rayEnd, rayDirN, tester);
        }
    }

    private void pickVerts(IIsectCollector isects, Object source, GeomType vType) {
        for (Point3d p : this.vertices) {
            isects.add(source, p, vType, new Point(p));
        }
    }

    private void pickEdges(IIsectCollector isects, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        AABox testBounds = new AABox();
        if (this.primtype == 1) {
            int m = 0;
            while (m < this.indices.length) {
                Point3d p1 = this.vertices[this.indices[m++]];
                Point3d p2 = this.vertices[this.indices[m++]];
                testBounds.reset();
                testBounds.add(p1, p2);
                if (!tester.test((AABox)testBounds).positive) continue;
                double[] isect = Inter3D.lineSegLineSegProximityT(rayBegin, rayEnd, p1, p2, 1.0E-6);
                if (isect != null) {
                    isects.add(source, Util3D.linesegPoint(p1, p2, isect[1]), GeomType.EDGE, new LineSeg(p1, p2));
                    continue;
                }
                isects.getProgress().check();
            }
        } else {
            int vPerPrim = this.getNumVertsPerPrim();
            Point3d[] pverts = new Point3d[vPerPrim];
            for (int m = 0; m < this.indices.length; m += vPerPrim) {
                IPolygon fprim = null;
                for (int n = 0; n < vPerPrim; ++n) {
                    int i1 = this.indices[m + n];
                    int i2 = this.indices[m + (n + 1) % vPerPrim];
                    Point3d p1 = this.vertices[i1];
                    Point3d p2 = this.vertices[i2];
                    testBounds.reset();
                    testBounds.add(p1, p2);
                    if (!tester.test((AABox)testBounds).positive) continue;
                    double[] isect = Inter3D.lineSegLineSegProximityT(rayBegin, rayEnd, p1, p2, 1.0E-6);
                    if (isect != null) {
                        if (fprim == null) {
                            for (int o = 0; o < vPerPrim; ++o) {
                                pverts[o] = this.vertices[this.indices[o]];
                            }
                            fprim = PolyUtil.newPoly(pverts);
                        }
                        isects.add(source, Util3D.linesegPoint(p1, p2, isect[1]), GeomType.FACE_EDGE, fprim);
                        continue;
                    }
                    isects.getProgress().check();
                }
            }
        }
    }

    private void pickFaces(IIsectCollector isects, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        Plane3d plane = new Plane3d();
        int vPerPrim = this.getNumVertsPerPrim();
        Point3d[] parr = new Point3d[vPerPrim];
        for (int m = 0; m < this.indices.length; m += vPerPrim) {
            for (int n = 0; n < vPerPrim; ++n) {
                parr[n] = this.vertices[this.indices[m + n]];
            }
            plane.set(1.0E-6, parr);
            if (!plane.isValid()) continue;
            Point3d isect = Inter3D.lineSegPlaneIntersection(rayBegin, rayEnd, plane, 1.0E-6);
            if (isect != null && Inter3D.pointInPoly(1.0E-6, isect, parr)) {
                IPolygon face = PolyUtil.newPoly(parr);
                isects.add(source, isect, GeomType.FACE, face);
                continue;
            }
            isects.getProgress().check();
        }
    }

    @Override
    public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
        AABox testBox = new AABox();
        Collection<IGeom> prims = this.explode(new ArrayList<IGeom>(this.getNumPrims(7)));
        for (IGeom prim : prims) {
            testBox.reset();
            prim.getBoundingBox(testBox);
            Containment ctmt = test.test(testBox);
            if (!ctmt.positive) continue;
            result.mark((IPrimitive)prim, ctmt);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> result) {
        Collection<IGeom> prims = this.explode(new ArrayList<IGeom>(this.getNumPrims(7)));
        for (IGeom prim : prims) {
            result.mark((IPrimitive)prim, Containment.INSIDE);
        }
    }

    public Mesh fix() {
        if (this.primtype != 3) {
            return this;
        }
        boolean needsFix = false;
        int m = 0;
        while (m < this.indices.length) {
            Point3d p1 = this.vertices[this.indices[m++]];
            Point3d p2 = this.vertices[this.indices[m++]];
            Point3d p3 = this.vertices[this.indices[m++]];
            Point3d p4 = this.vertices[this.indices[m++]];
            if (!p1.equals(p2) && !p2.equals(p3) && !p3.equals(p4) && !p4.equals(p1) && Util3D.areCoplanar(1.0E-6, p1, p2, p3, p4)) continue;
            needsFix = true;
            break;
        }
        if (!needsFix) {
            return this;
        }
        int maxNumTris = this.indices.length / 4 * 2;
        int[] newIndices = new int[maxNumTris * 3];
        int newIxCount = 0;
        int m2 = 0;
        while (m2 < this.indices.length) {
            int i1 = this.indices[m2++];
            int i2 = this.indices[m2++];
            int i3 = this.indices[m2++];
            int i4 = this.indices[m2++];
            Point3d p1 = this.vertices[i1];
            Point3d p2 = this.vertices[i2];
            Point3d p3 = this.vertices[i3];
            Point3d p4 = this.vertices[i4];
            if (p1.equals(p2)) {
                newIxCount = Mesh.addTri(newIndices, newIxCount, i1, i3, i4);
                continue;
            }
            if (p2.equals(p3)) {
                newIxCount = Mesh.addTri(newIndices, newIxCount, i1, i2, i4);
                continue;
            }
            if (p3.equals(p4)) {
                newIxCount = Mesh.addTri(newIndices, newIxCount, i1, i2, i3);
                continue;
            }
            if (p4.equals(p1)) {
                newIxCount = Mesh.addTri(newIndices, newIxCount, i1, i2, i3);
                continue;
            }
            newIxCount = Mesh.addTri(newIndices, newIxCount, i1, i2, i3);
            newIxCount = Mesh.addTri(newIndices, newIxCount, i1, i3, i4);
        }
        if (newIxCount < newIndices.length) {
            newIndices = Arrays.copyOf(newIndices, newIxCount);
        }
        return new Mesh(this.vertices, newIndices, 2, this.flags);
    }

    private static int addTri(int[] ixes, int start, int i1, int i2, int i3) {
        ixes[start++] = i1;
        ixes[start++] = i2;
        ixes[start++] = i3;
        return start;
    }

    public IPrimitive getPrimitive(int ix) {
        int vertsPer = Mesh.getNumVertsPerElement(this.primtype);
        int i1 = vertsPer * ix;
        switch (this.primtype) {
            case 0: {
                return new Point(this.vertices[this.indices[i1]]);
            }
            case 1: {
                Point3d p1 = this.vertices[this.indices[i1++]];
                Point3d p2 = this.vertices[this.indices[i1++]];
                return new LineSeg(p1, p2);
            }
            case 2: {
                Point3d p1 = this.vertices[this.indices[i1++]];
                Point3d p2 = this.vertices[this.indices[i1++]];
                Point3d p3 = this.vertices[this.indices[i1++]];
                return new Triangle(p1, p2, p3);
            }
            case 3: {
                Point3d p1 = this.vertices[this.indices[i1++]];
                Point3d p2 = this.vertices[this.indices[i1++]];
                Point3d p3 = this.vertices[this.indices[i1++]];
                Point3d p4 = this.vertices[this.indices[i1++]];
                return new Quad(p1, p2, p3, p4);
            }
        }
        return null;
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        ArrayList<VertHandle> handles = new ArrayList<VertHandle>(this.vertices.length);
        for (int m = 0; m < this.vertices.length; ++m) {
            handles.add(new VertHandle(this, m));
        }
        return handles;
    }

    public static enum ClosedTest {
        CLOSED,
        WRONG_TYPE,
        ONE_FACE,
        EDGE_OPEN;

    }

    private static class EdgeHash {
        private int e1;
        private int e2;

        public EdgeHash() {
        }

        public EdgeHash(int e1, int e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        public void set(int e1, int e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        public int hashCode() {
            return this.e1 + this.e2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EdgeHash)) {
                return false;
            }
            EdgeHash eh = (EdgeHash)obj;
            return obj instanceof EdgeHash && eh.e1 == this.e1 && eh.e2 == this.e2 || eh.e1 == this.e2 && eh.e2 == this.e1;
        }
    }

    private static class VertHandle
    implements IHandle {
        private Mesh d_geom;
        private final int d_vertIx;
        private Point3d[] t_verts;

        public VertHandle(Mesh geom, int vertIx) {
            this.d_geom = geom;
            this.d_vertIx = vertIx;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof VertHandle && ((VertHandle)obj).d_vertIx == this.d_vertIx;
        }

        @Override
        public IGeom getGeom() {
            return new Point(this.d_geom.vertices[this.d_vertIx]);
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.t_verts = Arrays.copyOf(this.d_geom.vertices, this.d_geom.vertices.length);
        }

        @Override
        public Object modify(Point3d newLoc) throws Exception {
            this.t_verts[this.d_vertIx] = newLoc;
            this.d_geom = new Mesh(this.t_verts, this.d_geom.indices, this.d_geom.primtype, this.d_geom.flags);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.t_verts = null;
            return this.d_geom;
        }
    }
}

