/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Set;
import javax.vecmath.Matrix4d;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;

public interface IDOF {
    public static final IDOF FREE = new IDOF(){

        @Override
        public boolean accept(Matrix4d xform) {
            return true;
        }

        @Override
        public void describeRules(Set<String> rules) {
        }
    };
    public static final IDOF ALIGNED = new IDOF(){

        @Override
        public boolean accept(Matrix4d xform) {
            return GeomUtil.isAxisAlignedTransform(xform);
        }

        @Override
        public void describeRules(Set<String> rules) {
            rules.add(Intl.intl("Rotation must be in 90 degree increments about the X, Y, or Z axis."));
        }
    };
    public static final IDOF NONE = new IDOF(){

        @Override
        public boolean accept(Matrix4d xform) {
            return xform.m00 > 0.0 && xform.m01 == 0.0 && xform.m02 == 0.0 && xform.m10 == 0.0 && xform.m11 > 0.0 && xform.m12 == 0.0 && xform.m20 == 0.0 && xform.m21 == 0.0 && xform.m22 > 0.0 && xform.m30 == 0.0 && xform.m31 == 0.0 && xform.m32 == 0.0 && xform.m33 > 0.0;
        }

        @Override
        public void describeRules(Set<String> rules) {
            rules.add(Intl.intl("Rotation and mirroring are not allowed."));
        }
    };
    public static final IDOF ROT_Z = new IDOF(){

        @Override
        public boolean accept(Matrix4d xform) {
            return GeomUtil.isZRotation(xform);
        }

        @Override
        public void describeRules(Set<String> rules) {
            rules.add(Intl.intl("Rotation may only be about the Z-axis."));
        }
    };

    public boolean accept(Matrix4d var1);

    public void describeRules(Set<String> var1);

    public static class CompositeDOF
    implements IDOF {
        public final Set<? extends IDOF> dofs;

        public CompositeDOF(Set<? extends IDOF> dofs) {
            this.dofs = dofs;
        }

        @Override
        public boolean accept(Matrix4d xform) {
            for (IDOF iDOF : this.dofs) {
                if (iDOF.accept(xform)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void describeRules(Set<String> rules) {
            for (IDOF iDOF : this.dofs) {
                iDOF.describeRules(rules);
            }
        }
    }
}

