/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.util.theUtil;

public class GeomGroup
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final List<IGeom> children;

    public GeomGroup(Collection<? extends IGeom> children) {
        this.children = new ArrayList<IGeom>(children);
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 dict) {
        if (this.children.isEmpty()) {
            return EmptyGeom.INSTANCE;
        }
        Predicate<IGeom> isGeom = o -> dict.get((ILegacy_2012_1)o) instanceof thunderheadeng.geometry.objs.IGeom;
        Function<IGeom, thunderheadeng.geometry.objs.IGeom> gmapper = c -> (thunderheadeng.geometry.objs.IGeom)dict.get((ILegacy_2012_1)c);
        if (this.children.stream().allMatch(isGeom)) {
            return new thunderheadeng.geometry.objs.GeomGroup(theUtil.map(this.children, gmapper));
        }
        ArrayList<IGeomNode> nodes = new ArrayList<IGeomNode>();
        int m = 0;
        while (m < this.children.size()) {
            Object child = dict.get(this.children.get(m));
            if (child instanceof thunderheadeng.geometry.objs.IGeom) {
                int geomCount = theUtil.getMatchCount(this.children.subList(m, this.children.size()), isGeom);
                ArrayList<thunderheadeng.geometry.objs.IGeom> geoms = new ArrayList<thunderheadeng.geometry.objs.IGeom>();
                int end = m + geomCount;
                for (int n = m; n < end; ++n) {
                    geoms.add(gmapper.apply(this.children.get(n)));
                }
                nodes.add(GeomNodeUtil.newNode(thunderheadeng.geometry.objs.GeomUtil.group(geoms)));
                m += geomCount;
                continue;
            }
            nodes.add((IGeomNode)child);
            ++m;
        }
        return GeomNodeUtil.newNode(nodes).prune();
    }

    @Override
    public GeomGroup optimize(IPointOptimizer pool) {
        boolean modified = false;
        ArrayList<IGeom> nchildren = new ArrayList<IGeom>(this.children.size());
        for (int m = 0; m < this.children.size(); ++m) {
            IGeom child = this.children.get(m);
            IGeom nchild = child.optimize(pool);
            nchildren.add(nchild);
            modified |= child != nchild;
        }
        return modified ? new GeomGroup(nchildren) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        for (int m = 0; m < this.children.size(); ++m) {
            this.children.get(m).getBoundingBox(aabb);
        }
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        LinkedHashSet<IDOF> dofs = new LinkedHashSet<IDOF>();
        for (IGeom child : this.children) {
            dofs.add(child.getDOF());
        }
        return GeomUtil.groupDOFs(dofs);
    }

    @Override
    public IGeom transform(Matrix4d xform, IGeom.XformOp op) {
        ArrayList<IGeom> newList = new ArrayList<IGeom>(this.children.size());
        for (IGeom child : this.children) {
            newList.add(child.transform(xform, op));
        }
        return new GeomGroup(newList);
    }

    @Override
    public boolean canExplode() {
        return !this.children.isEmpty();
    }

    @Override
    public int getNumPrims(int types) {
        int count = 0;
        for (int m = 0; m < this.children.size(); ++m) {
            count += this.children.get(m).getNumPrims(types);
        }
        return count;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> prims) {
        prims.addAll(this.children);
        return prims;
    }

    @Override
    public boolean isAxisAlignedBlock(Matrix4d parentXform) {
        return false;
    }

    @Override
    public boolean isShell() {
        if (this.children.isEmpty()) {
            return true;
        }
        for (int m = 0; m < this.children.size(); ++m) {
            if (!this.children.get(m).isShell()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        for (IGeom geom : this.children) {
            if (!geom.intersectsBox(source, filter, region)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        AABox testBox = new AABox();
        for (IGeom geom : this.children) {
            isects.getProgress().check();
            testBox.reset();
            geom.getBoundingBox(testBox);
            if (!tester.test((AABox)testBox).positive) continue;
            geom.pickPoints(isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
        }
    }

    @Override
    public void find(ITest<AABox> tester, IResult<? super IPrimitive> result) {
        AABox testBox = new AABox();
        for (IGeom geom : this.children) {
            testBox.reset();
            geom.getBoundingBox(testBox);
            if (!tester.test((AABox)testBox).positive) continue;
            geom.find(tester, result);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> result) {
        for (IGeom geom : this.children) {
            geom.getAll(result);
        }
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        if (this.children.size() > 1) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Handle> handles = new ArrayList<Handle>();
        for (int m = 0; m < this.children.size(); ++m) {
            IGeom child = this.children.get(m);
            if (!(child instanceof IManipulatable)) continue;
            for (IHandle iHandle : ((IManipulatable)((Object)child)).generateManipHandles()) {
                handles.add(new Handle(this, m, iHandle));
            }
        }
        return handles;
    }

    private static class Handle
    implements IHandle {
        private GeomGroup d_geom;
        private final int d_ix;
        private final IHandle d_handle;
        private List<IGeom> t_children;

        public Handle(GeomGroup geom, int childIx, IHandle handle) {
            this.d_geom = geom;
            this.d_ix = childIx;
            this.d_handle = handle;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle && ((Handle)obj).d_ix == this.d_ix && ((Handle)obj).d_handle.equals(this.d_handle);
        }

        @Override
        public IGeom getGeom() {
            return this.d_handle.getGeom();
        }

        @Override
        public IIsectFilter getPickFilter() {
            return this.d_handle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return this.d_handle.getConstraint(handleLoc);
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.t_children = new ArrayList<IGeom>(this.d_geom.children);
            this.d_handle.begin(handleLoc, constraint);
        }

        @Override
        public Object modify(Point3d newLoc) throws Exception {
            Object mod = this.d_handle.modify(newLoc);
            this.d_geom = this.modify(mod);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.d_geom = this.modify(this.d_handle.end());
            this.t_children = null;
            return this.d_geom;
        }

        private GeomGroup modify(Object mod) {
            if (mod instanceof IGeom) {
                this.t_children.set(this.d_ix, (IGeom)mod);
                return new GeomGroup(this.t_children);
            }
            return this.d_geom;
        }
    }
}

