/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.MeshBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.TriangulatorInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NullOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;

public class GeneralPoly
extends AFace
implements IPolygon,
IManipulatable {
    static final long serialVersionUID = 1L;
    public final Point3d[] points;
    public final int[] loopOffsets;

    public GeneralPoly(Collection<Point3d> points, int ... loopOffsets) {
        this(points.toArray(new Point3d[points.size()]), loopOffsets);
    }

    public GeneralPoly(Point3d[] points, int ... loopOffsets) {
        assert (points.length >= 3);
        assert (GeneralPoly.checkLoopOffsets(points, loopOffsets));
        this.points = points;
        this.loopOffsets = loopOffsets;
    }

    public GeneralPoly(Point3d[][] points) {
        int totNumPoints = 0;
        for (int m = 0; m < points.length; ++m) {
            totNumPoints += points[m].length;
        }
        this.points = new Point3d[totNumPoints];
        int loopOffset = 0;
        this.loopOffsets = new int[points.length];
        for (int m = 0; m < points.length; ++m) {
            this.loopOffsets[m] = loopOffset;
            Point3d[] loop = points[m];
            for (int n = 0; n < loop.length; ++n) {
                this.points[loopOffset + n] = loop[n];
            }
            loopOffset += points[m].length;
        }
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 dict) {
        return new thunderheadeng.geometry.objs.GeneralPoly(this.points, this.loopOffsets);
    }

    public static boolean checkLoopOffsets(Point3d[] points, int ... loopOffsets) {
        for (int offset : loopOffsets) {
            if (offset >= 0 && offset < points.length) continue;
            return false;
        }
        return true;
    }

    @Override
    public GeneralPoly optimize(IPointOptimizer pool) {
        if (pool instanceof NullOptimizer) {
            return this;
        }
        boolean changed = false;
        Point3d[] npoints = new Point3d[this.points.length];
        for (int m = 0; m < this.points.length; ++m) {
            npoints[m] = pool.getExisting(this.points[m]);
            changed |= npoints[m] != this.points[m];
        }
        return changed ? new GeneralPoly(npoints, this.loopOffsets) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.points);
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public GeneralPoly transform(Matrix4d xform) {
        Point3d[] newPoints = GeomUtil.xformVerts(this.points, xform);
        return new GeneralPoly(newPoints, this.loopOffsets);
    }

    @Override
    public int getNumLoops() {
        return this.loopOffsets.length;
    }

    @Override
    public int getNumPoints(int loop) {
        assert (loop >= 0 && loop < this.loopOffsets.length);
        if (loop == this.loopOffsets.length - 1) {
            return this.points.length - this.loopOffsets[loop];
        }
        return this.loopOffsets[loop + 1] - this.loopOffsets[loop];
    }

    @Override
    public Point3d getPoint(int loop, int ix) {
        assert (loop >= 0 && loop < this.loopOffsets.length);
        return this.points[this.loopOffsets[loop] + ix];
    }

    @Override
    public Vector3d getNormal() {
        Point3d[] outerPoints = this.loopOffsets.length <= 1 ? this.points : Arrays.copyOf(this.points, this.loopOffsets[1]);
        Vector3d normal = Util3D.simplePolygonNormal(Arrays.asList(outerPoints), 1.0E-6);
        return normal == null ? GeomConstants.VEC3D_ZERO : normal;
    }

    @Override
    public void getBoundary(List<ICurve> boundary) {
        PolyUtil.getBoundary(boundary, this);
    }

    @Override
    public Mesh triangulate(double errorTol) {
        int m;
        int m2;
        HashMap<Point2d, Point3d> localVertMap = new HashMap<Point2d, Point3d>();
        Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(this.points), 1.0E-6);
        if (plane == null) {
            return null;
        }
        Matrix4d wlXform = Util.getWorldToLocalXform(plane);
        Matrix4d lwXform = Util.getLocalToWorldXform(plane);
        Point2d[] p2ds = new Point2d[this.points.length];
        MeshBuilder mb = new MeshBuilder(1.0E-6);
        for (m2 = 0; m2 < this.points.length; ++m2) {
            Point2d xformed = Util3D.xform2d(wlXform, this.points[m2]);
            localVertMap.put(xformed, this.points[m2]);
            p2ds[m2] = xformed;
        }
        for (m2 = 0; m2 < this.loopOffsets.length; ++m2) {
            int numVerts = this.getNumPoints(m2);
            int begin = this.loopOffsets[m2];
            for (int n = 0; n < numVerts; ++n) {
                Point2d p1 = p2ds[begin + n];
                Point2d p2 = p2ds[begin + (n + 1) % numVerts];
                mb.addEdge(p1, p2);
            }
        }
        pyrosim.legacy_2012_1.thunderheadeng.delaunay.Mesh mesh = mb.build();
        boolean triangulated = mesh.triangulateEvenOdd(0, 0.0);
        if (!triangulated) {
            return null;
        }
        LinkedHashMap<Point3d, Integer> pointIxMap = new LinkedHashMap<Point3d, Integer>();
        TriangulatorInfo result = mesh.getOutput();
        int[] localWorldIxes = new int[result.points.length];
        for (m = 0; m < result.points.length; ++m) {
            Integer ix;
            Point2d p2d = result.points[m];
            Point3d p3d = (Point3d)localVertMap.get(p2d);
            if (p3d == null) {
                p3d = Util3D.xform(lwXform, new Point3d(p2d.x, p2d.y, 0.0));
            }
            if ((ix = (Integer)pointIxMap.get(p3d)) == null) {
                ix = pointIxMap.size();
                pointIxMap.put(p3d, ix);
            }
            localWorldIxes[m] = ix;
        }
        for (m = 0; m < result.triangles.length; ++m) {
            result.triangles[m] = localWorldIxes[result.triangles[m]];
        }
        return new Mesh(pointIxMap.keySet().toArray(new Point3d[pointIxMap.size()]), result.triangles, 2);
    }

    @Override
    public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        return PolyUtil.intersectsBox(source, this, filter, region);
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        PolyUtil.pickPoints(this, isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
    }

    @Override
    public Point3d project(Point3d p) {
        return PolyUtil.getPlane(this).projectOntoPlane(p);
    }

    @Override
    public IFace.PointClassify classify(Point3d p, double tol) {
        return PolyUtil.classify(this, p, tol);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return PolyUtil.generateManipHandles(this);
    }
}

