/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.AExtrudeHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.TransformedGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.PlanarConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class ExtrudedPoly
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final IPolygon poly;
    public final Vector3d extrusion;

    public ExtrudedPoly(IPolygon poly, Vector3d extrusion) {
        this.poly = poly;
        this.extrusion = extrusion;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 dict) {
        return new thunderheadeng.geometry.objs.ExtrudedPoly((thunderheadeng.geometry.objs.IPolygon)dict.get(this.poly), this.extrusion);
    }

    @Override
    public ExtrudedPoly optimize(IPointOptimizer pool) {
        IPolygon npoly = this.poly.optimize(pool);
        return npoly == this.poly ? this : new ExtrudedPoly(npoly, this.extrusion);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        this.poly.getBoundingBox(aabb);
        new TransformedGeom(Util.translateMat(this.extrusion.x, this.extrusion.y, this.extrusion.z), this.poly).getBoundingBox(aabb);
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IGeom transform(Matrix4d xform, IGeom.XformOp op) {
        IPolygon base = this.poly.transform(xform);
        Vector3d newExt = Util3D.xform(xform, this.extrusion);
        return new ExtrudedPoly(base, newExt);
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public int getNumPrims(int types) {
        int numPrims = this.poly.getNumPrims(types) * 2;
        if ((types & 1) != 0) {
            for (int m = 0; m < this.poly.getNumLoops(); ++m) {
                numPrims += this.poly.getNumPoints(m);
            }
        }
        return numPrims;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> prims) {
        IPolygon basePoly = this.poly;
        prims.add(basePoly);
        int[] offsets = PolyUtil.getLoopOffsets(basePoly, false);
        int numPolyPoints = 0;
        for (int m = 0; m < basePoly.getNumLoops(); ++m) {
            numPolyPoints += basePoly.getNumPoints(m);
        }
        int ix = 0;
        Point3d[] points = new Point3d[numPolyPoints * 2];
        for (int m = 0; m < basePoly.getNumLoops(); ++m) {
            for (int n = 0; n < basePoly.getNumPoints(m); ++n) {
                points[ix++] = basePoly.getPoint(m, n);
            }
        }
        Vector3d ext = this.extrusion;
        Point3d[] topPolyPoints = new Point3d[numPolyPoints];
        for (int m = numPolyPoints; m < points.length; ++m) {
            Point3d p = new Point3d();
            p.add(points[m - numPolyPoints], ext);
            points[m] = p;
            topPolyPoints[m - numPolyPoints] = p;
        }
        prims.add(PolyUtil.newPoly(topPolyPoints, offsets));
        int[] ixes = new int[numPolyPoints * 4];
        int pix = 0;
        for (int m = 0; m < offsets.length; ++m) {
            int offset = offsets[m];
            int numPoints = basePoly.getNumPoints(m);
            for (int n = 0; n < numPoints; ++n) {
                int ix1 = offset + n;
                int ix2 = offset + (n + 1) % numPoints;
                ixes[pix++] = ix1;
                ixes[pix++] = ix2;
                ixes[pix++] = ix2 + numPolyPoints;
                ixes[pix++] = ix1 + numPolyPoints;
            }
        }
        prims.add(new Mesh(points, ixes, 3));
        return prims;
    }

    private List<IGeom> explode() {
        ArrayList<IGeom> list = new ArrayList<IGeom>(3);
        this.explode(list);
        return list;
    }

    @Override
    public boolean isAxisAlignedBlock(Matrix4d parentXform) {
        return false;
    }

    @Override
    public boolean isShell() {
        return Boolean.FALSE;
    }

    @Override
    public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        for (IGeom geom : this.explode()) {
            if (!geom.intersectsBox(source, filter, region)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        for (IGeom geom : this.explode()) {
            geom.pickPoints(isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
        }
    }

    @Override
    public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
        for (IGeom geom : this.explode()) {
            geom.find(test, result);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> result) {
        for (IGeom geom : this.explode()) {
            geom.getAll(result);
        }
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        ArrayList<IHandle> handles = new ArrayList<IHandle>();
        for (int m = 0; m < 2; ++m) {
            boolean bottom = m == 0;
            int numLoops = this.poly.getNumLoops();
            for (int n = 0; n < numLoops; ++n) {
                int numVerts = this.poly.getNumPoints(n);
                for (int o = 0; o < numVerts; ++o) {
                    handles.add(new VertHandle(this, n, o, bottom));
                }
            }
        }
        handles.add(new ExtrusionHandle(this, true));
        handles.add(new ExtrusionHandle(this, false));
        return handles;
    }

    private static class VertHandle
    implements IHandle {
        private ExtrudedPoly geom;
        private final int loop;
        private final int vert;
        private final boolean bottom;

        public VertHandle(ExtrudedPoly geom, int loop, int vert, boolean bottom) {
            this.geom = geom;
            this.loop = loop;
            this.vert = vert;
            this.bottom = bottom;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof VertHandle)) {
                return false;
            }
            VertHandle handle = (VertHandle)obj;
            return handle.loop == this.loop && handle.vert == this.vert && handle.bottom == this.bottom;
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public IGeom getGeom() {
            return new Point(this.getLocation());
        }

        protected Point3d getLocation() {
            Point3d p = this.geom.poly.getPoint(this.loop, this.vert);
            if (!this.bottom) {
                p = Util3D.add(p, (Tuple3d)this.geom.extrusion);
            }
            return p;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            Plane3d plane;
            if (this.bottom) {
                plane = PolyUtil.getPlane(this.geom.poly);
            } else {
                Vector3d normal = this.geom.poly.getNormal();
                Point3d p = Util3D.add(this.geom.poly.getPoint(this.loop, this.vert), (Tuple3d)this.geom.extrusion);
                plane = new Plane3d(normal, p);
            }
            return new PlanarConstraint(plane);
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public ExtrudedPoly modify(Point3d isect) throws Exception {
            if (!this.bottom) {
                isect = Util3D.sub(isect, (Tuple3d)this.geom.extrusion);
            }
            Point3d[][] loops = PolyUtil.getLoops(this.geom.poly, true);
            loops[this.loop][this.vert] = isect;
            this.geom = new ExtrudedPoly(PolyUtil.newPoly(loops), this.geom.extrusion);
            return this.geom;
        }

        @Override
        public Object end() {
            return this.geom;
        }
    }

    private static class ExtrusionHandle
    extends AExtrudeHandle<ExtrudedPoly> {
        private final boolean d_top;

        public ExtrusionHandle(ExtrudedPoly geom, boolean top) {
            super(geom);
            this.d_top = top;
        }

        @Override
        public IGeom getGeom() {
            ExtrudedPoly ep = (ExtrudedPoly)this.getManipGeom();
            if (this.d_top) {
                return ep.poly.transform(Util.translateMat(ep.extrusion.x, ep.extrusion.y, ep.extrusion.z));
            }
            return ep.poly;
        }

        @Override
        protected Vector3d getExtrudeDir(ExtrudedPoly geom) {
            return theUtil.eq0(geom.extrusion.length(), 1.0E-6) ? geom.poly.getNormal() : Util3D.normalize(geom.extrusion);
        }

        @Override
        protected ExtrudedPoly extrude(ExtrudedPoly geom, Vector3d extrudeDir, double t) {
            extrudeDir = Util3D.scale(extrudeDir, t);
            if (this.d_top) {
                extrudeDir = Util3D.add(geom.extrusion, (Tuple3d)extrudeDir);
                return new ExtrudedPoly(geom.poly, extrudeDir);
            }
            Matrix4d xform = Util.translateMat(extrudeDir.x, extrudeDir.y, extrudeDir.z);
            IPolygon newPoly = geom.poly.transform(xform);
            extrudeDir = Util3D.sub(geom.extrusion, (Tuple3d)extrudeDir);
            return new ExtrudedPoly(newPoly, extrudeDir);
        }
    }
}

