/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt;

import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Model;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.NmtUtil;

public class BooleanOp {
    public static Model subtract(Model model1, boolean model1Solid, Model model2, boolean model2Solid) {
        if (model1Solid && !model2Solid) {
            return model1;
        }
        int keepId = 0x7FFFFFFE;
        int subId = Integer.MAX_VALUE;
        Model result = (Model)model1.clone();
        result.addGroupId(keepId);
        Model model2Clone = (Model)model2.clone();
        model2Clone.addGroupId(subId);
        result.merge(model2Clone);
        ArrayList<Face> delFaces = new ArrayList<Face>();
        if (model1Solid && model2Solid) {
            for (Face face : result.getFaces()) {
                if (!BooleanOp.isDeleteFace(model1, model2, keepId, subId, result, face)) continue;
                delFaces.add(face);
            }
        } else if (!model1Solid && model2Solid) {
            for (Face face : result.getFaces()) {
                if (!face.partOfGroup(subId) && (!face.partOfGroup(keepId) || !NmtUtil.faceInSolid(model2, result, face))) continue;
                delFaces.add(face);
            }
        } else {
            assert (!model1Solid && !model2Solid);
            for (Face face : result.getFaces()) {
                if (!face.partOfGroup(subId)) continue;
                delFaces.add(face);
            }
        }
        boolean model1Modified = false;
        for (Face delFace : delFaces) {
            if (!delFace.partOfGroup(keepId)) continue;
            model1Modified = true;
            break;
        }
        if (!model1Modified) {
            for (Face face : result.getFaces()) {
                if (!face.partOfGroup(subId) || face.partOfGroup(keepId) || delFaces.contains(face)) continue;
                model1Modified = true;
                break;
            }
        }
        if (!model1Modified) {
            return model1;
        }
        for (Face delFace : delFaces) {
            result.deleteFace(delFace, true, true);
        }
        result.removeGroupIds(keepId, subId);
        return result;
    }

    private static boolean isDeleteFace(Model keepModel, Model subModel, int keepId, int subId, Model model, Face face) {
        boolean partOfSubGroup = face.partOfGroup(subId);
        boolean partOfKeepGroup = face.partOfGroup(keepId);
        if (partOfSubGroup && !partOfKeepGroup && !NmtUtil.faceInSolid(keepModel, model, face) || !partOfSubGroup && partOfKeepGroup && NmtUtil.faceInSolid(subModel, model, face)) {
            return true;
        }
        if (partOfSubGroup && partOfKeepGroup) {
            Point3d testp = model.findPointInFace(face);
            if (testp == null) {
                return false;
            }
            Vector3d normal = face.plane.getNormal();
            normal.scale(2.0E-6);
            testp.add(normal);
            boolean inMod1 = keepModel.contains(testp);
            boolean inMod2 = subModel.contains(testp);
            return inMod1 == inMod2;
        }
        return false;
    }
}

