/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.manip;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.LineConstraint;

public abstract class AExtrudeHandle<T>
implements IHandle {
    private T d_origGeom;
    private T d_geom;
    private Vector3d d_extrudeDir;
    private Point3d d_snapLoc;

    public AExtrudeHandle(T geom) {
        this.d_geom = geom;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AExtrudeHandle && ((AExtrudeHandle)obj).d_geom.getClass().isInstance(this.d_geom);
    }

    protected T getManipGeom() {
        return this.d_geom;
    }

    @Override
    public IIsectFilter getPickFilter() {
        return null;
    }

    protected abstract Vector3d getExtrudeDir(T var1);

    protected abstract T extrude(T var1, Vector3d var2, double var3) throws Exception;

    @Override
    public ISnapConstraint getConstraint(Point3d handleLoc) {
        Vector3d extrudeDir = this.getExtrudeDir(this.d_geom);
        return new LineConstraint(handleLoc, extrudeDir);
    }

    @Override
    public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        LineConstraint lc = (LineConstraint)constraint;
        this.d_origGeom = this.d_geom;
        this.d_snapLoc = handleLoc;
        this.d_extrudeDir = lc.dir;
    }

    @Override
    public Object modify(Point3d newLoc) throws Exception {
        double t = Util3D.tOnLine(this.d_snapLoc, this.d_extrudeDir, newLoc);
        this.d_geom = this.extrude(this.d_origGeom, this.d_extrudeDir, t);
        return this.d_geom;
    }

    @Override
    public Object end() {
        return this.d_geom;
    }
}

