/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util2D;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.View;
import pyrosim.legacy_2012_1.thunderheadeng.util.theMath;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Util3D {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;
    public static final Tuple3d TUP3D_ZERO = new Point3d(0.0, 0.0, 0.0);
    public static final Vector3d VEC3D_XPOS = new Vector3d(1.0, 0.0, 0.0);
    public static final Vector3d VEC3D_XNEG = new Vector3d(-1.0, 0.0, 0.0);
    public static final Vector3d VEC3D_YPOS = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d VEC3D_YNEG = new Vector3d(0.0, -1.0, 0.0);
    public static final Vector3d VEC3D_ZPOS = new Vector3d(0.0, 0.0, 1.0);
    public static final Vector3d VEC3D_ZNEG = new Vector3d(0.0, 0.0, -1.0);
    public static final Point3d PNT3D_XPOS = new Point3d(1.0, 0.0, 0.0);
    public static final Point3d PNT3D_XNEG = new Point3d(-1.0, 0.0, 0.0);
    public static final Point3d PNT3D_YPOS = new Point3d(0.0, 1.0, 0.0);
    public static final Point3d PNT3D_YNEG = new Point3d(0.0, -1.0, 0.0);
    public static final Point3d PNT3D_ZPOS = new Point3d(0.0, 0.0, 1.0);
    public static final Point3d PNT3D_ZNEG = new Point3d(0.0, 0.0, -1.0);
    public static final Vector3d VEC_ZERO = new Vector3d(0.0, 0.0, 0.0);
    public static final Point3d PNT_ZERO = new Point3d(0.0, 0.0, 0.0);

    public static double interpolateTriValues(Point3d A, Point3d B, Point3d C, double valA, double valB, double valC, Point3d P) {
        Vector3d e1 = new Vector3d(1.0, 0.0, 0.0);
        Vector3d e2 = new Vector3d(0.0, 1.0, 0.0);
        Vector3d e3 = new Vector3d(0.0, 0.0, 1.0);
        Point3d Btrans = new Point3d(B.x - A.x, B.y - A.y, B.z - A.z);
        Point3d Ctrans = new Point3d(C.x - A.x, C.y - A.y, C.z - A.z);
        Point3d Ptrans = new Point3d(P.x - A.x, P.y - A.y, P.z - A.z);
        Vector3d e1t = new Vector3d(Btrans);
        Vector3d e3t = Util3D.cross(e1t, new Vector3d(Ctrans));
        Vector3d e2t = Util3D.cross(e3t, e1t);
        e1t.normalize();
        e2t.normalize();
        e3t.normalize();
        Matrix3d rot = new Matrix3d(e1.dot(e1t), e2.dot(e1t), e3.dot(e1t), e1.dot(e2t), e2.dot(e2t), e3.dot(e2t), e1.dot(e3t), e2.dot(e3t), e3.dot(e3t));
        rot.transform(Btrans);
        rot.transform(Ctrans);
        rot.transform(Ptrans);
        Point2d A2d = new Point2d(0.0, 0.0);
        Point2d B2d = new Point2d(Btrans.x, Btrans.y);
        Point2d C2d = new Point2d(Ctrans.x, Ctrans.y);
        Point2d P2d = new Point2d(Ptrans.x, Ptrans.y);
        double[] interp = Util2D.getInterpolateParams(A2d, B2d, C2d, P2d);
        double val = Util2D.interpolate(valA, valB, valC, interp);
        return val;
    }

    public static Plane3d getPlane(Vector3d normal, Point3d pointOnPlane) {
        double d = -(normal.x * pointOnPlane.x + normal.y * pointOnPlane.y + normal.z * pointOnPlane.z);
        return new Plane3d(normal.x, normal.y, normal.z, d);
    }

    public static Plane3d getPlane(Point3d pOnPlane, Point3d pOnNormal) {
        Vector3d normal = Util3D.vector(pOnPlane, pOnNormal);
        normal.normalize();
        return Util3D.getPlane(normal, pOnPlane);
    }

    public static double distance(Point3d point, Plane3d plane) {
        return point.x * plane.x + point.y * plane.y + point.z * plane.z + plane.w;
    }

    public static boolean pointOnPlane(Point3d p, Plane3d plane, double tol) {
        double val = p.x * plane.x + p.y * plane.y + p.z * plane.z + plane.w;
        return Math.abs(val) <= tol;
    }

    public static boolean isPointBehindPlane(Point3d point, Point3d rayBegin, Vector3d dirN) {
        double d = -(dirN.x * rayBegin.x + dirN.y * rayBegin.y + dirN.z * rayBegin.z);
        double pDot = dirN.x * point.x + dirN.y * point.y + dirN.z * point.z + d;
        return pDot < 0.0;
    }

    public static int getClosestAxis(Vector3d vec) {
        double closestOneDiff;
        int closestAxis;
        Vector3d vecNorm = new Vector3d();
        vecNorm.normalize(vec);
        double xdot = vecNorm.dot(VEC3D_XPOS);
        double ydot = vecNorm.dot(VEC3D_YPOS);
        double zdot = vecNorm.dot(VEC3D_ZPOS);
        double xdotOneDiff = Math.abs(Math.abs(xdot) - 1.0);
        double ydotOneDiff = Math.abs(Math.abs(ydot) - 1.0);
        double zdotOneDiff = Math.abs(Math.abs(zdot) - 1.0);
        if (xdotOneDiff < ydotOneDiff) {
            closestAxis = 0;
            closestOneDiff = xdotOneDiff;
        } else {
            closestAxis = 1;
            closestOneDiff = ydotOneDiff;
        }
        if (zdotOneDiff < closestOneDiff) {
            closestAxis = 2;
        }
        return closestAxis;
    }

    public static Point3d getClosestPoint(View view, Point3d point, double toleranceScreen, Point3d ... testPoints) {
        return Util3D.getClosestPoint(view, point, toleranceScreen, Arrays.asList(testPoints));
    }

    public static Point3d getClosestPoint(View view, Point3d point, double toleranceScreen, Collection<Point3d> testPoints) {
        Point3d pointSc = view.worldToScreen(point);
        double tolSq = toleranceScreen * toleranceScreen;
        Point3d closestPoint = null;
        double closestDistSq = tolSq;
        for (Point3d testPoint : testPoints) {
            if (testPoint == null) continue;
            Point3d testPointSc = view.worldToScreen(testPoint);
            double dx = testPointSc.x - pointSc.x;
            double dy = testPointSc.y - pointSc.y;
            double distSq = dx * dx + dy * dy;
            if (!(distSq <= closestDistSq)) continue;
            closestDistSq = distSq;
            closestPoint = testPoint;
        }
        return closestPoint;
    }

    private static boolean lEqual(double v1, double v2, double tol) {
        return v1 - v2 <= tol;
    }

    private static boolean gEqual(double v1, double v2, double tol) {
        return v1 - v2 >= -tol;
    }

    public static Quat4d shortestArc(Vector3d v1, Vector3d v2, Vector3d fallbackAxis, double epsilon) {
        Quat4d result = new Quat4d();
        Vector3d uv1 = new Vector3d();
        uv1.normalize(v1);
        Vector3d uv2 = new Vector3d();
        uv2.normalize(v2);
        double d = uv1.dot(uv2);
        if (Util3D.lEqual(d, -1.0, epsilon)) {
            Vector3d ufa = new Vector3d();
            ufa.normalize(fallbackAxis);
            result.set(ufa.x, ufa.y, ufa.z, 0.0);
            return result;
        }
        if (Util3D.gEqual(d, 1.0, epsilon)) {
            result.set(0.0, 0.0, 0.0, 1.0);
            return result;
        }
        Vector3d cross = new Vector3d();
        cross.cross(uv1, uv2);
        double s = Math.sqrt((1.0 + d) * 2.0);
        double invs = 1.0 / s;
        result.set(cross.x * invs, cross.y * invs, cross.z * invs, s * 0.5);
        return result;
    }

    public static double getRotation(Quat4d quat) {
        return Util3D.getRotation(quat, null);
    }

    public static double getRotation(Quat4d inQuat, Vector3d outAxis) {
        double halfAngle = Math.acos(inQuat.w);
        if (outAxis != null) {
            double invSinAngle = 1.0 / Math.sin(halfAngle);
            outAxis.set(inQuat.x * invSinAngle, inQuat.y * invSinAngle, inQuat.z * invSinAngle);
        }
        return halfAngle * 2.0;
    }

    public static Vector3d vector(Point3d p1, Point3d p2) {
        return new Vector3d(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
    }

    public static Vector3d vectorN(Point3d p1, Point3d p2) {
        Vector3d vec = Util3D.vector(p1, p2);
        vec.normalize();
        return vec;
    }

    public static Vector3d normalize(Vector3d vec) {
        double invLen = 1.0 / Math.sqrt(vec.x * vec.x + vec.y * vec.y + vec.z * vec.z);
        return new Vector3d(vec.x * invLen, vec.y * invLen, vec.z * invLen);
    }

    public static Vector3d cross(Vector3d v1, Vector3d v2) {
        Vector3d cross = new Vector3d();
        cross.cross(v1, v2);
        return cross;
    }

    public static double dot(Tuple3d v, Tuple3d p) {
        return v.x * p.x + v.y * p.y + v.z * p.z;
    }

    public static Vector3d add(Vector3d a, Tuple3d b) {
        return new Vector3d(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static Point3d add(Point3d a, Tuple3d b) {
        return new Point3d(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static Vector3d sub(Vector3d a, Tuple3d b) {
        return new Vector3d(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static Point3d sub(Point3d a, Tuple3d b) {
        return new Point3d(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static Vector3d scale(Vector3d a, double s) {
        return new Vector3d(a.x * s, a.y * s, a.z * s);
    }

    public static Point3d getMidPoint(Point3d p1, Point3d p2) {
        return new Point3d((p1.x + p2.x) * 0.5, (p1.y + p2.y) * 0.5, (p1.z + p2.z) * 0.5);
    }

    public static Vector3d negate(Vector3d p) {
        return new Vector3d(-p.x, -p.y, -p.z);
    }

    public static Vector3d negateEq(Vector3d p) {
        p.negate();
        return p;
    }

    public static double angleWithPlane(Plane3d plane, Vector3d vec, double tol) {
        Vector3d planeNorm = plane.getNormal();
        Vector3d norm = Util3D.cross(vec, planeNorm);
        if (theUtil.eq0(norm.dot(norm), tol * tol)) {
            return 1.5707963267948966;
        }
        norm.cross(planeNorm, norm);
        return norm.angle(vec);
    }

    public static boolean areParallel(Plane3d plane, Vector3d vec, double tol) {
        return Util3D.arePerpendicular(plane.getNormal(), vec, tol);
    }

    public static boolean areParallel(Plane3d plane1, Plane3d plane2, double tol) {
        return Util3D.areParallel(plane1.getNormal(), plane2.getNormal(), tol);
    }

    public static boolean lineInPlane(Plane3d plane, Point3d l1, Vector3d v, double tol) {
        double dist = plane.dot(l1);
        if (Math.abs(dist) > tol) {
            return false;
        }
        return Util3D.areParallel(plane, v, tol);
    }

    public static boolean linesegInPlane(Plane3d plane, Point3d l1, Point3d l2, double tol) {
        return Math.abs(plane.dot(l1)) <= tol && Math.abs(plane.dot(l2)) <= tol;
    }

    public static Point3d linesegPoint(Point3d l1, Point3d l2, double t) {
        if (t == 1.0) {
            return new Point3d(l2);
        }
        return new Point3d(l1.x + (l2.x - l1.x) * t, l1.y + (l2.y - l1.y) * t, l1.z + (l2.z - l1.z) * t);
    }

    public static Point3d linePoint(Point3d l1, Vector3d vec, double t) {
        return new Point3d(l1.x + vec.x * t, l1.y + vec.y * t, l1.z + vec.z * t);
    }

    public static Point3d linePoint(Point3d l1, Vector3d vec, double t, Point3d result) {
        result.set(l1.x + vec.x * t, l1.y + vec.y * t, l1.z + vec.z * t);
        return result;
    }

    private static double dirDotTest(Vector3d vec1, Vector3d vec2, double tol) {
        double v1lenSq = vec1.lengthSquared();
        if (v1lenSq <= tol) {
            return Double.NaN;
        }
        double v2lenSq = vec2.lengthSquared();
        if (v2lenSq <= tol) {
            return Double.NaN;
        }
        Vector3d vec1n = Util3D.scale(vec1, 1.0 / Math.sqrt(v1lenSq));
        Vector3d vec2n = Util3D.scale(vec2, 1.0 / Math.sqrt(v2lenSq));
        return vec1n.dot(vec2n);
    }

    public static boolean areParallel(Vector3d vec1, Vector3d vec2, double tol) {
        double dotTest = Util3D.dirDotTest(vec1, vec2, tol);
        return Double.isNaN(dotTest) || Math.abs(Math.abs(dotTest) - 1.0) <= tol;
    }

    public static boolean arePerpendicular(Vector3d vec1, Vector3d vec2, double tol) {
        double dotTest = Util3D.dirDotTest(vec1, vec2, tol);
        return Double.isNaN(dotTest) || Math.abs(dotTest) <= tol;
    }

    public static boolean areAligned(Point3d p1, Vector3d v1, Point3d p2, Vector3d v2, double tol) {
        return Util3D.areParallel(v1, v2, tol) && Util3D.areParallel(v1, Util3D.vector(p1, p2), tol);
    }

    public static boolean pointSameDir(Vector3d vec1, Vector3d vec2, double tol) {
        double dotTest = Util3D.dirDotTest(vec1, vec2, tol);
        return Double.isNaN(dotTest) || Math.abs(dotTest - 1.0) <= tol;
    }

    public static Vector3d rotate(Vector3d vec, Vector3d axis, double angleRad) {
        AxisAngle4d aa = new AxisAngle4d(axis, angleRad);
        Matrix4d mat = new Matrix4d();
        mat.setIdentity();
        mat.setRotation(aa);
        Vector3d v = new Vector3d(vec);
        mat.transform(v);
        return v;
    }

    public static boolean isVecZero(Vector3d vec) {
        return vec.epsilonEquals(VEC_ZERO, 1.0E-9);
    }

    public static double tOnLineSeg(Point3d l1, Point3d l2, Point3d p) {
        double l1l2x = l2.x - l1.x;
        double l1l2y = l2.y - l1.y;
        double l1l2z = l2.z - l1.z;
        double l1px = p.x - l1.x;
        double l1py = p.y - l1.y;
        double l1pz = p.z - l1.z;
        double dot = l1l2x * l1px + l1l2y * l1py + l1l2z * l1pz;
        double lensq = l1l2x * l1l2x + l1l2y * l1l2y + l1l2z * l1l2z;
        return dot / lensq;
    }

    public static double tOnLine(Point3d lp, Vector3d ldir, Point3d p) {
        double l1px = p.x - lp.x;
        double l1py = p.y - lp.y;
        double l1pz = p.z - lp.z;
        double dot = ldir.x * l1px + ldir.y * l1py + ldir.z * l1pz;
        return dot / ldir.lengthSquared();
    }

    public static Point3d round(Point3d p, int numDecimals) {
        return new Point3d(theMath.round(p.x, numDecimals), theMath.round(p.y, numDecimals), theMath.round(p.z, numDecimals));
    }

    public static Point3d round(Point3d p, double tol) {
        return new Point3d(theMath.round(p.x, tol), theMath.round(p.y, tol), theMath.round(p.z, tol));
    }

    public static double lineAngle(Vector3d l1, Vector3d l2) {
        double vangle = l1.angle(l2);
        assert (vangle >= 0.0);
        return vangle > 1.5707963267948966 ? Math.PI - vangle : vangle;
    }

    public static double angle(Vector3d v1, Vector3d v2, Vector3d axis) {
        double absAngle = v1.angle(v2);
        Vector3d cross = Util3D.cross(v1, v2);
        double dot = cross.dot(axis);
        return dot >= 0.0 ? absAngle : -absAngle;
    }

    public static double angle0To2PI(Vector3d v1, Vector3d v2, Vector3d axis) {
        if (v1.equals(v2)) {
            return 0.0;
        }
        double absAngle = v1.angle(v2);
        Vector3d cross = Util3D.cross(v1, v2);
        double dot = cross.dot(axis);
        return dot >= 0.0 ? absAngle : Math.PI * 2 - absAngle;
    }

    public static Point2d to2d(Point3d p) {
        return new Point2d(p.x, p.y);
    }

    public static Vector2d to2d(Vector2d v) {
        return new Vector2d(v.x, v.y);
    }

    public static Point2d xform2d(Matrix4d xform, Point3d p) {
        return Util3D.xform2d(xform, p, false);
    }

    public static Point2d xform2d(Matrix4d xform, Point3d p, boolean normalize) {
        p = Util3D.xform(xform, p, normalize);
        return new Point2d(p.x, p.y);
    }

    public static Point3d xform(Matrix4d xform, Point3d p) {
        return Util3D.xform(xform, p, false);
    }

    public static Point3d xform(Matrix4d xform, Point3d p, boolean normalize) {
        p = new Point3d(p);
        if (normalize) {
            Util3D.normalizedXform(xform, p);
        } else {
            xform.transform(p);
        }
        return p;
    }

    public static Point3d xformEq(Matrix4d xform, Point3d p) {
        return Util3D.xformEq(xform, p, false);
    }

    public static Point3d xformEq(Matrix4d xform, Point3d p, boolean normalize) {
        if (normalize) {
            Util3D.normalizedXform(xform, p);
        } else {
            xform.transform(p);
        }
        return p;
    }

    public static Vector3d xform(Matrix4d xform, Vector3d p) {
        p = new Vector3d(p);
        xform.transform(p);
        return p;
    }

    public static void normalizedXform(Matrix4d xform, Point3d p) {
        double x = xform.m00 * p.x + xform.m01 * p.y + xform.m02 * p.z + xform.m03;
        double y = xform.m10 * p.x + xform.m11 * p.y + xform.m12 * p.z + xform.m13;
        double z = xform.m20 * p.x + xform.m21 * p.y + xform.m22 * p.z + xform.m23;
        double iw = 1.0 / (xform.m30 * p.x + xform.m31 * p.y + xform.m32 * p.z + xform.m33);
        p.x = x * iw;
        p.y = y * iw;
        p.z = z * iw;
    }

    private static double randomVecComp(Random rand) {
        return rand.nextDouble() * 2.0 - 1.0;
    }

    public static Vector3d newRandomVector(Random rand) {
        Vector3d v = new Vector3d(Util3D.randomVecComp(rand), Util3D.randomVecComp(rand), Util3D.randomVecComp(rand));
        v.normalize();
        return v;
    }

    public static double simplePolygonArea(List<Point3d> verts, Vector3d posAxis) {
        Vector3d cross = Util3D.simplePolygonCross(verts);
        if (cross == null) {
            return 0.0;
        }
        double area = 0.5 * cross.length();
        if (posAxis != null && cross.dot(posAxis) < 0.0) {
            area = -area;
        }
        return area;
    }

    public static double simplePolygonArea(List<Point3d> verts) {
        return Util3D.simplePolygonArea(verts, null);
    }

    public static Vector3d simplePolygonNormal(List<Point3d> verts) {
        return Util3D.simplePolygonNormal(verts, 0.0);
    }

    public static Vector3d simplePolygonNormal(List<Point3d> verts, double tol) {
        Vector3d normal = Util3D.simplePolygonCross(verts);
        if (normal == null || theUtil.eq0(normal.lengthSquared(), tol * tol)) {
            return null;
        }
        normal.normalize();
        return normal;
    }

    public static Plane3d simplePolygonPlane(List<Point3d> verts) {
        return Util3D.simplePolygonPlane(verts, 0.0);
    }

    public static Plane3d simplePolygonPlane(List<Point3d> verts, double tol) {
        Vector3d normal = Util3D.simplePolygonNormal(verts, tol);
        if (normal == null) {
            return null;
        }
        return new Plane3d(normal, verts.get(0));
    }

    private static Vector3d simplePolygonCross(List<Point3d> verts) {
        if (verts.size() < 3) {
            return null;
        }
        Point3d first = verts.get(0);
        int end = first.equals(verts.get(verts.size() - 1)) ? verts.size() - 1 : verts.size();
        double ax = 0.0;
        double ay = 0.0;
        double az = 0.0;
        Point3d p2 = verts.get(1);
        double p1x = p2.x - first.x;
        double p1y = p2.y - first.y;
        double p1z = p2.z - first.z;
        for (int m = 2; m < end; ++m) {
            Point3d curr = verts.get(m);
            double p2x = curr.x - first.x;
            double p2y = curr.y - first.y;
            double p2z = curr.z - first.z;
            ax += p1y * p2z - p2y * p1z;
            ay += p1z * p2x - p2z * p1x;
            az += p1x * p2y - p2x * p1y;
            p1x = p2x;
            p1y = p2y;
            p1z = p2z;
        }
        return new Vector3d(ax, ay, az);
    }

    public static Point3d simplePolygonCentroid(Point3d ... points) {
        double area = Util3D.simplePolygonArea(Arrays.asList(points));
        if (area == 0.0) {
            return null;
        }
        assert (points.length >= 3);
        Point3d first = points[0];
        int end = first.equals(points[points.length - 1]) ? points.length - 1 : points.length;
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        Vector3d v1 = Util3D.vector(first, points[1]);
        Vector3d v2 = new Vector3d();
        Vector3d cross = new Vector3d();
        for (int m = 2; m < end; ++m) {
            Point3d p2 = points[m];
            v2.sub(p2, first);
            cross.cross(v1, v2);
            double temp = cross.length();
            cx += (v1.x + v2.x) * temp;
            cy += (v1.y + v2.y) * temp;
            cz += (v1.z + v2.z) * temp;
            v1.set(v2);
        }
        double mult = 1.0 / (6.0 * area);
        return new Point3d(first.x + mult * cx, first.y + mult * cy, first.z + mult * cz);
    }

    public static boolean areCoplanar(double tol, Point3d ... points) {
        if (points.length < 3) {
            return true;
        }
        Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(points));
        if (plane == null) {
            return false;
        }
        for (Point3d p : points) {
            double dist = Math.abs(plane.distance(p));
            if (theUtil.eq0(dist, tol)) continue;
            return false;
        }
        return true;
    }

    public static int[] getNonCoplanar(double tol, Point3d ... points) {
        if (points.length < 3) {
            return new int[0];
        }
        Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(points));
        if (plane == null) {
            int[] all = new int[points.length];
            for (int m = 0; m < all.length; ++m) {
                all[m] = m;
            }
            return all;
        }
        ArrayList<Integer> invalid = new ArrayList<Integer>();
        for (int m = 0; m < points.length; ++m) {
            Point3d p = points[m];
            double dist = Math.abs(plane.distance(p));
            if (theUtil.eq0(dist, tol)) continue;
            invalid.add(m);
        }
        return theUtil.toIntArray(invalid);
    }

    public static boolean isConvex(double tol, Point3d ... points) {
        int m;
        if (points.length < 3) {
            return false;
        }
        double tolSq = tol * tol;
        Vector3d prevVec = new Vector3d();
        Vector3d prevCross = new Vector3d();
        Vector3d nextVec = new Vector3d();
        Vector3d nextCross = new Vector3d();
        prevVec.sub(points[1], points[0]);
        for (m = 1; m < points.length; ++m) {
            Point3d p1 = points[m];
            Point3d p2 = points[(m + 1) % points.length];
            nextVec.sub(p2, p1);
            prevCross.cross(prevVec, nextVec);
            if (prevCross.lengthSquared() >= tolSq) {
                prevVec.set(nextVec);
                break;
            }
            if (!(prevVec.dot(nextVec) < 0.0)) continue;
            return false;
        }
        if (m == points.length) {
            return false;
        }
        double prevDot = 0.0;
        ++m;
        while (m <= points.length) {
            Point3d p1 = points[m % points.length];
            Point3d p2 = points[(m + 1) % points.length];
            nextVec.sub(p2, p1);
            nextCross.cross(prevVec, nextVec);
            if (nextCross.dot(nextCross) >= tolSq) {
                double dot = prevCross.dot(nextCross);
                if (prevDot == 0.0) {
                    prevDot = dot;
                } else if (prevDot < 0.0 && dot > 0.0 || prevDot > 0.0 && dot < 0.0) {
                    return false;
                }
                prevVec.set(nextVec);
                prevCross.set(nextCross);
            } else if (prevVec.dot(nextVec) < 0.0) {
                return false;
            }
            ++m;
        }
        return true;
    }

    public static boolean rectify(Point3d min, Point3d max) {
        double temp;
        boolean rectified = false;
        if (max.x < min.x) {
            temp = max.x;
            max.x = min.x;
            min.x = temp;
            rectified = true;
        }
        if (max.y < min.y) {
            temp = max.y;
            max.y = min.y;
            min.y = temp;
            rectified = true;
        }
        if (max.z < min.z) {
            temp = max.z;
            max.z = min.z;
            min.z = temp;
            rectified = true;
        }
        return rectified;
    }

    public static Point3d lerp(Point3d p1, Point3d p2, double t) {
        return new Point3d(theUtil.lerp(p1.x, p2.x, t), theUtil.lerp(p1.y, p2.y, t), theUtil.lerp(p1.z, p2.z, t));
    }

    public static Vector3d slerp(Vector3d v1, Vector3d v2, double t) {
        if (v1.epsilonEquals(v2, 1.0E-9)) {
            return new Vector3d(v2);
        }
        double angle = v1.angle(v2);
        Vector3d axis = Util3D.cross(v1, v2);
        AxisAngle4d aa = new AxisAngle4d(axis, 0.0);
        Quat4d quat0 = new Quat4d();
        quat0.set(aa);
        aa = new AxisAngle4d(axis, angle);
        Quat4d quat1 = new Quat4d();
        quat1.set(aa);
        quat0.interpolate(quat1, t);
        Matrix4d xform = new Matrix4d();
        xform.set(quat0);
        return Util3D.xform(xform, v1);
    }

    public static Point3d[] deleteDupPoints(double distTol, boolean wrap, Point3d ... points) {
        int firstIx;
        if (points.length == 0) {
            return points;
        }
        double tolSq = distTol * distTol;
        BitSet validPoints = null;
        if (wrap) {
            firstIx = points.length - 1;
            secondIx = 0;
        } else {
            firstIx = 0;
            secondIx = 1;
        }
        Point3d prevPoint = points[firstIx];
        for (int m = secondIx; m < points.length; ++m) {
            Point3d p = points[m];
            if (prevPoint.distanceSquared(p) <= tolSq) {
                if (validPoints == null) {
                    validPoints = new BitSet(points.length);
                    validPoints.set(0, points.length);
                }
                validPoints.clear(m);
                continue;
            }
            prevPoint = p;
        }
        if (validPoints == null) {
            return points;
        }
        Point3d[] newPoints = new Point3d[validPoints.cardinality()];
        int ix = 0;
        for (int m = 0; m < points.length; ++m) {
            if (!validPoints.get(m)) continue;
            newPoints[ix++] = points[m];
        }
        return newPoints;
    }
}

