/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;

public class BoundingSphere
implements ITest<AABox> {
    public final Point3d center = new Point3d();
    public double radius = -1.0;

    public BoundingSphere() {
    }

    public BoundingSphere(Point3d center, double radius) {
        this.set(center, radius);
    }

    public BoundingSphere(BoundingSphere s) {
        this.set(s);
    }

    public BoundingSphere(AABox bb) {
        this.set(bb);
    }

    public BoundingSphere reset() {
        this.radius = -1.0;
        return this;
    }

    public void set(Point3d center, double radius) {
        this.center.set(center);
        this.radius = radius;
    }

    public void set(AABox bb) {
        this.center.add(bb.getMin(), bb.getMax());
        this.center.scale(0.5);
        this.radius = this.center.distance(bb.getMax());
    }

    public void set(BoundingSphere bs) {
        this.center.set(bs.center);
        this.radius = bs.radius;
    }

    public boolean isValid() {
        return this.radius >= 0.0;
    }

    public BoundingSphere addEq(Point3d p) {
        if (!this.isValid()) {
            this.center.set(p);
            this.radius = 0.0;
            return this;
        }
        double rSq = this.radius * this.radius;
        Vector3d vec = new Vector3d();
        vec.sub(p, this.center);
        double veclenSq = vec.lengthSquared();
        if (veclenSq <= rSq) {
            return this;
        }
        double veclen = Math.sqrt(veclenSq);
        this.radius = 0.5 * (this.radius + veclen);
        double scale = -this.radius / veclen;
        vec.scale(scale);
        this.center.add(p, vec);
        return this;
    }

    public BoundingSphere addEq(BoundingSphere bs) {
        if (!bs.isValid()) {
            return this;
        }
        if (!this.isValid()) {
            this.set(bs);
            return this;
        }
        Vector3d vec = new Vector3d();
        vec.sub(bs.center, this.center);
        double veclen = vec.length();
        double scale = 1.0 + bs.radius / veclen;
        vec.scale(scale);
        Point3d p = new Point3d();
        p.add(this.center, vec);
        return this.addEq(p);
    }

    public BoundingSphere scaleEq(double scale) {
        this.center.scale(scale);
        this.radius *= scale;
        return this;
    }

    @Deprecated
    public int contains(AABox bb) {
        return Inter3D.sphereContainsAABB(this.center, this.radius * this.radius, bb.getMin(), bb.getMax());
    }

    @Override
    public Containment test(AABox bb) {
        return Inter3D.testSphereAABB(this.center, this.radius * this.radius, bb.getMin(), bb.getMax());
    }
}

