/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ISearchVol;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IContainer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;

public class ARTree<T, VolT extends ISearchVol>
implements IContainer<T, VolT>,
Serializable {
    private static final long serialVersionUID = -2674551795712987515L;
    public static final int DEF_MIN_FILL = 2;
    public static final int DEF_MAX_FILL = 4;
    private Map<T, RTreeNode<VolT>> d_nodeLookupMap;
    private RTreeNode<VolT> d_root;
    private int d_maxFill;
    private int d_minFill;
    private static int leaf_level;

    public ARTree() {
        this(2, 4);
    }

    public ARTree(int minFill, int maxFill) {
        this.d_maxFill = maxFill;
        this.d_minFill = minFill;
        this.d_root = new RTreeLeaf(this.d_maxFill);
        this.d_nodeLookupMap = this.newLookupMap();
    }

    public Map<T, VolT> getCachedBounds() {
        LinkedIdentityHashMap bounds = new LinkedIdentityHashMap(this.d_nodeLookupMap.size());
        this.getCachedBounds(bounds, this.d_root);
        return bounds;
    }

    private void getCachedBounds(Map<T, VolT> map, RTreeNode<VolT> node) {
        if (node.isLeaf()) {
            RTreeLeaf<VolT> leaf = node.asLeaf();
            for (int m = 0; m < leaf.d_numEntries; ++m) {
                map.put(leaf.d_entry[m].asLeaf().d_data, leaf.d_entry[m].d_box);
            }
        } else {
            RTreeBranch<VolT> branch = node.asBranch();
            for (int m = 0; m < branch.d_numEntries; ++m) {
                this.getCachedBounds(map, branch.d_entry[m].asBranch().d_child);
            }
        }
    }

    private Map<T, RTreeNode<VolT>> newLookupMap() {
        return new IdentityHashMap();
    }

    public boolean isEmpty() {
        return this.d_root.d_numEntries == 0;
    }

    public int getMinFill() {
        return this.d_minFill;
    }

    public int getMaxFill() {
        return this.d_maxFill;
    }

    protected void clone(ARTree<T, VolT> clone, Map<T, T> cloneMap) {
        clone.d_root = this.d_root.clone(cloneMap);
        clone.d_root.buildLookupMap(clone.d_nodeLookupMap);
    }

    public void pauseCondensing() {
    }

    public void resumeCondensing() {
    }

    public boolean insert(VolT box, T obj) {
        if (!box.isValid()) {
            return false;
        }
        LeafEntry<T, VolT> entry = new LeafEntry<T, VolT>(box, obj);
        RTreeNode leaf = this.chooseLeaf(entry);
        if (leaf.d_numEntries < this.d_maxFill) {
            leaf.setEntry(leaf.d_numEntries++, entry, this.d_nodeLookupMap);
            this.adjustTree(leaf, null);
        } else {
            RTreeNode newLeaf = this.splitNode(leaf, entry);
            RTreeNode<VolT> newNode = this.adjustTree(leaf, newLeaf);
            if (newNode != null) {
                VolT b1 = ARTree.calcBox(this.d_root);
                VolT b2 = ARTree.calcBox(newNode);
                RTreeBranch<VolT> newRoot = new RTreeBranch<VolT>(this.d_maxFill);
                ((RTreeNode)newRoot).setEntry(0, new BranchEntry<VolT>(b1, this.d_root), this.d_nodeLookupMap);
                ((RTreeNode)newRoot).setEntry(1, new BranchEntry<VolT>(b2, newNode), this.d_nodeLookupMap);
                newRoot.d_numEntries = 2;
                this.d_root = newRoot;
            }
        }
        return true;
    }

    public boolean remove(T obj) {
        int i;
        RTreeNode<VolT> leaf = this.d_nodeLookupMap.remove(obj);
        if (leaf == null) {
            return false;
        }
        if (this.d_nodeLookupMap.isEmpty()) {
            this.d_nodeLookupMap = this.newLookupMap();
        }
        for (i = 0; i < leaf.d_numEntries; ++i) {
            LeafEntry leafentry = leaf.d_entry[i].asLeaf();
            if (leafentry.d_data == obj) break;
        }
        leaf.removeEntry(i);
        this.condenseTree(leaf);
        if (leaf != this.d_root && this.d_root.d_numEntries == 1) {
            RTreeNode<VolT> tmp = this.d_root;
            this.d_root = this.d_root.asBranch().getChild(0);
            this.d_root.d_parent = null;
            tmp.d_entry[0] = null;
            tmp.d_numEntries = 0;
            tmp = null;
        }
        return true;
    }

    public void clear() {
        this.d_root = new RTreeLeaf(this.d_maxFill);
        this.d_nodeLookupMap = this.newLookupMap();
    }

    @Override
    @Deprecated
    public void find(ITest<VolT> test, IRTreeTestResult<? super T> result) {
        this.find(new TestWrapper<VolT>(test), (IResult<? super T>)new ResultWrapper<T>(result));
    }

    @Override
    public void find(pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest<VolT> test, IResult<? super T> result) {
        ARTree.search(this.d_root, test, result);
    }

    private static <T, VolT extends ISearchVol> void search(RTreeNode<VolT> tree, pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest<VolT> test, IResult<? super T> result) {
        block4: for (int i = 0; i < tree.d_numEntries; ++i) {
            Containment contain = test.test(tree.d_entry[i].d_box);
            switch (contain) {
                case INSIDE: {
                    LeafEntry leaf;
                    if (tree.isLeaf()) {
                        leaf = tree.d_entry[i].asLeaf();
                        result.mark(leaf.d_data, Containment.INSIDE);
                        continue block4;
                    }
                    BranchEntry branch = tree.d_entry[i].asBranch();
                    ARTree.getAllObjects(branch.d_child, result);
                    continue block4;
                }
                case INTERSECTS: {
                    LeafEntry leaf;
                    if (tree.isLeaf()) {
                        leaf = tree.d_entry[i].asLeaf();
                        result.mark(leaf.d_data, Containment.INTERSECTS);
                        continue block4;
                    }
                    BranchEntry branch = tree.d_entry[i].asBranch();
                    ARTree.search(branch.d_child, test, result);
                }
            }
        }
    }

    @Override
    public void getAll(IResult<? super T> result) {
        ARTree.getAllObjects(this.d_root, result);
    }

    private static <T, VolT extends ISearchVol> void getAllObjects(RTreeNode<VolT> tree, IResult<? super T> result) {
        if (tree.isLeaf()) {
            for (int i = 0; i < tree.d_numEntries; ++i) {
                LeafEntry entry = tree.d_entry[i].asLeaf();
                result.mark(entry.d_data, Containment.INSIDE);
            }
        } else {
            for (int i = 0; i < tree.d_numEntries; ++i) {
                BranchEntry branch = tree.d_entry[i].asBranch();
                ARTree.getAllObjects(branch.d_child, result);
            }
        }
    }

    public VolT getBounds(VolT bb) {
        if (this.d_root == null) {
            return bb;
        }
        for (int m = 0; m < this.d_root.d_numEntries; ++m) {
            bb.add((ISearchVol)this.d_root.d_entry[m].d_box);
        }
        return bb;
    }

    public VolT getBoundingBox(VolT bb) {
        return this.getBounds((T)bb);
    }

    public VolT getBounds(T obj) {
        RTreeNode<VolT> node = this.d_nodeLookupMap.get(obj);
        if (node == null) {
            return null;
        }
        for (int i = 0; i < node.d_numEntries; ++i) {
            LeafEntry leafentry = node.d_entry[i].asLeaf();
            if (leafentry.d_data != obj) continue;
            return (VolT)leafentry.d_box;
        }
        return null;
    }

    private static <VolT extends ISearchVol> int getlevel(RTreeNode<VolT> node) {
        int level = 0;
        RTreeNode p = node.d_parent;
        while (p != null) {
            ++level;
            p = p.d_parent;
        }
        return level;
    }

    public int validate() {
        leaf_level = -1;
        return ARTree.validate(this.d_root, 0);
    }

    private static <VolT extends ISearchVol> int validate(RTreeNode<VolT> node, int level) {
        int lev = ARTree.getlevel(node);
        assert (lev == level);
        if (node.isLeaf()) {
            if (leaf_level == -1) {
                leaf_level = lev;
            }
            assert (lev == leaf_level);
            return 1;
        }
        for (int i = 0; i < node.d_numEntries; ++i) {
            if (node.asBranch().getChild((int)i).d_parent != node) {
                assert (false);
                return 0;
            }
            if (ARTree.validate(node.asBranch().getChild(i), level + 1) != 0) continue;
            return 0;
        }
        return 1;
    }

    public int count() {
        return ARTree.count(this.d_root);
    }

    private static int count(RTreeNode node) {
        if (node.isLeaf()) {
            return node.d_numEntries;
        }
        int num = 0;
        RTreeBranch branch = node.asBranch();
        for (int i = 0; i < node.d_numEntries; ++i) {
            num += ARTree.count(branch.getChild(i));
        }
        return num;
    }

    public int countNodes() {
        return ARTree.countNodes(this.d_root);
    }

    private static int countNodes(RTreeNode node) {
        if (node.isLeaf()) {
            return 1;
        }
        int num = 1;
        RTreeBranch branch = node.asBranch();
        for (int i = 0; i < node.d_numEntries; ++i) {
            num += ARTree.countNodes(branch.getChild(i));
        }
        return num;
    }

    private RTreeNode chooseLeaf(RTreeEntry entry) {
        RTreeNode<VolT> node = this.d_root;
        while (!node.isLeaf()) {
            double minAreaChange = Double.MAX_VALUE;
            RTreeEntry bestEntry = null;
            for (int i = 0; i < node.d_numEntries; ++i) {
                ISearchVol newBox = (ISearchVol)node.d_entry[i].d_box.clone();
                newBox.add((ISearchVol)entry.d_box);
                double newBoxArea = newBox.volumeEps();
                double entryBoxArea = node.d_entry[i].d_box.volumeEps();
                double areaChange = newBoxArea - entryBoxArea;
                if (areaChange < minAreaChange) {
                    minAreaChange = areaChange;
                    bestEntry = node.d_entry[i];
                    continue;
                }
                if (areaChange != minAreaChange || !(newBoxArea < bestEntry.d_box.volumeEps())) continue;
                bestEntry = node.d_entry[i];
            }
            node = bestEntry.asBranch().d_child;
        }
        return node;
    }

    private RTreeNode splitNode(RTreeNode node, RTreeEntry entry) {
        int i;
        RTreeEntry[] entryList = new RTreeEntry[this.d_maxFill + 1];
        int[] assigned = new int[this.d_maxFill + 1];
        assert (node.d_numEntries == this.d_maxFill);
        for (i = 0; i < this.d_maxFill; ++i) {
            entryList[i] = node.d_entry[i];
            assigned[i] = 0;
        }
        entryList[this.d_maxFill] = entry;
        assigned[this.d_maxFill] = 0;
        RTreeEntry[] group1 = new RTreeEntry[this.d_maxFill];
        RTreeEntry[] group2 = new RTreeEntry[this.d_maxFill];
        int numGroup1 = 0;
        int numGroup2 = 0;
        int[] entries = this.QpickSeeds(entryList);
        group1[numGroup1++] = entryList[entries[0]];
        assigned[entries[0]] = 1;
        Object box1 = entryList[entries[0]].d_box;
        group2[numGroup2++] = entryList[entries[1]];
        assigned[entries[1]] = 1;
        Object box2 = entryList[entries[1]].d_box;
        while (numGroup1 + numGroup2 < this.d_maxFill + 1) {
            if (this.d_minFill - numGroup1 >= this.d_maxFill + 1 - numGroup1 - numGroup2) {
                for (i = 0; i < this.d_maxFill + 1; ++i) {
                    if (assigned[i] != 0) continue;
                    group1[numGroup1++] = entryList[i];
                }
                continue;
            }
            if (this.d_minFill - numGroup2 >= this.d_maxFill + 1 - numGroup1 - numGroup2) {
                for (i = 0; i < this.d_maxFill + 1; ++i) {
                    if (assigned[i] != 0) continue;
                    group2[numGroup2++] = entryList[i];
                }
                continue;
            }
            int next = this.QpickNext(entryList, assigned, box1, box2);
            ISearchVol new1 = (ISearchVol)box1.clone();
            new1.add((ISearchVol)entryList[next].d_box);
            ISearchVol new2 = (ISearchVol)box2.clone();
            new2.add((ISearchVol)entryList[next].d_box);
            if (new1.volumeEps() - box1.volumeEps() < new2.volumeEps() - box2.volumeEps()) {
                group1[numGroup1++] = entryList[next];
                assigned[next] = 1;
                continue;
            }
            group2[numGroup2++] = entryList[next];
            assigned[next] = 1;
        }
        for (i = 0; i < numGroup1; ++i) {
            node.setEntry(i, group1[i], this.d_nodeLookupMap);
        }
        while (i < node.d_entry.length) {
            node.d_entry[i] = null;
            ++i;
        }
        node.d_numEntries = numGroup1;
        RTreeNode newNode = null;
        newNode = node.isLeaf() ? new RTreeLeaf(this.d_maxFill) : new RTreeBranch(this.d_maxFill);
        newNode.d_parent = node.d_parent;
        for (i = 0; i < numGroup2; ++i) {
            newNode.setEntry(i, group2[i], this.d_nodeLookupMap);
        }
        newNode.d_numEntries = numGroup2;
        return newNode;
    }

    private RTreeNode<VolT> adjustTree(RTreeNode<VolT> node1, RTreeNode<VolT> node2) {
        RTreeNode<VolT> N = node1;
        RTreeNode<VolT> NN = node2;
        while (N != this.d_root) {
            VolT box = ARTree.calcBox(N);
            RTreeBranch parent = N.d_parent.asBranch();
            for (int i = 0; i < parent.d_numEntries; ++i) {
                if (parent.getChild(i) != N) continue;
                parent.d_entry[i].d_box = box;
            }
            RTreeNode newNode = null;
            if (NN != null) {
                box = ARTree.calcBox(NN);
                BranchEntry<VolT> entry = new BranchEntry<VolT>(box, NN);
                if (parent.d_numEntries < this.d_maxFill) {
                    parent.d_entry[parent.d_numEntries++] = entry;
                } else {
                    newNode = this.splitNode(parent, entry);
                }
            }
            N = parent;
            NN = newNode;
        }
        return NN;
    }

    private void condenseTree(RTreeNode<VolT> node) {
        this.forceCondense(node);
    }

    private void forceCondense(RTreeNode<VolT> node) {
        ArrayList<EliminatedNode<VolT>> eliminatedNodes = new ArrayList<EliminatedNode<VolT>>();
        RTreeNode<VolT> N = node;
        int level = 0;
        assert (node.isLeaf());
        while (N != this.d_root) {
            int n;
            RTreeBranch P = N.d_parent.asBranch();
            for (n = 0; n < P.d_numEntries && P.getChild(n) != N; ++n) {
            }
            if (N.d_numEntries < this.d_minFill) {
                P.removeEntry(n);
                eliminatedNodes.add(new EliminatedNode<VolT>(N, level));
            } else {
                P.d_entry[n].d_box = ARTree.calcBox(N);
            }
            N = P;
            ++level;
        }
        for (EliminatedNode eliminatedNode : eliminatedNodes) {
            for (int j = 0; j < eliminatedNode.Node.d_numEntries; ++j) {
                this.insert(eliminatedNode.Node.d_entry[j], eliminatedNode.Level);
            }
        }
    }

    private void insert(RTreeEntry<VolT> entry, int level) {
        RTreeNode<VolT> leaf;
        RTreeNode<VolT> node = leaf = this.chooseLeaf(entry);
        for (int i = 0; i < level; ++i) {
            node = node.d_parent;
        }
        assert (node != null);
        if (node.d_numEntries < this.d_maxFill) {
            node.setEntry(node.d_numEntries++, entry, this.d_nodeLookupMap);
            this.adjustTree(node, null);
        } else {
            RTreeNode newNode = this.splitNode(node, entry);
            if ((newNode = this.adjustTree(node, newNode)) != null) {
                VolT b1 = ARTree.calcBox(this.d_root);
                Object b2 = ARTree.calcBox(newNode);
                RTreeBranch newRoot = new RTreeBranch(this.d_maxFill);
                newRoot.d_parent = null;
                ((RTreeNode)newRoot).setEntry(0, new BranchEntry<VolT>(b1, this.d_root), this.d_nodeLookupMap);
                ((RTreeNode)newRoot).setEntry(1, new BranchEntry(b2, newNode), this.d_nodeLookupMap);
                newRoot.d_numEntries = 2;
                this.d_root = newRoot;
            }
        }
    }

    private static <VolT extends ISearchVol> VolT calcBox(RTreeNode<VolT> node) {
        assert (node.d_numEntries > 0);
        ISearchVol box = (ISearchVol)node.d_entry[0].d_box.clone();
        for (int i = 1; i < node.d_numEntries; ++i) {
            box.add((ISearchVol)node.d_entry[i].d_box);
        }
        return (VolT)box;
    }

    private int[] QpickSeeds(RTreeEntry[] entryList) {
        double maxWaste = -1.0;
        int e1 = 0;
        int e2 = 0;
        for (int i = 0; i < this.d_maxFill + 1; ++i) {
            for (int j = 0; j < this.d_maxFill + 1; ++j) {
                if (i == j) continue;
                ISearchVol box = (ISearchVol)entryList[i].d_box.clone();
                box.add((ISearchVol)entryList[j].d_box);
                double waste = box.volumeEps() - entryList[i].d_box.volumeEps() - entryList[j].d_box.volumeEps();
                if (maxWaste == -1.0) {
                    maxWaste = waste;
                    e1 = i;
                    e2 = j;
                    continue;
                }
                if (!(waste > maxWaste)) continue;
                maxWaste = waste;
                e1 = i;
                e2 = j;
            }
        }
        return new int[]{e1, e2};
    }

    private int QpickNext(RTreeEntry[] entryList, int[] assigned, VolT box2, VolT box1) {
        double maxDiff = -1.0;
        int entry = 0;
        for (int i = 0; i < this.d_maxFill + 1; ++i) {
            if (assigned[i] != 0) continue;
            ISearchVol b1 = (ISearchVol)entryList[i].d_box.clone();
            b1.add((ISearchVol)box1);
            ISearchVol b2 = (ISearchVol)entryList[i].d_box.clone();
            b2.add((ISearchVol)box2);
            double d1 = b1.volumeEps() - box1.volumeEps();
            double d2 = b2.volumeEps() - box2.volumeEps();
            if (maxDiff == -1.0) {
                maxDiff = Math.abs(d2 - d1);
                entry = i;
                continue;
            }
            double diff = Math.abs(d2 - d1);
            if (!(diff > maxDiff)) continue;
            maxDiff = diff;
            entry = i;
        }
        return entry;
    }

    private static class RTreeLeaf<VolT extends ISearchVol>
    extends RTreeNode<VolT>
    implements Serializable {
        private static final long serialVersionUID = -1528907801002008437L;

        public RTreeLeaf(int numEntries) {
            super(numEntries);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public <T> void setEntry(int ix, RTreeEntry<VolT> entry, Map<T, RTreeNode<VolT>> nodeMap) {
            super.setEntry(ix, entry, nodeMap);
            LeafEntry lentry = entry.asLeaf();
            nodeMap.put(lentry.d_data, this);
        }

        @Override
        protected <T> RTreeNode<VolT> clone(Map<T, T> cloneMap) {
            RTreeLeaf<VolT> clone = new RTreeLeaf<VolT>(this.d_entry.length);
            clone.d_numEntries = this.d_numEntries;
            for (int m = 0; m < this.d_numEntries; ++m) {
                LeafEntry entry = this.d_entry[m].asLeaf();
                T dataClone = cloneMap.get(entry.d_data);
                clone.d_entry[m] = new LeafEntry<T, ISearchVol>(entry.d_box, dataClone);
            }
            return clone;
        }

        @Override
        protected <T> void buildLookupMap(Map<T, RTreeNode<VolT>> nodeMap) {
            for (int m = 0; m < this.d_numEntries; ++m) {
                nodeMap.put(this.d_entry[m].asLeaf().d_data, this);
            }
        }
    }

    private static abstract class RTreeNode<VolT extends ISearchVol>
    implements Serializable {
        private static final long serialVersionUID = -1528907801002008435L;
        public RTreeNode<VolT> d_parent;
        public int d_numEntries;
        public RTreeEntry<VolT>[] d_entry;

        public RTreeNode(int numEntries) {
            this.d_entry = new RTreeEntry[numEntries];
            this.d_parent = null;
            this.d_numEntries = 0;
        }

        public abstract boolean isLeaf();

        public RTreeLeaf<VolT> asLeaf() {
            return (RTreeLeaf)this;
        }

        public RTreeBranch<VolT> asBranch() {
            return (RTreeBranch)this;
        }

        public <T> void setEntry(int ix, RTreeEntry<VolT> entry, Map<T, RTreeNode<VolT>> nodeMap) {
            this.d_entry[ix] = entry;
        }

        public void removeEntry(int i) {
            this.d_entry[i] = null;
            while (i < this.d_numEntries - 1) {
                this.d_entry[i] = this.d_entry[i + 1];
                ++i;
            }
            this.d_entry[i] = null;
            --this.d_numEntries;
        }

        public boolean isValid() {
            int m;
            int nonNullCount = 0;
            for (m = 0; m < this.d_entry.length; ++m) {
                if (this.d_entry[m] == null) continue;
                ++nonNullCount;
            }
            if (nonNullCount != this.d_numEntries) {
                return false;
            }
            for (m = 0; m < this.d_entry.length && this.d_entry[m] != null; ++m) {
                if (this.d_entry[m].isValid()) continue;
                return false;
            }
            ++m;
            while (m < this.d_entry.length) {
                if (this.d_entry[m] != null) {
                    return false;
                }
                ++m;
            }
            return true;
        }

        protected abstract <T> void buildLookupMap(Map<T, RTreeNode<VolT>> var1);

        protected abstract <T> RTreeNode<VolT> clone(Map<T, T> var1);
    }

    private static abstract class RTreeEntry<VolT extends ISearchVol>
    implements Serializable {
        private static final long serialVersionUID = -8218641300778690290L;
        public VolT d_box;

        public RTreeEntry(VolT box) {
            this.d_box = box;
        }

        public <T> LeafEntry<T, VolT> asLeaf() {
            return (LeafEntry)this;
        }

        public BranchEntry asBranch() {
            return (BranchEntry)this;
        }

        public boolean isValid() {
            return true;
        }
    }

    private static class LeafEntry<T, VolT extends ISearchVol>
    extends RTreeEntry<VolT>
    implements Serializable {
        private static final long serialVersionUID = -1604564689350726465L;
        public final T d_data;

        public LeafEntry(VolT box, T data) {
            super(box);
            this.d_data = data;
        }
    }

    private static class RTreeBranch<VolT extends ISearchVol>
    extends RTreeNode<VolT>
    implements Serializable {
        private static final long serialVersionUID = -1528907801002008436L;

        public RTreeBranch(int numEntries) {
            super(numEntries);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public RTreeNode<VolT> getChild(int i) {
            return this.d_entry[i].asBranch().d_child;
        }

        @Override
        public <T> void setEntry(int ix, RTreeEntry<VolT> entry, Map<T, RTreeNode<VolT>> nodeMap) {
            super.setEntry(ix, entry, nodeMap);
            this.d_entry[ix].asBranch().d_child.d_parent = this;
        }

        @Override
        public <T> RTreeNode<VolT> clone(Map<T, T> cloneMap) {
            RTreeBranch<VolT> clone = new RTreeBranch<VolT>(this.d_entry.length);
            clone.d_numEntries = this.d_numEntries;
            for (int m = 0; m < this.d_numEntries; ++m) {
                BranchEntry entry = this.d_entry[m].asBranch();
                RTreeNode nodeClone = entry.d_child.clone(cloneMap);
                nodeClone.d_parent = clone;
                clone.d_entry[m] = new BranchEntry<ISearchVol>(entry.d_box, nodeClone);
            }
            return clone;
        }

        @Override
        protected <T> void buildLookupMap(Map<T, RTreeNode<VolT>> nodeMap) {
            for (int m = 0; m < this.d_numEntries; ++m) {
                this.d_entry[m].asBranch().d_child.buildLookupMap(nodeMap);
            }
        }
    }

    private static class BranchEntry<VolT extends ISearchVol>
    extends RTreeEntry<VolT>
    implements Serializable {
        private static final long serialVersionUID = -3018167839772030290L;
        public final RTreeNode<VolT> d_child;

        public BranchEntry(VolT box, RTreeNode<VolT> child) {
            super(box);
            this.d_child = child;
        }

        @Override
        public boolean isValid() {
            return this.d_child.isValid();
        }
    }

    private static class TestWrapper<VolT>
    implements pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest<VolT>,
    Serializable {
        private static final long serialVersionUID = -1528907801002008438L;
        private final ITest<VolT> d_base;

        public TestWrapper(ITest<VolT> base) {
            this.d_base = base;
        }

        @Override
        public Containment test(VolT bounds) {
            int result = this.d_base.testContainment(bounds);
            switch (result) {
                case 0: {
                    return Containment.INSIDE;
                }
                case 1: {
                    return Containment.INTERSECTS;
                }
            }
            return Containment.OUTSIDE;
        }
    }

    @Deprecated
    public static interface ITest<VolT> {
        public int testContainment(VolT var1);
    }

    private static class ResultWrapper<T2>
    implements IResult<T2>,
    Serializable {
        private static final long serialVersionUID = -1528907801002008439L;
        private final IRTreeTestResult<T2> d_base;

        public ResultWrapper(IRTreeTestResult<T2> base) {
            this.d_base = base;
        }

        @Override
        public void mark(T2 obj, Containment ctmt) {
            switch (ctmt) {
                case INSIDE: {
                    if (!this.d_base.markInside(obj)) {
                        throw new CancellationException();
                    }
                }
                case INTERSECTS: {
                    if (this.d_base.markIntersecting(obj)) break;
                    throw new CancellationException();
                }
            }
        }
    }

    @Deprecated
    public static interface IRTreeTestResult<T2> {
        public boolean markInside(T2 var1);

        public boolean markIntersecting(T2 var1);
    }

    private static class EliminatedNode<VolT extends ISearchVol>
    implements Serializable {
        private static final long serialVersionUID = -6295586569639947296L;
        private final RTreeNode<VolT> Node;
        private final int Level;

        public EliminatedNode(RTreeNode<VolT> node, int level) {
            this.Node = node;
            this.Level = level;
        }
    }
}

